/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.textsize;

import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.swt.graphics.FontData;

class MeasurementItem {
    private final int wrapWidth;
    private final FontData fontData;
    private final String string;

    MeasurementItem(String textToMeasure, FontData fontData, int wrapWidth) {
        ParamCheck.notNull(textToMeasure, "textToMeasure");
        ParamCheck.notNull(fontData, "fontData");
        this.wrapWidth = wrapWidth;
        this.fontData = fontData;
        this.string = textToMeasure;
    }

    FontData getFontData() {
        return this.fontData;
    }

    String getTextToMeasure() {
        return this.string;
    }

    int getWrapWidth() {
        return this.wrapWidth;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.fontData.hashCode();
        result = 31 * result + this.string.hashCode();
        result = 31 * result + this.wrapWidth;
        return result;
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object != null && this.getClass() == object.getClass()) {
            if (this == object) {
                result = true;
            } else {
                MeasurementItem other = (MeasurementItem)object;
                result = this.fontData.equals(other.fontData) && this.string.equals(other.string) && this.wrapWidth == other.wrapWidth;
            }
        }
        return result;
    }
}

