/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.textsize;

import org.eclipse.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rwt.internal.textsize.BufferScrolledCompositeOriginsVisitor;
import org.eclipse.rwt.internal.textsize.ClearLayoutBuffersVisitor;
import org.eclipse.rwt.internal.textsize.EnlargeScrolledCompositeContentVisitor;
import org.eclipse.rwt.internal.textsize.RePackControlsVisitor;
import org.eclipse.rwt.internal.textsize.RestoreScrolledCompositeOriginsVisitor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.internal.widgets.IShellAdapter;
import org.eclipse.swt.internal.widgets.WidgetTreeVisitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

class TextSizeRecalculation {
    static final String KEY_SCROLLED_COMPOSITE_CONTENT_SIZE = "org.eclipse.rap.content-size";
    static final String KEY_SCROLLED_COMPOSITE_ORIGIN = "org.eclipse.rap.sc-origin";
    static final int RESIZE_OFFSET = 1000;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    TextSizeRecalculation() {
    }

    void execute() {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            this.forceShellRecalculations(shells[i]);
            ++i;
        }
    }

    private void forceShellRecalculations(Shell shell) {
        Rectangle boundsBuffer = shell.getBounds();
        this.bufferScrolledCompositeOrigins(shell);
        this.clearLayoutBuffers(shell);
        this.enlargeShell(shell);
        this.rePackControls(shell);
        this.enlargeScrolledCompositeContent(shell);
        this.clearLayoutBuffers(shell);
        this.restoreShellSize(shell, boundsBuffer);
        this.restoreScrolledCompositeOrigins(shell);
    }

    private void rePackControls(Shell shell) {
        WidgetTreeVisitor.accept(shell, new RePackControlsVisitor());
    }

    private void clearLayoutBuffers(Shell shell) {
        WidgetTreeVisitor.accept(shell, new ClearLayoutBuffersVisitor());
    }

    private void bufferScrolledCompositeOrigins(Shell shell) {
        WidgetTreeVisitor.accept(shell, new BufferScrolledCompositeOriginsVisitor());
    }

    private void enlargeScrolledCompositeContent(Shell shell) {
        WidgetTreeVisitor.accept(shell, new EnlargeScrolledCompositeContentVisitor());
    }

    private void restoreScrolledCompositeOrigins(Shell shell) {
        WidgetTreeVisitor.accept(shell, new RestoreScrolledCompositeOriginsVisitor());
    }

    private void restoreShellSize(Shell shell, Rectangle bufferedBounds) {
        this.setShellSize(shell, bufferedBounds);
    }

    private void enlargeShell(Shell shell) {
        Rectangle bounds = shell.getBounds();
        int xPos = bounds.x;
        int yPos = bounds.y;
        int width = bounds.width + 1000;
        int height = bounds.height + 1000;
        this.setShellSize(shell, new Rectangle(xPos, yPos, width, height));
    }

    private Shell[] getShells() {
        return this.getShells(this.getDisplay());
    }

    private Display getDisplay() {
        return LifeCycleUtil.getSessionDisplay();
    }

    private Shell[] getShells(Display display) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IDisplayAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = display.getAdapter(clazz);
        IDisplayAdapter displayAdapter = (IDisplayAdapter)adapter;
        return displayAdapter.getShells();
    }

    private void setShellSize(Shell shell, Rectangle bounds) {
        this.getShellAdapter(shell).setBounds(bounds);
    }

    private IShellAdapter getShellAdapter(Shell shell) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IShellAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IShellAdapter)shell.getAdapter(clazz);
    }
}

