/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.widgets.IToolTipAdapter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ToolTip
extends Widget {
    private final Shell parent;
    private boolean autoHide;
    private boolean visible;
    private String text;
    private String message;
    private int x;
    private int y;
    private IToolTipAdapter toolTipAdapter;
    static /* synthetic */ Class class$0;

    public ToolTip(Shell parent, int style) {
        super(parent, ToolTip.checkStyle(style));
        this.parent = parent;
        this.autoHide = true;
        this.text = "";
        this.message = "";
        Point cursorLocation = this.display.getCursorLocation();
        this.x = cursorLocation.x;
        this.y = cursorLocation.y;
        this.parent.createToolTip(this);
    }

    public Object getAdapter(Class adapter) {
        Object result;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IToolTipAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            if (this.toolTipAdapter == null) {
                this.toolTipAdapter = new IToolTipAdapter(){

                    public Point getLocation() {
                        return new Point(ToolTip.this.x, ToolTip.this.y);
                    }
                };
            }
            result = this.toolTipAdapter;
        } else {
            result = super.getAdapter(adapter);
        }
        return result;
    }

    public Shell getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getAutoHide() {
        this.checkWidget();
        return this.autoHide;
    }

    public void setAutoHide(boolean autoHide) {
        this.checkWidget();
        this.autoHide = autoHide;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        this.visible = visible;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public void setText(String text) {
        this.checkWidget();
        if (text == null) {
            this.error(4);
        }
        this.text = text;
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    public void setMessage(String message) {
        this.checkWidget();
        if (message == null) {
            this.error(4);
        }
        this.message = message;
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.x = x;
        this.y = y;
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            SWT.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.addListener(this, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.removeListener(this, listener);
    }

    String getNameText() {
        return this.text;
    }

    void releaseParent() {
        super.releaseParent();
        this.parent.destroyToolTip(this);
    }

    private static int checkStyle(int style) {
        int mask = 11;
        int result = (style & mask) == 0 ? style : ToolTip.checkBits(style, 2, 8, 1, 0, 0, 0);
        return result;
    }
}

