/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.internal.widgets.treekit.TreeThemeAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeColumn
extends Item {
    Tree parent;
    String displayText = "";
    int width;
    int itemImageWidth;
    boolean moveable;
    boolean resizable = true;
    int sort = 0;
    String toolTipText;
    int itemImageCount = 0;
    static final int SORT_INDICATOR_WIDTH = 10;
    static final int MARGIN_IMAGE = 3;
    static /* synthetic */ Class class$0;

    public TreeColumn(Tree parent, int style) {
        this(parent, style, TreeColumn.checkNull((Tree)parent).columnHolder.size());
    }

    public TreeColumn(Tree parent, int style, int index) {
        super(parent, TreeColumn.checkStyle(style));
        if (index < 0 || index > parent.columnHolder.size()) {
            this.error(6);
        }
        this.parent = parent;
        parent.createColumn(this, index);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        ControlEvent.addListener(this, listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.addListener(this, listener);
    }

    static Tree checkNull(Tree tree) {
        if (tree == null) {
            SWT.error(4);
        }
        return tree;
    }

    static int checkStyle(int style) {
        return TreeColumn.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.dispose(true);
    }

    void dispose(boolean notifyParent) {
        super.dispose();
        this.parent = null;
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    int getContentWidth() {
        Class<?> clazz;
        int contentWidth = 0;
        if (this.text.length() > 0) {
            contentWidth += Graphics.textExtent((Font)this.parent.getFont(), (String)this.text, (int)0).x;
        }
        if (this.image != null) {
            contentWidth += this.image.getBounds().width;
            if (this.text.length() > 0) {
                contentWidth += 3;
            }
        }
        if (this.sort != 0) {
            contentWidth += 10;
            if (this.text.length() > 0 || this.image != null) {
                contentWidth += 3;
            }
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.theme.IThemeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TreeThemeAdapter themeAdapter = (TreeThemeAdapter)this.parent.getAdapter(clazz);
        return contentWidth += themeAdapter.getHeaderPadding((Control)this.parent).width;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return this.moveable;
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    int getIndex() {
        int i = 0;
        while (i < this.parent.columnHolder.size()) {
            if (this.parent.columnHolder.getItem(i) == this) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    int getPreferredWidth() {
        if (!this.parent.getHeaderVisible()) {
            return 0;
        }
        int result = this.getContentWidth();
        return result;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.resizable;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return this.width;
    }

    public void pack() {
        this.checkWidget();
        TreeItem[] availableItems = this.parent.getItems();
        int index = this.getIndex();
        int newWidth = Graphics.stringExtent((Font)this.parent.getFont(), (String)this.getText()).x;
        newWidth = Math.max(this.getPreferredWidth(), newWidth);
        if (this.image != null) {
            newWidth += this.image.getBounds().width + 3;
        }
        if (this.parent.getSortColumn() == this && this.parent.getSortDirection() != 0) {
            newWidth += 13;
        }
        int i = 0;
        while (i < availableItems.length) {
            availableItems[i].clearPreferredWidthBuffer();
            int width = availableItems[i].getPreferredWidth(index, false);
            if (this.parent.isDisposed() || this.isDisposed()) {
                return;
            }
            if (!availableItems[i].isDisposed()) {
                newWidth = Math.max(newWidth, width);
            }
            ++i;
        }
        if (newWidth < 12) {
            newWidth = 12;
        }
        this.setWidth(newWidth);
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        ControlEvent.removeListener(this, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        SelectionEvent.removeListener(this, listener);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        int newAlignment = TreeColumn.checkBits(alignment, 16384, 0x1000000, 131072, 0, 0, 0);
        if ((this.style & newAlignment) != 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= newAlignment;
    }

    public void setMoveable(boolean moveable) {
        this.checkWidget();
        this.moveable = moveable;
    }

    public void setResizable(boolean value) {
        this.checkWidget();
        this.resizable = value;
    }

    void setSortDirection(int value) {
        if (value == this.sort) {
            return;
        }
        this.sort = value;
    }

    public void setText(String value) {
        this.checkWidget();
        if (value == null) {
            this.error(4);
        }
        if (value.equals(this.text)) {
            return;
        }
        super.setText(value);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        if (this.toolTipText == string) {
            return;
        }
        if (this.toolTipText != null && this.toolTipText.equals(string)) {
            return;
        }
        this.toolTipText = string;
    }

    public void setWidth(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        if (this.width == value) {
            return;
        }
        this.width = value;
        this.parent.updateScrollBars();
        int eventId = 11;
        ControlEvent event = new ControlEvent(this, eventId);
        event.processEvent();
    }

    void releaseParent() {
        super.releaseParent();
        this.parent.destroyColumn(this);
    }

    final int getLeft() {
        int result = 0;
        TreeColumn[] columns = this.parent.getColumns();
        int[] columnOrder = this.parent.getColumnOrder();
        int orderedIndex = -1;
        int i = 0;
        while (orderedIndex == -1 && i < columnOrder.length) {
            if (columnOrder[i] == this.parent.indexOf(this)) {
                orderedIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < orderedIndex) {
            result += columns[columnOrder[i]].getWidth();
            ++i;
        }
        return result;
    }
}

