/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.xtext.ui.refactoring.ElementRenameArguments;
import org.eclipse.xtext.ui.refactoring.IDependentElementsCalculator;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.IRenameStrategy;
import org.eclipse.xtext.ui.refactoring.IRenamedElementTracker;
import org.eclipse.xtext.ui.refactoring.impl.AbstractRenameProcessor;
import org.eclipse.xtext.ui.refactoring.impl.ProjectUtil;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringResourceSetProvider;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringStatusException;
import org.eclipse.xtext.ui.refactoring.impl.ReferenceUpdaterDispatcher;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.ui.util.ResourceUtil;

public class RenameElementProcessor
extends AbstractRenameProcessor {
    protected static final Logger LOG = Logger.getLogger(RenameElementProcessor.class);
    @Inject
    private RefactoringResourceSetProvider resourceSetProvider;
    @Inject
    private IDependentElementsCalculator dependentElementsCalculator;
    @Inject
    private IRenameStrategy.Provider strategyProvider;
    @Inject
    private ProjectUtil projectUtil;
    @Inject
    private ReferenceUpdaterDispatcher referenceUpdaterDispatcher;
    @Inject
    private IRenamedElementTracker renameElementTracker;
    @Inject
    @Named(value="languageName")
    private String languageName;
    private IRenameElementContext renameElementContext;
    private ResourceSet resourceSet;
    private RefactoringStatus status;
    private URI targetElementURI;
    private EObject targetElement;
    private IRenameStrategy renameStrategy;
    private String newName;
    @Inject
    private Provider<IRefactoringUpdateAcceptor> updateAcceptorProvider;
    private ElementRenameArguments renameArguments;
    private IRefactoringUpdateAcceptor currentUpdateAcceptor;

    public boolean initialize(IRenameElementContext renameElementContext) {
        block4: {
            this.status = new RefactoringStatus();
            try {
                this.renameElementContext = renameElementContext;
                this.targetElementURI = renameElementContext.getTargetElementURI();
                this.resourceSet = this.createResourceSet(renameElementContext);
                this.targetElement = this.resourceSet.getEObject(this.targetElementURI, true);
                if (this.targetElement == null) {
                    throw new RefactoringStatusException("Rename target element can not be resolved", true);
                }
                this.checkTargetFile(this.targetElement.eResource());
                this.renameStrategy = this.createRenameElementStrategy(this.targetElement, renameElementContext);
                if (this.renameStrategy == null) {
                    return false;
                }
            }
            catch (Exception e) {
                this.handleException(this.status, e);
                if (this.status.getSeverity() != 4) break block4;
                throw e instanceof RuntimeException ? (RuntimeException)e : new WrappedException(e);
            }
        }
        return true;
    }

    protected ResourceSet createResourceSet(IRenameElementContext renameElementContext) {
        return this.resourceSetProvider.get(this.projectUtil.getProject(this.targetElementURI));
    }

    protected void checkTargetFile(Resource resource) {
        IFile targetFile = ResourceUtil.getFile(resource);
        if (targetFile == null || !targetFile.isAccessible()) {
            throw new RefactoringStatusException("Rename target cannot be accessed", true);
        }
        if (targetFile.isReadOnly()) {
            throw new RefactoringStatusException("Target file is read-only", true);
        }
    }

    protected IRenameStrategy createRenameElementStrategy(EObject targetElement, IRenameElementContext renameElementContext) {
        return this.strategyProvider.get(targetElement, renameElementContext);
    }

    public IRenameStrategy getRenameElementStrategy() {
        return this.renameStrategy;
    }

    public Object[] getElements() {
        return new Object[]{this.targetElementURI};
    }

    public String getOriginalName() {
        return this.renameStrategy.getOriginalName();
    }

    public RefactoringStatus validateNewName(String newName) {
        return this.renameStrategy.validateNewName(newName);
    }

    protected String getLanguageName() {
        return this.languageName;
    }

    public String getIdentifier() {
        return String.valueOf(this.getLanguageName()) + ".ui.refactoring.Processor";
    }

    public String getProcessorName() {
        return "Rename element";
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public String getNewName() {
        return this.newName;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.status;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            this.currentUpdateAcceptor = (IRefactoringUpdateAcceptor)this.updateAcceptorProvider.get();
            Iterable<URI> dependentElementURIs = this.dependentElementsCalculator.getDependentElementURIs(this.targetElement, (IProgressMonitor)progress.newChild(1));
            Map<URI, URI> original2newElementURIs = this.renameElementTracker.renameAndTrack(Iterables.concat(Collections.singleton(this.targetElementURI), dependentElementURIs), this.newName, this.resourceSet, this.renameStrategy, (IProgressMonitor)progress.newChild(1));
            this.renameStrategy.createDeclarationUpdates(this.newName, this.resourceSet, this.currentUpdateAcceptor);
            this.renameArguments = new ElementRenameArguments(this.targetElementURI, this.newName, this.renameStrategy, original2newElementURIs);
            this.referenceUpdaterDispatcher.createReferenceUpdates(this.renameArguments, this.resourceSet, this.currentUpdateAcceptor, (IProgressMonitor)progress.newChild(98));
            this.status.merge(this.currentUpdateAcceptor.getRefactoringStatus());
        }
        catch (Exception exc) {
            this.handleException(this.status, exc);
        }
        return this.status;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        return this.currentUpdateAcceptor.createCompositeChange("Rename " + this.renameStrategy.getOriginalName() + " to " + this.newName, monitor);
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        RenameParticipant[] renameParticipants = ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)this.renameElementContext, (RenameArguments)new RenameArguments(this.newName, true), (String[])new String[]{"org.eclipse.xtext.ui.shared.xtextNature"}, (SharableParticipants)sharedParticipants);
        return renameParticipants;
    }

    public void handleException(RefactoringStatus status, Exception exc) {
        if (exc instanceof RefactoringStatusException) {
            if (((RefactoringStatusException)exc).isFatal()) {
                status.addFatalError(exc.getMessage());
            } else {
                status.addError(exc.getMessage());
            }
        } else {
            status.addFatalError("Error during refactoring: " + exc.getMessage() + ". See log for details");
            LOG.error((Object)"Error during refactoring", (Throwable)exc);
        }
    }

    protected RefactoringResourceSetProvider getResourceSetProvider() {
        return this.resourceSetProvider;
    }
}

