/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.ui;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.ui.refactoring.ui.RefactoringType;
import org.eclipse.xtext.ui.refactoring.ui.RenameRefactoringController;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class RenameElementHandler
extends AbstractHandler {
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;
    @Inject
    protected RenameRefactoringController renameRefactoringController;
    protected static final Logger LOG = Logger.getLogger(RenameElementHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            final XtextEditor editor = EditorUtils.getActiveXtextEditor(event);
            if (editor != null) {
                final ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
                IRenameElementContext renameElementContext = (IRenameElementContext)editor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<IRenameElementContext, XtextResource>(){

                    public IRenameElementContext exec(XtextResource resource) throws Exception {
                        EObject targetElement = RenameElementHandler.this.eObjectAtOffsetHelper.resolveElementAt(resource, selection.getOffset());
                        if (targetElement != null) {
                            return RenameElementHandler.this.createRenameElementContext(targetElement, editor, selection, resource);
                        }
                        return null;
                    }
                });
                if (renameElementContext != null) {
                    this.startRenameElement(renameElementContext);
                }
            }
        }
        catch (Exception exc) {
            LOG.error((Object)"Error initializing refactoring", (Throwable)exc);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error initializing refactoring", (String)exc.getMessage());
        }
        return null;
    }

    protected IRenameElementContext createRenameElementContext(EObject targetElement, XtextEditor editor, ITextSelection selection, XtextResource resource) {
        URI targetElementURI = EcoreUtil2.getNormalizedURI((EObject)targetElement);
        IRenameElementContext.Impl renameElementContext = new IRenameElementContext.Impl(targetElementURI, targetElement.eClass(), (IEditorPart)editor, (ISelection)selection, resource.getURI());
        return renameElementContext;
    }

    protected void startRenameElement(IRenameElementContext renameElementContext) throws InterruptedException {
        this.renameRefactoringController.initialize(renameElementContext);
        this.renameRefactoringController.startRefactoring(RefactoringType.LINKED_EDITING);
    }
}

