/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.search;

import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.internal.text.TableOwnerDrawSupport;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.search.EObjectDescriptionContentProvider;
import org.eclipse.xtext.ui.search.IXtextEObjectSearch;
import org.eclipse.xtext.ui.search.IteratorJob;
import org.eclipse.xtext.ui.search.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtextEObjectSearchDialog
extends ListDialog {
    protected Text searchControl;
    private String initialPatternText;
    private Label messageLabel;
    private Label searchStatusLabel;
    private IteratorJob sizeCalculationJob;
    private Label matchingElementsLabel;
    protected Text typeSearchControl;
    private IXtextEObjectSearch searchEngine;
    private final ILabelProvider labelProvider;
    private boolean enableStyledLabels;

    public XtextEObjectSearchDialog(Shell parent, IXtextEObjectSearch searchEngine, ILabelProvider labelProvider) {
        super(parent);
        this.searchEngine = searchEngine;
        this.labelProvider = labelProvider;
        this.setTitle(Messages.XtextEObjectSearchDialog_TableLabelDialogTitle);
        this.setMessage(Messages.XtextEObjectSearchDialog_TableLabelSearchControlLabel);
        this.setAddCancelButton(true);
        this.setContentProvider(new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return null;
            }
        });
        this.setLabelProvider(labelProvider);
    }

    public XtextEObjectSearchDialog(Shell parent, IXtextEObjectSearch searchEngine, ILabelProvider labelProvider, boolean enableStyledLabels) {
        this(parent, searchEngine, labelProvider);
        this.enableStyledLabels = enableStyledLabels;
    }

    protected IXtextEObjectSearch getSearchEngine() {
        return this.searchEngine;
    }

    public void setInitialPattern(String text) {
        this.initialPatternText = text;
    }

    protected String getInitialPattern() {
        return this.initialPatternText;
    }

    public int open() {
        String text;
        ISelection selection;
        IWorkbenchWindow window;
        if (this.getInitialPattern() == null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (selection = window.getSelectionService().getSelection()) instanceof ITextSelection && (text = ((ITextSelection)selection).getText()) != null && (text = text.trim()).length() > 0) {
            this.setInitialPattern(text);
        }
        return super.open();
    }

    protected int getTableStyle() {
        return super.getTableStyle() | 0x10000000;
    }

    protected Control createDialogArea(Composite container) {
        Composite parent = (Composite)super.createDialogArea(container);
        if (this.enableStyledLabels && this.labelProvider instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider) {
            Table table = this.getTableViewer().getTable();
            final DelegatingStyledCellLabelProvider.IStyledLabelProvider styledLabelProvider = (DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.labelProvider;
            TableOwnerDrawSupport.install((Table)table);
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    this.handleSetData(event);
                }

                protected void handleSetData(Event event) {
                    TableItem item = (TableItem)event.item;
                    IEObjectDescription description = (IEObjectDescription)item.getData();
                    if (description != null) {
                        StyledString styledString = styledLabelProvider.getStyledText((Object)description);
                        String displayString = styledString.toString();
                        StyleRange[] styleRanges = styledString.getStyleRanges();
                        item.setText(displayString);
                        TableOwnerDrawSupport.storeStyleRanges((TableItem)item, (int)0, (StyleRange[])styleRanges);
                    }
                }
            };
            table.addListener(36, listener);
        }
        this.messageLabel = new Label(parent, 0);
        this.setDefaultGridData((Control)this.messageLabel);
        EObjectDescriptionContentProvider contentProvider = new EObjectDescriptionContentProvider();
        this.getTableViewer().setContentProvider((IContentProvider)contentProvider);
        this.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object firstElement;
                IStructuredSelection structuredSelection;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && !(structuredSelection = (IStructuredSelection)selection).isEmpty() && (firstElement = structuredSelection.getFirstElement()) instanceof IEObjectDescription) {
                    IEObjectDescription eObjectDescription = (IEObjectDescription)firstElement;
                    URI resourceURI = eObjectDescription.getEObjectURI().trimFragment();
                    if (resourceURI.isPlatform()) {
                        XtextEObjectSearchDialog.this.messageLabel.setText(resourceURI.toPlatformString(true));
                    } else if (resourceURI.isFile()) {
                        XtextEObjectSearchDialog.this.messageLabel.setText(resourceURI.toFileString());
                    } else {
                        XtextEObjectSearchDialog.this.messageLabel.setText(resourceURI.toString());
                    }
                    return;
                }
                XtextEObjectSearchDialog.this.messageLabel.setText("");
            }
        });
        this.applyFilter();
        return parent;
    }

    protected Label createMessageArea(Composite composite) {
        Label label = super.createMessageArea(composite);
        this.searchControl = new Text(composite, 2432);
        this.setDefaultGridData((Control)this.searchControl);
        Label typePatternLabel = new Label(composite, 0);
        typePatternLabel.setText(Messages.XtextEObjectSearchDialog_TypeSearchLabel);
        this.setDefaultGridData((Control)typePatternLabel);
        this.typeSearchControl = new Text(composite, 2432);
        this.setDefaultGridData((Control)this.typeSearchControl);
        Composite labelComposite = new Composite(composite, 0);
        this.setDefaultGridData((Control)labelComposite);
        GridLayout labelCompositeLayout = new GridLayout(2, true);
        labelCompositeLayout.marginWidth = 0;
        labelComposite.setLayout((Layout)labelCompositeLayout);
        this.matchingElementsLabel = new Label(labelComposite, 0);
        this.matchingElementsLabel.setText(Messages.XtextEObjectSearchDialog_MatchingElementsLabel);
        this.matchingElementsLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.searchStatusLabel = new Label(labelComposite, 131072);
        this.searchStatusLabel.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        ModifyListener textModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XtextEObjectSearchDialog.this.applyFilter();
            }
        };
        this.searchControl.addModifyListener(textModifyListener);
        this.typeSearchControl.addModifyListener(textModifyListener);
        this.searchControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    XtextEObjectSearchDialog.this.typeSearchControl.setFocus();
                }
            }
        });
        if (this.initialPatternText != null) {
            this.searchControl.setText(this.initialPatternText);
            this.searchControl.selectAll();
        }
        this.typeSearchControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    Object firstElement;
                    TableViewer tableViewer = XtextEObjectSearchDialog.this.getTableViewer();
                    tableViewer.getTable().setFocus();
                    if (tableViewer.getSelection().isEmpty() && (firstElement = tableViewer.getElementAt(0)) != null) {
                        tableViewer.setSelection((ISelection)new StructuredSelection(firstElement));
                    }
                }
            }
        });
        return label;
    }

    private void setDefaultGridData(Control control) {
        control.setLayoutData((Object)new GridData(768));
    }

    protected void applyFilter() {
        String searchPattern = this.searchControl.getText();
        String typeSearchPattern = this.typeSearchControl.getText();
        if (searchPattern != null || typeSearchPattern != null) {
            Iterable<IEObjectDescription> matches = this.getSearchEngine().findMatches(searchPattern, typeSearchPattern);
            this.startSizeCalculation(matches);
        }
    }

    public void updateMatches(final Collection<IEObjectDescription> matches, final boolean isFinished) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (XtextEObjectSearchDialog.this.getShell() != null) {
                    if (XtextEObjectSearchDialog.this.getTableViewer() != null) {
                        XtextEObjectSearchDialog.this.getTableViewer().setItemCount(matches.size());
                        XtextEObjectSearchDialog.this.getTableViewer().setInput((Object)matches);
                    }
                    XtextEObjectSearchDialog.this.searchStatusLabel.setText(isFinished ? "" : Messages.XtextEObjectSearchDialog_StatusMessageSearching);
                    XtextEObjectSearchDialog.this.matchingElementsLabel.setText(String.valueOf(Messages.XtextEObjectSearchDialog_MatchingElementsLabel) + " (" + matches.size() + Messages.XtextEObjectSearchDialog_Matches);
                }
            }
        });
    }

    protected void startSizeCalculation(Iterable<IEObjectDescription> matches) {
        if (this.getTableViewer() != null) {
            if (this.sizeCalculationJob != null) {
                this.sizeCalculationJob.cancel();
                try {
                    this.sizeCalculationJob.join();
                }
                catch (InterruptedException e) {
                    this.sizeCalculationJob = new IteratorJob(this);
                }
            } else {
                this.sizeCalculationJob = new IteratorJob(this);
            }
            this.sizeCalculationJob.init(matches);
            this.sizeCalculationJob.schedule();
        }
    }
}

