/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.diagnostic;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.serializer.analysis.Context2NameFunction;
import org.eclipse.xtext.util.EmfFormatter;

public interface ISerializationDiagnostic {
    public static final Acceptor EXCEPTION_THROWING_ACCEPTOR = new ExceptionThrowingAcceptor();
    public static final Acceptor STDERR_ACCEPTOR = new StdErrAcceptor();

    public boolean breaksSyntax();

    public Throwable getException();

    public String getMessage();

    public EObject getSemanticObject();

    public EObject getContext();

    public static interface Acceptor {
        public void accept(ISerializationDiagnostic var1);
    }

    public static class ExceptionDiagnostic
    implements ISerializationDiagnostic {
        protected Throwable exception;

        public ExceptionDiagnostic(Throwable exception) {
            this.exception = exception;
        }

        public boolean breaksSyntax() {
            return false;
        }

        public Throwable getException() {
            return this.exception;
        }

        public String getMessage() {
            return this.exception.getMessage();
        }

        public EObject getSemanticObject() {
            return null;
        }

        public EObject getContext() {
            return null;
        }
    }

    public static class ExceptionThrowingAcceptor
    implements Acceptor {
        public void accept(ISerializationDiagnostic diagnostic) {
            if (diagnostic == null || diagnostic.getMessage() == null) {
                throw new RuntimeException("Something went wrong during serialization");
            }
            if (diagnostic.getException() != null) {
                throw new RuntimeException(diagnostic.getException());
            }
            String msg = diagnostic.getMessage();
            if (diagnostic.getSemanticObject() != null) {
                msg = String.valueOf(msg) + "\nSemantic Object: " + EmfFormatter.objPath((EObject)diagnostic.getSemanticObject());
            }
            if (diagnostic.getContext() != null) {
                msg = String.valueOf(msg) + "\nContext: " + new Context2NameFunction().getContextName(diagnostic.getContext());
            }
            throw new RuntimeException(msg);
        }
    }

    public static class StdErrAcceptor
    implements Acceptor {
        public void accept(ISerializationDiagnostic diagnostic) {
            if (diagnostic == null || diagnostic.getMessage() == null) {
                System.err.println("error");
            } else {
                System.err.println("error " + diagnostic.getMessage());
            }
        }
    }
}

