/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.view.vis;

import java.util.Collection;
import java.util.HashSet;
import org.ascape.util.data.DataSelection;
import org.eclipse.amp.agf.chart.CachedColorProvider;
import org.eclipse.amp.agf.chart.ChartEditPart;
import org.eclipse.amp.escape.ascape.view.EditPartScapeView;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.graphics.Color;

public class ChartView
extends EditPartScapeView {
    private static final long serialVersionUID = 1L;
    private ChartEditPart chartPart;
    private Collection<String> seriesCache = new HashSet<String>();
    CachedColorProvider seriesColorProvider = new CachedColorProvider();

    public ChartView() {
        super("org.eclipse.amp.view.ChartView", null, "Chart View");
    }

    public EditPart createEditPart(EditPart context, Object model) {
        this.chartPart = new ChartEditPart();
        this.chartPart.setSeriesColorProvider((IColorProvider)this.seriesColorProvider);
        this.chartPart.setModel(model);
        this.synchCache(model);
        return this.chartPart;
    }

    private void synchCache(Object model) {
        DataSelection dataSelection = (DataSelection)this.chartPart.getDataProvider().getDataSource(model);
        for (String series : this.seriesCache) {
            dataSelection.setSelected(series, true);
        }
    }

    public void addSeries(String valueName) {
        this.seriesCache.add(valueName);
        if (this.chartPart != null) {
            this.synchCache(this.chartPart.getModel());
        }
    }

    public void addSeries(String valueName, Color color) {
        this.seriesColorProvider.putForegroundColor((Object)valueName, color);
        this.addSeries(valueName);
    }
}

