/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.ui.camera;

import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw3d.IScene;
import org.eclipse.draw3d.camera.CameraPosition;
import org.eclipse.draw3d.camera.ICamera;
import org.eclipse.draw3d.camera.ICameraPosition;
import org.eclipse.draw3d.camera.tracking.ICameraMove;
import org.eclipse.draw3d.camera.tracking.LinearMove;
import org.eclipse.draw3d.camera.tracking.TrackingShot;
import org.eclipse.draw3d.camera.tracking.TrackingUtil;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.picking.Hit;
import org.eclipse.draw3d.picking.Picker;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Event;

public class CameraInputHandler {
    private static final float FACTOR_LOOK = 2.0E-4f;
    private static final float FACTOR_MOVE = 0.12f;
    private static final float FACTOR_ORBIT = 9.0E-4f;
    private static final Logger log = Logger.getLogger(CameraInputHandler.class.getName());
    private static final Logger logger = Logger.getLogger(CameraInputHandler.class.getName());
    private static final int MODIFIER_MASK = 0x70000 | SWT.MOD1 | SWT.MOD2 | SWT.MOD3 | SWT.MOD4;
    private KeySequence m_centerKey;
    private int m_currentKey;
    private int m_currentModifiers = 0;
    private int m_fastKey = 65536;
    private float m_keySpeed = 50.0f;
    private Point m_lastMouseLocation = new Point();
    private int m_lookButton = 1;
    private boolean m_mouseLook = false;
    private boolean m_mouseMove = false;
    private KeySequence m_moveBackwardKey;
    private int m_moveButton = 3;
    private KeySequence m_moveDownKey;
    private KeySequence m_moveForwardKey;
    private KeySequence m_moveLeftKey;
    private KeySequence m_moveRightKey;
    private KeySequence m_moveUpKey;
    private IVector3f m_orbitCenter;
    private int m_orbitModifiers;
    private KeySequence m_rollCCWKey;
    private KeySequence m_rollCWKey;
    private IScene m_scene;
    private float m_sensitivity;
    private int m_slowKey = 131072;
    private float m_wheelSpeed = 20.0f;
    Timer timer = null;

    public void buttonDown(int i_button, int i_stateMask, int i_x, int i_y) {
        this.stopCameraTracking();
        int modifiers = this.getModifiers(i_stateMask);
        this.doButtonDown(i_button, modifiers, i_x, i_y);
    }

    protected void stopCameraTracking() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
    }

    public void buttonUp(int i_button, int i_stateMask, int i_x, int i_y) {
        int modifiers = this.getModifiers(i_stateMask);
        this.doButtonUp(i_button, modifiers, i_x, i_y);
    }

    private void doButtonDown(int i_button, int i_modifiers, int i_mx, int i_my) {
        this.m_lastMouseLocation.setLocation(i_mx, i_my);
        this.m_orbitCenter = null;
        if (i_modifiers != 0 && i_modifiers == this.m_orbitModifiers) {
            Picker picker = this.getScene().getPicker();
            Hit hit = picker.getHit(i_mx, i_my);
            if (hit != null) {
                this.m_orbitCenter = hit.getWorldLocation(null);
            }
        } else {
            this.m_mouseLook = i_button == this.m_lookButton;
            this.m_mouseMove = i_button == this.m_moveButton;
        }
    }

    private void doButtonUp(int i_button, int i_stateMask, int i_x, int i_y) {
        this.m_lastMouseLocation.setLocation(i_x, i_y);
        this.m_mouseLook = false;
        this.m_mouseMove = false;
        this.m_orbitCenter = null;
    }

    protected ICamera getCamera() {
        ICamera camera = this.getScene().getCamera();
        if (camera == null) {
            throw new AssertionError((Object)"camera is null");
        }
        return camera;
    }

    private KeyStroke[] getKeyStrokes(KeyEvent keyEvent) {
        int thirdAccelerator;
        Event event = new Event();
        event.character = keyEvent.character;
        event.data = keyEvent.data;
        event.display = keyEvent.display;
        event.doit = keyEvent.doit;
        event.keyCode = keyEvent.keyCode;
        event.stateMask = keyEvent.stateMask;
        event.time = keyEvent.time;
        event.widget = keyEvent.widget;
        ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>(3);
        if (event.stateMask == 0 && event.keyCode == 0 && event.character == '\u0000') {
            return keyStrokes.toArray(new KeyStroke[keyStrokes.size()]);
        }
        int firstAccelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((Event)event);
        keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)firstAccelerator));
        if (event.character == '\u007f') {
            return keyStrokes.toArray(new KeyStroke[keyStrokes.size()]);
        }
        int secondAccelerator = SWTKeySupport.convertEventToUnshiftedModifiedAccelerator((Event)event);
        if (secondAccelerator != 0 && secondAccelerator != firstAccelerator) {
            keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)secondAccelerator));
        }
        if ((thirdAccelerator = SWTKeySupport.convertEventToModifiedAccelerator((Event)event)) != 0 && thirdAccelerator != secondAccelerator && thirdAccelerator != firstAccelerator) {
            keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)thirdAccelerator));
        }
        return keyStrokes.toArray(new KeyStroke[keyStrokes.size()]);
    }

    private int getModifiers(int i_stateMask) {
        return i_stateMask & MODIFIER_MASK;
    }

    protected IScene getScene() {
        if (this.m_scene == null) {
            throw new AssertionError((Object)"m_scene is null");
        }
        return this.m_scene;
    }

    private boolean isKeySequence(KeySequence sequence, KeyStroke[] keyStrokes) {
        if (sequence == null) {
            return false;
        }
        KeyStroke[] seqStrokes = sequence.getKeyStrokes();
        if (seqStrokes.length != keyStrokes.length) {
            return false;
        }
        int i = 0;
        while (i < seqStrokes.length) {
            KeyStroke seqKeyStroke = seqStrokes[i];
            KeyStroke keyStroke = keyStrokes[i];
            if (!seqKeyStroke.equals((Object)keyStroke)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void keyDown(KeyEvent i_event) {
        KeyStroke[] keyStrokes;
        this.stopCameraTracking();
        this.m_currentModifiers = this.getModifiers(i_event.stateMask);
        float speed = this.m_keySpeed;
        int modifiers = this.getModifiers(i_event.stateMask);
        if ((modifiers & this.m_slowKey) != 0) {
            speed /= 10.0f;
            i_event.stateMask &= ~this.m_slowKey;
        }
        if ((modifiers & this.m_fastKey) != 0) {
            speed *= 10.0f;
            i_event.stateMask &= ~this.m_fastKey;
        }
        if ((keyStrokes = this.getKeyStrokes(i_event)) == null) {
            return;
        }
        if (this.m_currentKey != i_event.keyCode) {
            if (this.isKeySequence(this.m_moveLeftKey, keyStrokes)) {
                this.getCamera().moveBy(0.0f, -speed, 0.0f);
            } else if (this.isKeySequence(this.m_moveRightKey, keyStrokes)) {
                this.getCamera().moveBy(0.0f, speed, 0.0f);
            } else if (this.isKeySequence(this.m_moveUpKey, keyStrokes)) {
                this.getCamera().moveBy(0.0f, 0.0f, speed);
            } else if (this.isKeySequence(this.m_moveDownKey, keyStrokes)) {
                this.getCamera().moveBy(0.0f, 0.0f, -speed);
            } else if (this.isKeySequence(this.m_moveForwardKey, keyStrokes)) {
                this.getCamera().moveBy(speed, 0.0f, 0.0f);
            } else if (this.isKeySequence(this.m_moveBackwardKey, keyStrokes)) {
                this.getCamera().moveBy(-speed, 0.0f, 0.0f);
            } else if (this.isKeySequence(this.m_centerKey, keyStrokes)) {
                this.getCamera().reset();
            } else if (this.isKeySequence(this.m_rollCCWKey, keyStrokes)) {
                float roll = (float)Math.toRadians(speed);
                this.getCamera().rotate(roll, 0.0f, 0.0f);
            } else if (this.isKeySequence(this.m_rollCWKey, keyStrokes)) {
                float roll = (float)Math.toRadians(speed);
                this.getCamera().rotate(-roll, 0.0f, 0.0f);
            }
        }
    }

    public void keyUp(KeyEvent i_event) {
        this.m_currentModifiers = 0;
    }

    private float lookSpeed(int i_speed) {
        return (float)i_speed * this.m_sensitivity * 2.0E-4f;
    }

    public void mouseMove(int i_stateMask, int i_x, int i_y) {
        int dx = i_x - this.m_lastMouseLocation.x;
        int dy = i_y - this.m_lastMouseLocation.y;
        this.m_lastMouseLocation.setLocation(i_x, i_y);
        int modifiers = this.getModifiers(i_stateMask);
        if (modifiers != 0 && modifiers == this.m_orbitModifiers && this.m_orbitCenter != null) {
            float hAngle = (float)Math.asin(this.orbitSpeed(dx));
            float vAngle = (float)Math.asin(this.orbitSpeed(dy));
            this.getCamera().orbit(this.m_orbitCenter, -hAngle, vAngle);
        } else if (this.m_mouseLook) {
            float yaw = (float)Math.asin(this.lookSpeed(dx));
            float pitch = (float)Math.asin(this.lookSpeed(dy));
            this.getCamera().rotate(0.0f, pitch, yaw);
        } else if (this.m_mouseMove) {
            this.getCamera().moveBy(0.0f, this.moveSpeed(-dx), this.moveSpeed(dy));
        }
    }

    public void mouseWheelScrolled(int i_count) {
        float speed = (float)i_count * this.m_wheelSpeed;
        if ((this.m_currentModifiers & this.m_slowKey) != 0) {
            speed /= 10.0f;
        }
        if ((this.m_currentModifiers & this.m_fastKey) != 0) {
            speed *= 10.0f;
        }
        this.getCamera().moveBy(speed, 0.0f, 0.0f);
    }

    private float moveSpeed(int i_speed) {
        return (float)i_speed * this.m_sensitivity * 0.12f;
    }

    public void doubleClick(int i_button, int i_stateMask, int i_mx, int i_my) {
        this.stopCameraTracking();
        Picker picker = this.getScene().getPicker();
        Hit hit = picker.getHit(i_mx, i_my);
        CameraPosition cameraPos = null;
        if (hit != null) {
            IFigure figure = hit.getSearchResult();
            cameraPos = TrackingUtil.figureToScreen((IFigure)figure, (ICamera)this.getCamera());
        } else {
            cameraPos = new CameraPosition();
            if ((i_stateMask & this.m_orbitModifiers) != 0) {
                if ((i_stateMask & 0x20000) == 0) {
                    cameraPos.setViewDirection((IVector3f)new Vector3fImpl(1.0f, 0.0f, 0.0f));
                    cameraPos.setPosition((IVector3f)new Vector3fImpl(-1000.0f, 0.0f, 0.0f));
                } else {
                    cameraPos.setViewDirection((IVector3f)new Vector3fImpl(0.0f, 1.0f, 0.0f));
                    cameraPos.setUpVector((IVector3f)new Vector3fImpl(0.0f, 0.0f, 1.0f));
                    cameraPos.setPosition((IVector3f)new Vector3fImpl(0.0f, -1000.0f, 0.0f));
                }
            }
        }
        if (cameraPos != null) {
            LinearMove move = new LinearMove();
            move.init(this.getCamera().getCameraPosition(null), (ICameraPosition)cameraPos);
            float moveLength = Math3D.distance((IVector3f)this.getCamera().getCameraPosition(null).getPosition(), (IVector3f)cameraPos.getPosition());
            long duration = (long)(Math.log(moveLength * moveLength) * 50.0);
            if (log.isLoggable(Level.INFO)) {
                log.info("duration=" + duration);
            }
            if (duration > 2000L) {
                duration = 2000L;
            }
            if (duration < 0L) {
                duration = 100L;
            }
            TrackingShot shot = new TrackingShot(duration, this.getCamera(), (ICameraMove)move);
            this.timer = new Timer();
            this.timer.schedule((TimerTask)shot, 0L, 50L);
        }
    }

    public void nativeDragFinished(int i_x, int i_y) {
        this.doButtonUp(1, this.m_currentModifiers, i_x, i_y);
    }

    public void nativeDragStarted(int i_x, int i_y) {
        this.doButtonDown(1, this.m_currentModifiers, i_x, i_y);
    }

    private float orbitSpeed(int i_speed) {
        return (float)i_speed * this.m_sensitivity * 9.0E-4f;
    }

    public void setCenterKey(KeySequence i_centerKey) {
        this.m_centerKey = i_centerKey;
    }

    public void setFastKey(int i_fastKey) {
        this.m_fastKey = i_fastKey;
    }

    public void setKeySpeed(float i_keySpeed) {
        this.m_keySpeed = i_keySpeed;
    }

    public void setLookButton(int i_lookButton) {
        this.m_lookButton = i_lookButton;
    }

    public void setMoveBackwardKey(KeySequence i_moveBackwardKey) {
        this.m_moveBackwardKey = i_moveBackwardKey;
    }

    public void setMoveButton(int i_moveButton) {
        this.m_moveButton = i_moveButton;
    }

    public void setMoveDownKey(KeySequence i_moveDownKey) {
        this.m_moveDownKey = i_moveDownKey;
    }

    public void setMoveForwardKey(KeySequence i_moveForwardKey) {
        this.m_moveForwardKey = i_moveForwardKey;
    }

    public void setMoveLeftKey(KeySequence i_moveLeftKey) {
        this.m_moveLeftKey = i_moveLeftKey;
    }

    public void setMoveRightKey(KeySequence i_moveRightKey) {
        this.m_moveRightKey = i_moveRightKey;
    }

    public void setMoveUpKey(KeySequence i_moveUpKey) {
        this.m_moveUpKey = i_moveUpKey;
    }

    public void setOrbitModifiers(int i_orbitModifiers) {
        this.m_orbitModifiers = i_orbitModifiers;
    }

    public void setRollCCWKey(KeySequence i_rollCCWKey) {
        this.m_rollCCWKey = i_rollCCWKey;
    }

    public void setRollCWKey(KeySequence i_rollCWKey) {
        this.m_rollCWKey = i_rollCWKey;
    }

    public void setScene(IScene i_scene) {
        this.m_scene = i_scene;
    }

    public void setSensitivity(float i_sensitivity) {
        this.m_sensitivity = i_sensitivity;
    }

    public void setSlowKey(int i_slowKey) {
        this.m_slowKey = i_slowKey;
    }

    public void setWheelSpeed(float i_wheelSpeed) {
        this.m_wheelSpeed = i_wheelSpeed;
    }
}

