/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters083.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.8.2"})
public class PeriodicStimulusCacheBuilder
implements ICache {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeriodicStimulusCacheBuilder.class);
    public static final String CACHE_KEY = "PeriodicStimulus_Containing_Clock";
    private final HashMap<File, Map<String, Object>> map = new HashMap();

    public void buildCache(Map<File, Document> fileDocumentMapping) {
        LOGGER.info("Build up PeriodicStimulusCache for 0.8.2");
        for (Map.Entry<File, Document> entry : fileDocumentMapping.entrySet()) {
            File targetFile = entry.getKey();
            Document document1 = entry.getValue();
            if (document1 == null) continue;
            Element rootElement = document1.getRootElement();
            Map<String, Object> fileCache = this.map.get(targetFile);
            if (fileCache == null) {
                fileCache = new HashMap<String, Object>();
                this.map.put(targetFile, fileCache);
            }
            ArrayList<String> periodicStimulusElementNames = new ArrayList<String>();
            fileCache.put(CACHE_KEY, periodicStimulusElementNames);
            StringBuilder xpathBuilder = new StringBuilder();
            xpathBuilder.append("./stimuliModel/stimuli[@xsi:type=\"am:PeriodicStimulus\"]");
            List periodicStimulusElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuilder.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._083, (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
            for (Element periodicStimusElement : periodicStimulusElements) {
                String attributeValue;
                if (periodicStimusElement.getChild("clock") == null && periodicStimusElement.getAttribute("clock") == null || (attributeValue = periodicStimusElement.getAttributeValue("name")) == null) continue;
                periodicStimulusElementNames.add(attributeValue);
            }
        }
    }

    public Map<File, Map<String, Object>> getCacheMap() {
        return this.map;
    }

    public void clearCacheMap() {
        this.map.clear();
    }
}

