/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.util.sessionlog.eclipse;

import java.io.File;
import java.util.List;
import org.eclipse.app4mc.util.sessionlog.SessionLogEntry;
import org.eclipse.app4mc.util.sessionlog.SessionLogWriter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class EclipseLogWriter
implements SessionLogWriter {
    private int getStatus(SessionLogEntry.Status sessionLogStatus) {
        int status = 1;
        if (sessionLogStatus == SessionLogEntry.Status.ERROR) {
            status = 4;
        } else if (sessionLogStatus == SessionLogEntry.Status.WARNING) {
            status = 2;
        }
        return status;
    }

    public void write(File sessionLogFile, List<SessionLogEntry> log) {
        String logLevel = System.getProperty("app4mc.log.level");
        SessionLogEntry.Status logStatus = SessionLogEntry.Status.parseStatus((String)logLevel);
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle != null) {
            log.stream().filter(entry -> entry.test(logStatus)).forEach(entry -> {
                int status = this.getStatus(entry.status);
                if (entry.throwable != null) {
                    Platform.getLog((Bundle)bundle).log((IStatus)new Status(status, bundle.getSymbolicName(), entry.message, entry.throwable));
                } else {
                    Platform.getLog((Bundle)bundle).log((IStatus)new Status(status, bundle.getSymbolicName(), entry.message));
                }
            });
        }
    }
}

