/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters080.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.7.2", "output_model_version=0.8.0"}, service={IConverter.class})
public class OSConverter
extends AbstractConverter {
    @Reference
    SessionLogger logger;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> filename2documentMap, List<ICache> caches) {
        this.logger.info("Migration from 0.7.2 to 0.8.0 : Executing OS converter for model file : {0}", new Object[]{targetFile.getName()});
        Document root = filename2documentMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.moveOsDataConsistencyElement(rootElement);
    }

    private void moveOsDataConsistencyElement(Element rootElement) {
        List osDataConsistencyElements = HelperUtil.getXpathResult((Element)rootElement, (String)"./osModel/osDataConsistency", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        List operatingSystemElements = HelperUtil.getXpathResult((Element)rootElement, (String)"./osModel/operatingSystems", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        if (!osDataConsistencyElements.isEmpty()) {
            Element osDataConsistencyElement = (Element)osDataConsistencyElements.get(0);
            for (Element operatingSystemElement : operatingSystemElements) {
                Element osDataConsistencyElementClone = osDataConsistencyElement.clone();
                operatingSystemElement.addContent((Content)osDataConsistencyElementClone);
            }
            this.logger.warn("OsDataConsistency element is removed from OsModel, and is added (cloned content) to each OperatingSystem element (which is part of corresponding OsModel).", new Object[0]);
            osDataConsistencyElement.getParentElement().removeContent((Content)osDataConsistencyElement);
        }
    }
}

