/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.util.ChartDefaultValueUtil;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.AbstractChartInsets;
import org.eclipse.birt.chart.ui.swt.composites.LocalizedNumberEditorComposite;
import org.eclipse.birt.chart.ui.swt.fieldassist.TextNumberEditorAssistField;
import org.eclipse.birt.chart.ui.swt.interfaces.IUIServiceProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class InsetsComposite
extends AbstractChartInsets
implements ModifyListener {
    private transient String sUnits = null;
    public static final int INSETS_CHANGED_EVENT = 1;
    protected transient Insets insets = null;
    protected transient Group grpInsets = null;
    protected transient Label lblTop = null;
    protected transient Label lblLeft = null;
    protected transient Label lblBottom = null;
    protected transient Label lblRight = null;
    protected transient LocalizedNumberEditorComposite txtTop = null;
    protected transient LocalizedNumberEditorComposite txtLeft = null;
    protected transient LocalizedNumberEditorComposite txtBottom = null;
    protected transient LocalizedNumberEditorComposite txtRight = null;
    private transient IUIServiceProvider serviceprovider = null;
    protected transient boolean bEnabled = true;
    private transient int numberRows = 2;
    protected Insets defaultInsets = null;
    private ChartWizardContext context;

    public InsetsComposite(Composite parent, int style, Insets insets, String sUnits, IUIServiceProvider serviceprovider, ChartWizardContext context) {
        this(parent, style, 2, insets, sUnits, serviceprovider, context);
    }

    public InsetsComposite(Composite parent, int style, int numberRows, Insets insets, String sUnits, IUIServiceProvider serviceprovider, ChartWizardContext context) {
        super(parent, style);
        this.numberRows = numberRows;
        this.insets = insets;
        this.sUnits = sUnits;
        this.serviceprovider = serviceprovider;
        this.context = context;
        if (this.sUnits == null) {
            this.sUnits = ChartDefaultValueUtil.getDefaultUnits((Chart)this.context.getModel());
        }
        this.init();
        this.placeComponents();
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
    }

    protected void placeComponents() {
        Group grpInsets = this.createGroup();
        this.createTop((Composite)grpInsets);
        this.createLeft((Composite)grpInsets);
        this.createBottom((Composite)grpInsets);
        this.createRight((Composite)grpInsets);
        this.updateInsetsData(this.insets);
        this.setModifyListener(true);
    }

    protected Group createGroup() {
        FillLayout flMain = new FillLayout();
        flMain.marginHeight = 0;
        flMain.marginWidth = 0;
        GridLayout glGroup = new GridLayout();
        glGroup.horizontalSpacing = 8;
        glGroup.verticalSpacing = 5;
        glGroup.marginHeight = 4;
        glGroup.marginWidth = 4;
        glGroup.numColumns = 8 / this.numberRows;
        this.setLayout((Layout)flMain);
        this.grpInsets = new Group((Composite)this, 0);
        this.grpInsets.setLayout((Layout)glGroup);
        this.grpInsets.setText(Messages.getFormattedString("InsetsComposite.Lbl.Insets", LiteralHelper.unitsOfMeasurementSet.getDisplayNameByName(this.sUnits, this.sUnits)));
        return this.grpInsets;
    }

    protected void createRight(Composite grpInsets) {
        this.lblRight = new Label(grpInsets, 0);
        GridData gdLRight = new GridData(4);
        this.lblRight.setLayoutData((Object)gdLRight);
        this.lblRight.setText(Messages.getString("InsetsComposite.Lbl.Right"));
        this.txtRight = new LocalizedNumberEditorComposite(grpInsets, 2048);
        new TextNumberEditorAssistField(this.txtRight.getTextControl(), null);
        GridData gdTRight = new GridData(1808);
        gdTRight.widthHint = 45;
        this.txtRight.setLayoutData(gdTRight);
    }

    protected void createBottom(Composite grpInsets) {
        this.lblBottom = new Label(grpInsets, 0);
        GridData gdLBottom = new GridData(4);
        this.lblBottom.setLayoutData((Object)gdLBottom);
        this.lblBottom.setText(Messages.getString("InsetsComposite.Lbl.Bottom"));
        this.txtBottom = new LocalizedNumberEditorComposite(grpInsets, 2048);
        new TextNumberEditorAssistField(this.txtBottom.getTextControl(), null);
        GridData gdTBottom = new GridData(1808);
        gdTBottom.widthHint = 45;
        this.txtBottom.setLayoutData(gdTBottom);
    }

    protected void createLeft(Composite grpInsets) {
        this.lblLeft = new Label(grpInsets, 0);
        GridData gdLLeft = new GridData(4);
        this.lblLeft.setLayoutData((Object)gdLLeft);
        this.lblLeft.setText(Messages.getString("InsetsComposite.Lbl.Left"));
        this.txtLeft = new LocalizedNumberEditorComposite(grpInsets, 2048);
        new TextNumberEditorAssistField(this.txtLeft.getTextControl(), null);
        GridData gdTLeft = new GridData(1808);
        gdTLeft.widthHint = 45;
        this.txtLeft.setLayoutData(gdTLeft);
    }

    protected void createTop(Composite grpInsets) {
        this.lblTop = new Label(grpInsets, 0);
        GridData gdLTop = new GridData(4);
        this.lblTop.setLayoutData((Object)gdLTop);
        this.lblTop.setText(Messages.getString("InsetsComposite.Lbl.Top"));
        this.txtTop = new LocalizedNumberEditorComposite(grpInsets, 2048);
        new TextNumberEditorAssistField(this.txtTop.getTextControl(), null);
        GridData gdTTop = new GridData(1808);
        gdTTop.widthHint = 45;
        this.txtTop.setLayoutData(gdTTop);
    }

    protected void setModifyListener(boolean enabled) {
        if (enabled) {
            this.txtTop.addModifyListener(this);
            this.txtLeft.addModifyListener(this);
            this.txtRight.addModifyListener(this);
            this.txtBottom.addModifyListener(this);
        } else {
            this.txtTop.removeModifyListener(this);
            this.txtLeft.removeModifyListener(this);
            this.txtRight.removeModifyListener(this);
            this.txtBottom.removeModifyListener(this);
        }
    }

    protected void updateInsetsData(Insets insets) {
        double dblPoints = insets.getTop();
        double dblCurrent = this.serviceprovider.getConvertedValue(dblPoints, "Points", this.sUnits);
        this.txtTop.setValue(dblCurrent);
        dblPoints = insets.getLeft();
        dblCurrent = this.serviceprovider.getConvertedValue(dblPoints, "Points", this.sUnits);
        this.txtLeft.setValue(dblCurrent);
        dblPoints = insets.getBottom();
        dblCurrent = this.serviceprovider.getConvertedValue(dblPoints, "Points", this.sUnits);
        this.txtBottom.setValue(dblCurrent);
        dblPoints = insets.getRight();
        dblCurrent = this.serviceprovider.getConvertedValue(dblPoints, "Points", this.sUnits);
        this.txtRight.setValue(dblCurrent);
    }

    public void setEnabled(boolean bState) {
        super.setEnabled(bState);
        this.setEnabledImpl(bState);
    }

    protected void setEnabledImpl(boolean bState) {
        this.grpInsets.setEnabled(bState);
        this.updateInsetsButtons(bState);
        this.bEnabled = bState;
    }

    public boolean isEnabled() {
        return this.bEnabled;
    }

    public void setInsets(Insets insets, String sUnits) {
        if (insets == null) {
            return;
        }
        this.setModifyListener(false);
        this.insets = insets;
        if (sUnits != null) {
            this.sUnits = sUnits;
        }
        this.updateInsetsButtons(this.bEnabled && ChartElementUtil.isSetInsets((Insets)insets));
        double dblPoints = insets.getBottom();
        double dblCurrent = this.serviceprovider.getConvertedValue(dblPoints, "Points", sUnits);
        this.txtBottom.setValue(dblCurrent);
        dblPoints = insets.getLeft();
        dblCurrent = this.serviceprovider.getConvertedValue(dblPoints, "Points", sUnits);
        this.txtLeft.setValue(dblCurrent);
        dblPoints = insets.getTop();
        dblCurrent = this.serviceprovider.getConvertedValue(dblPoints, "Points", sUnits);
        this.txtTop.setValue(dblCurrent);
        dblPoints = insets.getRight();
        dblCurrent = this.serviceprovider.getConvertedValue(dblPoints, "Points", sUnits);
        this.txtRight.setValue(dblCurrent);
        this.setModifyListener(true);
        this.grpInsets.setText(Messages.getFormattedString("InsetsComposite.Lbl.Insets", LiteralHelper.unitsOfMeasurementSet.getDisplayNameByName(this.sUnits)));
    }

    public Point getPreferredSize() {
        return new Point(300, 70);
    }

    public void modifyText(ModifyEvent event) {
        double dblCurrent = -1.0;
        double dblPoints = -1.0;
        if (event.widget.equals((Object)this.txtTop)) {
            dblCurrent = this.txtTop.getValue();
            dblPoints = this.serviceprovider.getConvertedValue(dblCurrent, this.sUnits, "Points");
            this.insets.setTop(dblPoints);
        } else if (event.widget.equals((Object)this.txtLeft)) {
            dblCurrent = this.txtLeft.getValue();
            dblPoints = this.serviceprovider.getConvertedValue(dblCurrent, this.sUnits, "Points");
            this.insets.setLeft(dblPoints);
        } else if (event.widget.equals((Object)this.txtBottom)) {
            dblCurrent = this.txtBottom.getValue();
            dblPoints = this.serviceprovider.getConvertedValue(dblCurrent, this.sUnits, "Points");
            this.insets.setBottom(dblPoints);
        } else if (event.widget.equals((Object)this.txtRight)) {
            dblCurrent = this.txtRight.getValue();
            dblPoints = this.serviceprovider.getConvertedValue(dblCurrent, this.sUnits, "Points");
            this.insets.setRight(dblPoints);
        }
    }

    protected void updateInsetsButtons(boolean bState) {
        this.lblTop.setEnabled(bState);
        this.txtTop.setEnabled(bState);
        this.lblLeft.setEnabled(bState);
        this.txtLeft.setEnabled(bState);
        this.lblBottom.setEnabled(bState);
        this.txtBottom.setEnabled(bState);
        this.lblRight.setEnabled(bState);
        this.txtRight.setEnabled(bState);
    }

    public void setDefaultInsets(Insets insets) {
        this.defaultInsets = insets;
    }
}

