/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ExceptionDialog
extends IconAndMessageDialog {
    private Button _detailsButton;
    private Text _textArea;
    private String _title;
    private boolean _textCreated = false;
    private Throwable _exception;
    private Display _display;

    public ExceptionDialog(Shell parentShell, String title, String msg, Throwable ex) {
        super(parentShell);
        this._title = title;
        this.message = msg;
        this._exception = ex;
        this._display = parentShell != null ? parentShell.getDisplay() : PlatformUI.getWorkbench().getDisplay().getActiveShell().getDisplay();
        this.setShellStyle(67696);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this._title);
    }

    protected Image getImage() {
        return this._display.getSystemImage(1);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this._detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(id);
        }
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        Point oldSize = this.getShell().computeSize(-1, -1);
        if (this._textCreated) {
            this._textArea.dispose();
            this._textCreated = false;
            this._detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            this._textArea = this.createTextArea((Composite)this.getContents());
            this._detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
        }
        Point newSize = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
    }

    protected Control createDialogArea(Composite parent) {
        this.createMessageArea(parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData childData = new GridData(1808);
        childData.horizontalSpan = 2;
        composite.setLayoutData((Object)childData);
        composite.setFont(parent.getFont());
        return composite;
    }

    protected Text createTextArea(Composite parent) {
        this._textArea = new Text(parent, 2818);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this._exception.printStackTrace(pw);
        this._textArea.setText(sw.toString());
        GridData data = new GridData(1808);
        data.heightHint = 200;
        data.horizontalSpan = 2;
        this._textArea.setLayoutData((Object)data);
        this._textArea.setFont(parent.getFont());
        this._textArea.setEditable(false);
        this._textCreated = true;
        return this._textArea;
    }
}

