/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.dialogs.AbstractFieldEditor;
import org.eclipse.birt.report.designer.internal.ui.dialogs.StylePreferenceStore;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.ui.widget.ColorBuilder;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

public class ColorFieldEditor
extends AbstractFieldEditor {
    private ColorBuilder colorSelector;

    protected ColorFieldEditor() {
    }

    public ColorFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.colorSelector.getLayoutData()).horizontalSpan = numColumns - 1;
        ((GridData)this.colorSelector.getLayoutData()).widthHint = 85;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        control.setLayoutData((Object)gd);
        Composite ctrl = this.getChangeControl(parent);
        gd = new GridData();
        ctrl.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        RGB rgb = DEUtil.getRGBValue((int)ColorUtil.parseColor((String)this.getPreferenceStore().getString(this.getPreferenceName())));
        this.getColorSelector().setRGB(rgb);
        this.setOldValue(this.getStringValue());
    }

    protected void doLoadDefault() {
        if (this.colorSelector == null) {
            return;
        }
        RGB rgb = DEUtil.getRGBValue((int)ColorUtil.parseColor((String)this.getPreferenceStore().getDefaultString(this.getPreferenceName())));
        this.colorSelector.setRGB(rgb);
        this.setDefaultValue(this.getStringValue());
        if (this.getPreferenceStore() instanceof StylePreferenceStore) {
            StylePreferenceStore store = (StylePreferenceStore)this.getPreferenceStore();
            if (store.hasLocalValue(this.getPreferenceName())) {
                this.markDirty(true);
            } else {
                this.markDirty(false);
            }
        } else {
            this.markDirty(true);
        }
    }

    public ColorBuilder getColorSelector() {
        return this.colorSelector;
    }

    protected Composite getChangeControl(Composite parent) {
        if (this.colorSelector == null) {
            this.colorSelector = new ColorBuilder(parent, 0);
            this.colorSelector.setChoiceSet(ChoiceSetFactory.getElementChoiceSet("Style", this.getPreferenceName()));
            this.colorSelector.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    ColorFieldEditor.this.valueChanged("field_editor_value");
                }
            });
        } else {
            this.checkParent((Control)this.colorSelector, parent);
        }
        return this.colorSelector;
    }

    public int getNumberOfControls() {
        return 2;
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getChangeControl(parent).setEnabled(enabled);
    }

    @Override
    protected String getStringValue() {
        RGB rgb = this.getColorSelector().getRGB();
        if (rgb == null) {
            return null;
        }
        return ColorUtil.format((int)DEUtil.getRGBInt((RGB)this.getColorSelector().getRGB()), (int)1);
    }
}

