/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.data.providers;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.RefreshAction;
import org.eclipse.birt.report.designer.ui.actions.ShowPropertyAction;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;

public class DataSetNodeProvider
extends DefaultNodeProvider {
    private static Comparator<ResultSetColumnHandle> comp = new Comparator<ResultSetColumnHandle>(){
        private Collator collator = Collator.getInstance();

        @Override
        public int compare(ResultSetColumnHandle r1, ResultSetColumnHandle r2) {
            return this.collator.compare(r1.getColumnName(), r2.getColumnName());
        }
    };

    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        super.createContextMenu(sourceViewer, object, menu);
        menu.insertBefore("additions-refresh", (IAction)new ShowPropertyAction(object));
        menu.insertAfter("additions-refresh", (IContributionItem)new Separator());
        RefreshAction action = new RefreshAction(sourceViewer);
        if (action.isEnabled()) {
            menu.insertAfter("additions-refresh", (IAction)action);
        }
    }

    public String getNodeDisplayName(Object model) {
        return DEUtil.getDisplayLabel((Object)model, (boolean)false);
    }

    public Object[] getChildren(Object object) {
        DataSetHandle handle = (DataSetHandle)object;
        ArrayList params = new ArrayList(10);
        CachedMetaDataHandle cmdh = null;
        try {
            cmdh = DataSetUIUtil.getCachedMetaDataHandle((DataSetHandle)handle);
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
        ArrayList<ResultSetColumnHandle> columns = new ArrayList<ResultSetColumnHandle>(10);
        if (cmdh != null) {
            for (ResultSetColumnHandle element : cmdh.getResultSet()) {
                columns.add(element);
            }
        }
        Collections.sort(columns, comp);
        PropertyHandle parameters = handle.getPropertyHandle("parameters");
        Iterator iter = parameters.iterator();
        if (iter != null) {
            while (iter.hasNext()) {
                Object dataSetParameter = iter.next();
                if (!((DataSetParameterHandle)dataSetParameter).isOutput()) continue;
                params.add(dataSetParameter);
            }
        }
        Object[] parametersArray = params.toArray();
        Object[] both = new Object[columns.toArray().length + parametersArray.length];
        System.arraycopy(columns.toArray(), 0, both, 0, columns.toArray().length);
        System.arraycopy(parametersArray, 0, both, columns.toArray().length, parametersArray.length);
        return both;
    }

    public boolean hasChildren(Object object) {
        return true;
    }
}

