/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.series;

import java.util.Iterator;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.ui.swt.DefaultSelectDataComponent;
import org.eclipse.birt.chart.ui.swt.DefaultSeriesUIProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataComponent;
import org.eclipse.birt.chart.ui.swt.series.PieSeriesAttributeComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.BaseDataDefinitionComponent;
import org.eclipse.birt.chart.ui.swt.wizard.data.YOptionalDataDefinitionComponent;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.swt.widgets.Composite;

public class PieSeriesUIProvider
extends DefaultSeriesUIProvider {
    private static final String SERIES_CLASS = "org.eclipse.birt.chart.model.type.impl.PieSeriesImpl";

    public Composite getSeriesAttributeSheet(Composite parent, Series series, ChartWizardContext context) {
        return new PieSeriesAttributeComposite(parent, 0, series, context);
    }

    public String getSeriesClass() {
        return SERIES_CLASS;
    }

    public ISelectDataComponent getSeriesDataComponent(int seriesType, SeriesDefinition seriesDefn, ChartWizardContext context, String sTitle) {
        if (seriesType == 1) {
            return new BaseDataDefinitionComponent(2, "value", seriesDefn, ChartUIUtil.getDataQuery((SeriesDefinition)seriesDefn, (int)0), context, sTitle);
        }
        if (seriesType == 2) {
            YOptionalDataDefinitionComponent ddc = new YOptionalDataDefinitionComponent(1, "optional", seriesDefn, seriesDefn.getQuery(), context, sTitle);
            return ddc;
        }
        return new DefaultSelectDataComponent();
    }

    public void validateSeriesBindingType(Series series, IDataServiceProvider idsp) throws ChartException {
        Iterator iterEntries = series.getDataDefinition().iterator();
        boolean bIsNumericAgg = ChartUIUtil.isNumericAggregate((Series)series);
        while (iterEntries.hasNext()) {
            Query query = (Query)iterEntries.next();
            DataType dataType = idsp.getDataType(query.getDefinition());
            if (bIsNumericAgg) {
                dataType = DataType.NUMERIC_LITERAL;
            }
            if (dataType != DataType.TEXT_LITERAL && dataType != DataType.DATE_TIME_LITERAL) continue;
            ChartExpressionUtil.ExpressionCodec codec = ChartModelHelper.instance().createExpressionCodec();
            codec.decode(query.getDefinition());
            throw new ChartException("org.eclipse.birt.chart.ui.extension", 19, codec.getExpression());
        }
    }
}

