/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.runtime;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class ErrorStatus
extends MultiStatus {
    public ErrorStatus(String pluginId, int code, String reason, Throwable exception) {
        super(pluginId, code, reason, exception);
    }

    public void addStatus(String message, int severity) {
        this.merge((IStatus)new Status(severity, this.getPlugin(), this.getCode(), message, null));
    }

    public void addWarning(String message) {
        this.addStatus(message, 2);
    }

    public void addError(String message) {
        this.addStatus(message, 4);
    }

    public void addInformation(String message) {
        this.addStatus(message, 1);
    }

    public void addCause(Throwable e) {
        String message = e.getLocalizedMessage();
        if (message == null) {
            message = e.getClass().getName();
        }
        this.merge((IStatus)new Status(4, this.getPlugin(), this.getCode(), message, e));
    }

    public int getErrorCode() {
        return this.getCode();
    }

    public int getSeverity() {
        if (this.getChildren().length == 0) {
            return 4;
        }
        return super.getSeverity();
    }

    public void setException(Throwable exception) {
        super.setException(exception);
    }
}

