/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.math.BigDecimal;
import java.sql.Time;
import java.util.Date;
import java.util.List;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.model.api.DynamicFilterParameterHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;

public class ReportParameterUtil {
    public static void completeParamDefalutValues(IEngineTask engineTask, ModuleHandle moduleHandle) {
        List paramsList = moduleHandle.getAllParameters();
        int i = 0;
        while (i < paramsList.size()) {
            List defaultValue;
            Object parameterObject = paramsList.get(i);
            if (parameterObject instanceof ScalarParameterHandle) {
                ScalarParameterHandle parameterHandle = (ScalarParameterHandle)parameterObject;
                if (!(parameterHandle.getDefaultValueList() != null && parameterHandle.getDefaultValueList().size() != 0 || parameterHandle.getDefaultValueListMethod() != null && parameterHandle.getDefaultValueListMethod().trim().length() != 0)) {
                    String paramType = parameterHandle.getParamType();
                    if ("multi-value".equals(paramType)) {
                        engineTask.setParameter(parameterHandle.getName(), (Object)new Object[]{ReportParameterUtil.getDummyDefaultValue(parameterHandle)}, parameterHandle.getDisplayName());
                    } else {
                        engineTask.setParameter(parameterHandle.getName(), ReportParameterUtil.getDummyDefaultValue(parameterHandle), parameterHandle.getDisplayName());
                    }
                }
            } else if (parameterObject instanceof DynamicFilterParameterHandle && ((defaultValue = ((DynamicFilterParameterHandle)parameterObject).getDefaultValueList()) == null || defaultValue.size() == 0)) {
                engineTask.setParameter(((DynamicFilterParameterHandle)parameterObject).getName(), (Object)"true", ((DynamicFilterParameterHandle)parameterObject).getDisplayName());
            }
            ++i;
        }
    }

    public static Object getDummyDefaultValue(ScalarParameterHandle parameterHandle) {
        String type = parameterHandle.getDataType();
        if (!parameterHandle.isRequired()) {
            return null;
        }
        if ("string".equals(type)) {
            return "";
        }
        if ("float".equals(type)) {
            return new Double(0.0);
        }
        if ("decimal".equals(type)) {
            return new BigDecimal(0.0);
        }
        if ("dateTime".equals(type)) {
            return new Date(0L);
        }
        if ("date".equals(type)) {
            return new java.sql.Date(0L);
        }
        if ("time".equals(type)) {
            return new Time(0L);
        }
        if ("boolean".equals(type)) {
            return Boolean.FALSE;
        }
        if ("integer".equals(type)) {
            return 0;
        }
        return null;
    }
}

