/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.impl.DataSetMetaDataHelper;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtility;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetViewData;
import org.eclipse.birt.report.designer.data.ui.dataset.OutputColumnsContentProvider;
import org.eclipse.birt.report.designer.data.ui.dataset.OutputColumnsLabelProvider;
import org.eclipse.birt.report.designer.data.ui.dataset.PropertyHandleInputDialog;
import org.eclipse.birt.report.designer.data.ui.dataset.PropertyHandleTableViewer;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.data.ui.util.ControlProvider;
import org.eclipse.birt.report.designer.data.ui.util.DataSetExceptionHandler;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.DummyEngineTask;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ResourceEditDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.properties.IPropertyPage;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportEngineFactory;
import org.eclipse.birt.report.engine.api.impl.ReportEngineHelper;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DerivedDataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.elements.structures.ColumnHint;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class OutputColumnsPage
extends AbstractDescriptionPropertyPage
implements Listener {
    protected transient PropertyHandleTableViewer viewer = null;
    private transient boolean modelChanged = true;
    protected boolean isNewlyCreated = false;
    private boolean pageActivated = false;
    protected String sourceQueryText = null;
    protected boolean getDefaultAnalysisForNullValue = true;
    protected String originalAlias = "";
    protected String originalDisplayName = "";
    protected String originalDisplayNameKey = "";
    protected static String[] cellLabels = new String[]{Messages.getString((String)"dataset.editor.title.name"), Messages.getString((String)"dataset.editor.title.type"), Messages.getString((String)"dataset.editor.title.alias"), Messages.getString((String)"dataset.editor.title.displayName"), Messages.getString((String)"dataset.editor.title.displayNameKey")};
    protected static String[] dialogLabels = new String[]{Messages.getString((String)"dataset.editor.inputDialog.name"), Messages.getString((String)"dataset.editor.inputDialog.type"), Messages.getString((String)"dataset.editor.inputDialog.alias"), Messages.getString((String)"dataset.editor.inputDialog.displayName"), Messages.getString((String)"dataset.editor.inputDialog.displayNameKey")};
    protected static String[] cellProperties = new String[]{"name", "dataTypeDisplayName", "alias", "realDisplayName", "displayNameKey"};
    protected static IChoiceSet dataTypes = DEUtil.getMetaDataDictionary().getStructure("ComputedColumn").getMember("dataType").getAllowedChoices();

    public OutputColumnsPage() {
        this.isNewlyCreated = false;
        this.pageActivated = false;
    }

    public OutputColumnsPage(boolean isNewlyCreated) {
        this.isNewlyCreated = isNewlyCreated;
        this.pageActivated = false;
    }

    public Control createContents(Composite parent) {
        this.createTableViewer(parent);
        this.addListeners();
        ((DataSetHandle)this.getContainer().getModel()).addListener((Listener)this);
        return this.viewer.getControl();
    }

    protected void createTableViewer(Composite parent) {
        this.viewer = new PropertyHandleTableViewer(parent, false, true, false);
        TableColumn column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[0]);
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[1]);
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[2]);
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[3]);
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[4]);
        column.setWidth(150);
        this.viewer.getViewer().setContentProvider((IContentProvider)new OutputColumnsContentProvider());
        this.viewer.getViewer().setLabelProvider((IBaseLabelProvider)new OutputColumnsLabelProvider());
    }

    private void addListeners() {
        this.viewer.getNewButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutputColumnsPage.this.doEdit();
            }
        });
        this.viewer.getViewer().getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                OutputColumnsPage.this.doEdit();
            }
        });
    }

    private void doEdit() {
        int index = this.viewer.getViewer().getTable().getSelectionIndex();
        if (index == -1) {
            return;
        }
        DataSetViewData data = (DataSetViewData)this.viewer.getViewer().getTable().getItem(index).getData();
        this.originalAlias = data.getAlias();
        this.originalDisplayName = data.getRealDisplayName();
        this.originalDisplayNameKey = data.getDisplayNameKey();
        this.doEdit(data);
    }

    protected void doEdit(DataSetViewData data) {
        OutputColumnInputDialog dlg = new OutputColumnInputDialog(data);
        if (dlg.open() == 0) {
            this.viewer.getViewer().update((Object)data, null);
            this.updateMessage();
        }
    }

    public void pageActivated() {
        if (this.modelChanged) {
            this.updateOutputColumns();
            this.modelChanged = false;
        }
        this.setPageProperties();
        this.getContainer().setMessage(Messages.getString((String)"dataset.editor.outputColumns"), 0);
        this.viewer.getViewer().getTable().select(0);
        this.pageActivated = true;
    }

    protected void setPageProperties() {
        this.viewer.getNewButton().setEnabled(this.viewer.getViewer().getInput() != null && ((DataSetViewData[])this.viewer.getViewer().getInput()).length != 0);
        this.viewer.getNewButton().setText(Messages.getString((String)"PropertyHandleTableViewer.Button.Edit"));
        this.viewer.getNewButton().setToolTipText(Messages.getString((String)"OutputColumnPage.toolTipText.Edit"));
        this.viewer.getEditButton().setVisible(false);
        this.viewer.getRemoveButton().setVisible(false);
        this.viewer.getUpButton().setVisible(false);
        this.viewer.getDownButton().setVisible(false);
    }

    public boolean canLeave() {
        if (this.isValid()) {
            this.saveOutputColumns();
            if (this.modelChanged) {
                ((DataSetEditor)this.getContainer()).updateDataSetDesign((IPropertyPage)this);
                this.updateColumnCache();
                this.modelChanged = false;
            }
            this.pageActivated = false;
            return super.canLeave();
        }
        return false;
    }

    protected void updateColumnCache() {
        try {
            DataSetUIUtil.updateColumnCache((DataSetHandle)((DataSetHandle)this.getContainer().getModel()));
        }
        catch (SemanticException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public boolean performOk() {
        if (this.isValid()) {
            this.saveOutputColumns();
            ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
            if (this.modelChanged) {
                ((DataSetEditor)this.getContainer()).updateDataSetDesign((IPropertyPage)this);
                this.modelChanged = false;
            }
            try {
                if (!this.pageActivated) {
                    this.setAnalysisTypeForColumn();
                }
            }
            catch (BirtException e) {
                ExceptionHandler.handle((Throwable)e, (boolean)true);
            }
            ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
            return super.performOk();
        }
        ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
        return false;
    }

    public String getPageDescription() {
        return Messages.getString((String)"OutputColumnsPage.description");
    }

    public String getToolTip() {
        return Messages.getString((String)"OutputColumnPage.OutputColumns.Tooltip");
    }

    protected final void updateOutputColumns() {
        this.clearOutputColumns();
        try {
            this.populateOutputColums();
        }
        catch (BirtException e) {
            DataSetExceptionHandler.handle((Throwable)e);
        }
    }

    protected void populateOutputColums() throws BirtException {
        ClassLoader oldContextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader parentLoader = oldContextLoader;
        if (parentLoader == null) {
            parentLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        ClassLoader newContextLoader = DataSetProvider.getCustomScriptClassLoader((ClassLoader)parentLoader, (ModuleHandle)((DataSetEditor)this.getContainer()).getHandle().getModuleHandle());
        ModuleHandle handle = ((DataSetEditor)this.getContainer()).getHandle().getModuleHandle();
        if (handle instanceof ReportDesignHandle) {
            HashMap dataSetMap = new HashMap();
            HashMap dataSourceMap = new HashMap();
            DummyEngineTask engineTask = null;
            DataRequestSession session = null;
            ReportEngine engine = null;
            try {
                PropertyHandle properyHandle;
                EngineConfig ec = new EngineConfig();
                ec.getAppContext().put("PARENT_CLASSLOADER", newContextLoader);
                engine = (ReportEngine)new ReportEngineFactory().createReportEngine(ec);
                DataSetMetaDataHelper.clearPropertyBindingMap((DataSetHandle)((DataSetEditor)this.getContainer()).getHandle(), dataSetMap, dataSourceMap);
                ReportDesignHandle copy = (ReportDesignHandle)handle.copy().getHandle(null);
                engineTask = new DummyEngineTask(engine, new ReportEngineHelper(engine).openReportDesign(copy), (ModuleHandle)copy);
                session = engineTask.getDataSession();
                engineTask.run();
                DataSetViewData[] viewDatas = DataSetProvider.getCurrentInstance().populateAllOutputColumns(((DataSetEditor)this.getContainer()).getHandle(), session);
                if (viewDatas == null) {
                    viewDatas = ((DataSetEditor)this.getContainer()).getCurrentItemModel(false);
                }
                this.updateDefaultAnalysisEnablement(viewDatas);
                if (this.isNewlyCreated) {
                    this.updateDefaultPropertyValues(viewDatas);
                }
                if ((((DataSetEditor)this.getContainer()).getHandle() instanceof JointDataSetHandle || ((DataSetEditor)this.getContainer()).getHandle() instanceof DerivedDataSetHandle) && (properyHandle = ((DataSetEditor)this.getContainer()).getHandle().getPropertyHandle("columnHints")) != null) {
                    int i = 0;
                    while (i < viewDatas.length) {
                        for (ColumnHintHandle column : properyHandle) {
                            if (!viewDatas[i].getName().equals(column.getColumnName())) continue;
                            viewDatas[i].setAlias(column.getAlias());
                            viewDatas[i].setDisplayName(column.getDisplayName());
                            viewDatas[i].setDisplayNameKey(column.getDisplayNameKey());
                            break;
                        }
                        ++i;
                    }
                }
                this.viewer.getViewer().setInput((Object)viewDatas);
            }
            finally {
                session.shutdown();
                engineTask.close();
                engine.destroy();
                DataSetMetaDataHelper.resetPropertyBinding((DataSetHandle)((DataSetEditor)this.getContainer()).getHandle(), dataSetMap, dataSourceMap);
            }
        }
        DataSessionContext context = new DataSessionContext(3, ((DataSetEditor)this.getContainer()).getHandle().getModuleHandle());
        DataRequestSession session = DataRequestSession.newSession((DataSessionContext)context);
        try {
            DataSetViewData[] viewDatas = DataSetProvider.getCurrentInstance().populateAllOutputColumns(((DataSetEditor)this.getContainer()).getHandle(), session);
            if (viewDatas == null) {
                viewDatas = ((DataSetEditor)this.getContainer()).getCurrentItemModel(false);
            }
            this.updateDefaultAnalysisEnablement(viewDatas);
            if (this.isNewlyCreated) {
                this.updateDefaultPropertyValues(viewDatas);
            }
            this.viewer.getViewer().setInput((Object)viewDatas);
        }
        finally {
            session.shutdown();
        }
        Thread.currentThread().setContextClassLoader(oldContextLoader);
    }

    protected void updateDefaultPropertyValues(DataSetViewData[] viewDatas) {
        this.updateAnalysisTypes(viewDatas, true);
    }

    private void updateDefaultAnalysisEnablement(DataSetViewData[] viewDatas) {
        DataSetHandle ds = ((DataSetEditor)this.getContainer()).getHandle();
        if (ds instanceof OdaDataSetHandle) {
            String queryText = ((OdaDataSetHandle)ds).getQueryText();
            if (queryText != null && !queryText.equals(this.sourceQueryText)) {
                this.getDefaultAnalysisForNullValue = this.sourceQueryText != null;
                this.sourceQueryText = queryText;
                if (this.isNewlyCreated) {
                    this.getDefaultAnalysisForNullValue = true;
                } else {
                    this.updateAnalysisTypes(viewDatas, true);
                }
            }
            if (!this.isNewlyCreated && this.modelChanged) {
                this.getDefaultAnalysisForNullValue = true;
                this.updateAnalysisTypes(viewDatas, false);
            }
        }
    }

    private void updateAnalysisTypes(DataSetViewData[] viewDatas, boolean updateFlag) {
        int i = 0;
        while (i < viewDatas.length) {
            DataSetViewData item = viewDatas[i];
            ColumnHintHandle hint = this.findColumnHint(item);
            if (hint != null) {
                try {
                    String analysis = hint.getAnalysis();
                    if (analysis == null && this.getDefaultAnalysisForNullValue && updateFlag) {
                        hint.setAnalysis(DataSetUIUtility.getDefaultAnalysisType(item.getDataTypeName()));
                    }
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                item.setAnalysis(hint.getAnalysis());
            }
            ++i;
        }
    }

    protected final void clearOutputColumns() {
        this.viewer.getViewer().getTable().removeAll();
    }

    protected ColumnHintHandle findColumnHint(DataSetViewData viewData) {
        PropertyHandle properyHandle = ((DataSetEditor)this.getContainer()).getHandle().getPropertyHandle("columnHints");
        for (ColumnHintHandle column : properyHandle) {
            if (!viewData.getName().equals(column.getColumnName())) continue;
            return column;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setAnalysisTypeForColumn() throws BirtException {
        if (this.isNewlyCreated) return;
        DataSetHandle ds = ((DataSetEditor)this.getContainer()).getHandle();
        DataSetViewData[] viewData = DataSetProvider.getCurrentInstance().getColumns(ds, true);
        PropertyHandle handle = ds.getPropertyHandle("columnHints");
        Iterator iter = handle.iterator();
        if (iter == null) return;
        while (iter.hasNext()) {
            ColumnHintHandle hint = (ColumnHintHandle)iter.next();
            int i = 0;
            while (i < viewData.length) {
                if (viewData[i].getName().equals(hint.getColumnName()) && hint.getAnalysis() == null) {
                    try {
                        hint.setAnalysis(DataSetUIUtility.getDefaultAnalysisType(viewData[i].getDataTypeName()));
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle((Throwable)e, (boolean)true);
                    }
                }
                ++i;
            }
        }
    }

    protected void saveOutputColumns() {
        DataSetViewData[] items;
        PropertyHandle handle = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("columnHints");
        if (this.viewer != null && this.viewer.getViewer() != null && this.viewer.getViewer().getInput() != null) {
            items = (DataSetViewData[])this.viewer.getViewer().getInput();
            String columnName = null;
            boolean found = false;
            int n = 0;
            while (n < items.length) {
                ColumnHintHandle hint;
                columnName = items[n].getName();
                found = false;
                Iterator iter = handle.iterator();
                if (iter != null) {
                    while (iter.hasNext() && !found) {
                        hint = (ColumnHintHandle)iter.next();
                        if (!hint.getColumnName().equals(columnName)) continue;
                        found = true;
                        if (items[n].getRealDisplayName() == null || items[n].getRealDisplayName().trim().length() == 0) {
                            hint.setDisplayName(null);
                        } else {
                            hint.setDisplayName(items[n].getRealDisplayName());
                        }
                        if (items[n].getDisplayNameKey() == null || items[n].getDisplayNameKey().trim().length() == 0) {
                            hint.setDisplayNameKey(null);
                        } else {
                            hint.setDisplayNameKey(items[n].getDisplayNameKey());
                        }
                        if (items[n].getAlias() == null || items[n].getAlias().trim().length() == 0) {
                            hint.setAlias(null);
                        } else {
                            hint.setAlias(items[n].getAlias());
                        }
                        if (items[n].getHelpText() == null || items[n].getHelpText().trim().length() == 0) {
                            hint.setHelpText(null);
                            continue;
                        }
                        hint.setHelpText(items[n].getHelpText());
                    }
                }
                if (!found && this.isColumnHintRequired(items[n])) {
                    hint = new ColumnHint();
                    hint.setProperty("columnName", (Object)columnName);
                    if (items[n].getRealDisplayName() != null && items[n].getRealDisplayName().trim().length() > 0) {
                        hint.setProperty("displayName", (Object)items[n].getRealDisplayName());
                    }
                    if (items[n].getDisplayNameKey() != null && items[n].getDisplayNameKey().trim().length() > 0) {
                        hint.setProperty("displayNameID", (Object)items[n].getDisplayNameKey());
                    }
                    if (items[n].getAlias() != null && items[n].getAlias().trim().length() > 0) {
                        hint.setProperty("alias", (Object)items[n].getAlias());
                    }
                    if (items[n].getHelpText() != null && items[n].getHelpText().trim().length() > 0) {
                        hint.setProperty("helpText", (Object)items[n].getHelpText());
                    }
                    try {
                        handle.addItem((IStructure)hint);
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                }
                ++n;
            }
        }
        if ((DataSetHandle)this.getContainer().getModel() instanceof OdaDataSetHandle) {
            handle = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("resultSet");
            if (this.viewer != null && this.viewer.getViewer() != null && this.viewer.getViewer().getInput() != null) {
                items = (DataSetViewData[])this.viewer.getViewer().getInput();
                int n = 0;
                while (n < items.length) {
                    String dataType = items[n].getDataTypeName();
                    Iterator iter = handle.iterator();
                    if (iter != null) {
                        while (iter.hasNext()) {
                            try {
                                ResultSetColumnHandle resultSet = (ResultSetColumnHandle)iter.next();
                                if (!resultSet.getColumnName().equals(items[n].getName())) continue;
                                resultSet.setDataType(dataType);
                                break;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    ++n;
                }
            }
        }
    }

    protected boolean isUnique(String newValue, DataSetViewData currentItem) {
        DataSetViewData[] items = null;
        try {
            items = this.viewer == null || this.viewer.getViewer() == null ? DataSetProvider.getCurrentInstance().getColumns(((DataSetEditor)this.getContainer()).getHandle(), false, true) : (DataSetViewData[])this.viewer.getViewer().getInput();
        }
        catch (BirtException e) {
            DataSetExceptionHandler.handle((Throwable)e);
        }
        int i = 0;
        while (i < items.length) {
            if ((items[i].getName() == null || !items[i].getName().equals(currentItem.getName())) && (items[i].getAlias() != null && items[i].getAlias().equals(newValue) || items[i].getName() != null && items[i].getName().equals(newValue))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isValid() {
        boolean validate = true;
        DataSetViewData[] items = null;
        if (this.viewer == null || this.viewer.getViewer() == null) {
            try {
                items = DataSetProvider.getCurrentInstance().getColumns(((DataSetEditor)this.getContainer()).getHandle(), false, true);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e, (boolean)true);
            }
        } else {
            items = (DataSetViewData[])this.viewer.getViewer().getInput();
        }
        int i = 0;
        while (items != null && i < items.length && validate) {
            String newColumnNameOrAlias = items[i].getAlias();
            if (newColumnNameOrAlias != null && newColumnNameOrAlias.length() > 0) {
                int n = 0;
                while (n < items.length) {
                    if (i != n && (items[n].getName() != null && items[n].getName().equals(newColumnNameOrAlias) || items[n].getAlias() != null && items[n].getAlias().equals(newColumnNameOrAlias))) {
                        validate = false;
                        this.getContainer().setMessage(Messages.getFormattedString((String)"dataset.editor.error.columnOrAliasNameAlreadyUsed", (Object[])new Object[]{newColumnNameOrAlias, n + 1}), 3);
                        break;
                    }
                    ++n;
                }
            }
            ++i;
        }
        return validate;
    }

    protected void updateMessage() {
        if (this.isValid()) {
            this.getContainer().setMessage(Messages.getString((String)"dataset.editor.outputColumns"), 0);
        }
    }

    protected boolean isColumnHintRequired(DataSetViewData model) {
        return model.getRealDisplayName() != null && model.getRealDisplayName().trim().length() != 0 || model.getDisplayNameKey() != null && model.getDisplayNameKey().trim().length() != 0 || model.getAlias() != null && model.getAlias().trim().length() != 0 || model.getHelpText() != null && model.getHelpText().trim().length() != 0;
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        if (focus.equals(this.getContainer().getModel())) {
            this.modelChanged = true;
        }
    }

    public boolean performCancel() {
        if (this.viewer != null && this.viewer.getViewer() != null && this.viewer.getViewer().getInput() != null) {
            DataSetProvider manager = DataSetProvider.getCurrentInstance();
            manager.updateModel(((DataSetEditor)this.getContainer()).getHandle(), (DataSetViewData[])this.viewer.getViewer().getInput());
        }
        ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
        return super.performCancel();
    }

    protected boolean checkDisplayNameKey(String displayNameKey) {
        boolean result = true;
        if (displayNameKey.trim().indexOf(32) != -1) {
            result = false;
        }
        return result;
    }

    protected String[] getCompatibleDataTypes(String dataType) {
        String[] compatibleTypes = null;
        if ("string".equals(dataType)) {
            compatibleTypes = new String[]{"decimal", "integer", "boolean", "date-time", "date", "float", "time", "blob"};
        } else if ("decimal".equals(dataType)) {
            compatibleTypes = new String[]{"integer", "float", "string"};
        } else if ("time".equals(dataType)) {
            compatibleTypes = new String[]{"string"};
        } else if ("date".equals(dataType)) {
            compatibleTypes = new String[]{"string"};
        } else if ("date-time".equals(dataType)) {
            compatibleTypes = new String[]{"string", "date", "time"};
        } else if ("integer".equals(dataType)) {
            compatibleTypes = new String[]{"decimal", "float", "string"};
        } else if ("javaObject".equals(dataType)) {
            compatibleTypes = new String[]{"string"};
        } else if ("boolean".equals(dataType)) {
            compatibleTypes = new String[]{"string", "decimal", "float", "integer"};
        } else if ("float".equals(dataType)) {
            compatibleTypes = new String[]{"string", "integer", "decimal"};
        } else if ("blob".equals(dataType)) {
            compatibleTypes = new String[]{"string"};
        }
        if (compatibleTypes == null) {
            return new String[0];
        }
        int i = 0;
        while (i < compatibleTypes.length) {
            compatibleTypes[i] = dataTypes.findChoice(compatibleTypes[i]).getDisplayName();
            ++i;
        }
        return compatibleTypes;
    }

    private class OutputColumnInputDialog
    extends PropertyHandleInputDialog {
        DataSetViewData data;
        private CCombo cmbDataType;
        private String originalDataType;

        protected OutputColumnInputDialog(Object structureOrHandle) {
            super(structureOrHandle);
            this.data = null;
            this.data = (DataSetViewData)structureOrHandle;
        }

        @Override
        protected void setSystemHelp(Composite composite) {
            Utility.setSystemHelp((Control)composite, (String)"org.eclipse.birt.cshelp.Dialog_Output_Columns_ID");
        }

        @Override
        protected void createCustomControls(Composite parent) {
            try {
                this.createCells(parent);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }

        private void createCells(Composite parent) throws IllegalArgumentException, IntrospectionException, IllegalAccessException, InvocationTargetException {
            int i = 0;
            while (i < cellProperties.length) {
                ControlProvider.createLabel(parent, dialogLabels[i]);
                if (i == 1) {
                    this.createDataTypeCombo(parent);
                } else if (i == 4) {
                    this.createResourceCell(parent, i);
                } else {
                    this.createTextCell(parent, i);
                }
                ++i;
            }
        }

        private boolean checkForPotentialProblems(String dataType) {
            return "decimal".equals(dataType) ? "float".equals(dataTypes.findChoiceByDisplayName(this.cmbDataType.getText()).getName()) || "integer".equals(dataTypes.findChoiceByDisplayName(this.cmbDataType.getText()).getName()) : "float".equals(dataType) && "integer".equals(dataTypes.findChoiceByDisplayName(this.cmbDataType.getText()).getName());
        }

        private void createDataTypeCombo(Composite parent) throws IllegalArgumentException, IntrospectionException, IllegalAccessException, InvocationTargetException {
            String selectedItem;
            this.cmbDataType = new CCombo(parent, 2056);
            this.cmbDataType.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(2));
            this.originalDataType = selectedItem = this.data.getDataTypeName();
            this.cmbDataType.add(dataTypes.findChoice(selectedItem).getDisplayName());
            String[] compatibleDisplayNames = OutputColumnsPage.this.getCompatibleDataTypes(selectedItem);
            int i = 0;
            while (i < compatibleDisplayNames.length) {
                this.cmbDataType.add(compatibleDisplayNames[i]);
                ++i;
            }
            this.cmbDataType.select(0);
            DataSetHandle dataSetHandle = (DataSetHandle)OutputColumnsPage.this.getContainer().getModel();
            if (dataSetHandle instanceof OdaDataSetHandle) {
                DataSetViewData[] views = DataSetProvider.getCurrentInstance().getCachedDataSetItemModel(dataSetHandle, false);
                int i2 = 0;
                while (i2 < views.length) {
                    if (views[i2].getName().equals(this.data.getName()) && !views[i2].getDataTypeName().equals(this.data.getDataTypeName()) && this.cmbDataType.indexOf(views[i2].getDataTypeDisplayName()) < 0) {
                        this.cmbDataType.add(views[i2].getDataTypeDisplayName());
                        break;
                    }
                    ++i2;
                }
            } else {
                this.cmbDataType.setEnabled(false);
            }
            if (this.data.isComputedColumn()) {
                this.cmbDataType.setEnabled(false);
            }
            this.cmbDataType.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (OutputColumnInputDialog.this.checkForPotentialProblems(OutputColumnInputDialog.this.originalDataType)) {
                        if (MessageDialog.openQuestion((Shell)OutputColumnInputDialog.this.getShell(), (String)Messages.getString((String)"OutputColumnsPage.DataTypeConvert.Note"), (String)Messages.getString((String)"OutputColumnsPage.DataTypeConvert.Message"))) {
                            OutputColumnInputDialog.this.data.setDataTypeName(dataTypes.findChoiceByDisplayName(OutputColumnInputDialog.this.cmbDataType.getText()).getName());
                            OutputColumnInputDialog.this.data.setDataType(DataAdapterUtil.adaptModelDataType((String)dataTypes.findChoiceByDisplayName(OutputColumnInputDialog.this.cmbDataType.getText()).getName()));
                        } else {
                            OutputColumnInputDialog.this.cmbDataType.select(0);
                        }
                    } else {
                        OutputColumnInputDialog.this.data.setDataTypeName(dataTypes.findChoiceByDisplayName(OutputColumnInputDialog.this.cmbDataType.getText()).getName());
                        OutputColumnInputDialog.this.data.setDataType(DataAdapterUtil.adaptModelDataType((String)dataTypes.findChoiceByDisplayName(OutputColumnInputDialog.this.cmbDataType.getText()).getName()));
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }

        private void createTextCell(Composite parent, final int index) throws IllegalArgumentException, IntrospectionException, IllegalAccessException, InvocationTargetException {
            final Text tx = ControlProvider.createText(parent, (String)Utility.getProperty((Object)this.data, (String)cellProperties[index]));
            tx.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(2));
            if (index < 2) {
                tx.setEditable(false);
            } else {
                tx.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        try {
                            if (index == 2) {
                                boolean isUniqueName = OutputColumnsPage.this.isUnique(tx.getText(), OutputColumnInputDialog.this.data);
                                if (!isUniqueName) {
                                    OutputColumnInputDialog.this.updateStatus((IStatus)OutputColumnInputDialog.this.getMiscStatus(4, Messages.getString((String)"OutputColumnPage.OutputColumns.DuplicatedName")));
                                } else {
                                    OutputColumnInputDialog.this.updateStatus((IStatus)OutputColumnInputDialog.this.getOKStatus());
                                }
                            }
                            String txText = tx.getText();
                            if (tx.getText().trim().length() == 0) {
                                txText = null;
                            }
                            Utility.setProperty((Object)OutputColumnInputDialog.this.data, (String)cellProperties[index], (Object)txText);
                        }
                        catch (Exception e1) {
                            ExceptionHandler.handle((Throwable)e1);
                        }
                    }
                });
            }
            if (index == 2) {
                tx.setFocus();
            }
        }

        private void createResourceCell(Composite parent, final int index) throws IllegalArgumentException, IntrospectionException, IllegalAccessException, InvocationTargetException {
            final Text tx = ControlProvider.createText(parent, (String)Utility.getProperty((Object)this.data, (String)cellProperties[index]));
            tx.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(1));
            tx.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    try {
                        Utility.setProperty((Object)OutputColumnInputDialog.this.data, (String)cellProperties[index], (Object)tx.getText());
                        boolean check = OutputColumnsPage.this.checkDisplayNameKey(tx.getText());
                        if (!check) {
                            OutputColumnInputDialog.this.updateStatus((IStatus)OutputColumnInputDialog.this.getMiscStatus(4, Messages.getString((String)"ResourceKey.invalid.containSpace")));
                        }
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            });
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ResourceEditDialog dlg = new ResourceEditDialog(OutputColumnInputDialog.this.getShell(), Messages.getString((String)"ResourceKeyDescriptor.title.SelectKey"));
                    dlg.setResourceURLs(OutputColumnInputDialog.this.getResourceURLs());
                    if (dlg.open() == 0) {
                        tx.setText((String)dlg.getResult());
                    }
                }
            };
            Button bt = new Button(parent, 8);
            bt.setText("...");
            bt.addSelectionListener((SelectionListener)listener);
            if (this.getBaseName() == null) {
                bt.setEnabled(false);
            }
        }

        private String[] getBaseNames() {
            List resources = SessionHandleAdapter.getInstance().getReportDesignHandle().getIncludeResources();
            if (resources == null) {
                return null;
            }
            return resources.toArray(new String[0]);
        }

        private URL[] getResourceURLs() {
            String[] baseNames = this.getBaseNames();
            if (baseNames == null) {
                return null;
            }
            URL[] urls = new URL[baseNames.length];
            int i = 0;
            while (i < baseNames.length) {
                urls[i] = SessionHandleAdapter.getInstance().getReportDesignHandle().findResource(baseNames[i], 5);
                ++i;
            }
            return urls;
        }

        private String getBaseName() {
            return SessionHandleAdapter.getInstance().getReportDesignHandle().getIncludeResource();
        }

        @Override
        protected void rollback() {
            this.data.setAlias(OutputColumnsPage.this.originalAlias);
            this.data.setRealDisplayName(OutputColumnsPage.this.originalDisplayName);
            this.data.setDisplayNameKey(OutputColumnsPage.this.originalDisplayNameKey);
        }

        @Override
        protected IStatus validateSemantics(Object structureOrHandle) {
            return null;
        }

        @Override
        protected IStatus validateSyntax(Object structureOrHandle) {
            return null;
        }

        @Override
        protected String getTitle() {
            return Messages.getString((String)"OutputColumnPage.title.OutputColumnInputDialog.EditOutputColumn");
        }
    }
}

