/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.OperatorNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

class TernaryOperatorNode
extends OperatorNode {
    static final int K_TRIM = 0;
    static final int K_LOCATE = 1;
    static final int K_SUBSTRING = 2;
    static final int K_LIKE = 3;
    static final int K_TIMESTAMPADD = 4;
    static final int K_TIMESTAMPDIFF = 5;
    final int kind;
    String operator;
    String methodName;
    ValueNode receiver;
    ValueNode leftOperand;
    ValueNode rightOperand;
    String resultInterfaceType;
    String receiverInterfaceType;
    String leftInterfaceType;
    String rightInterfaceType;
    int trimType;
    static final String[] TernaryOperators = new String[]{"trim", "LOCATE", "substring", "like", "TIMESTAMPADD", "TIMESTAMPDIFF"};
    static final String[] TernaryMethodNames = new String[]{"ansiTrim", "locate", "substring", "like", "timestampAdd", "timestampDiff"};
    static final String[] TernaryResultType = new String[]{"org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.NumberDataValue", "org.apache.derby.iapi.types.ConcatableDataValue", "org.apache.derby.iapi.types.BooleanDataValue", "org.apache.derby.iapi.types.DateTimeDataValue", "org.apache.derby.iapi.types.NumberDataValue"};
    static final String[][] TernaryArgType = new String[][]{{"org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.StringDataValue", "java.lang.Integer"}, {"org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.NumberDataValue"}, {"org.apache.derby.iapi.types.ConcatableDataValue", "org.apache.derby.iapi.types.NumberDataValue", "org.apache.derby.iapi.types.NumberDataValue"}, {"org.apache.derby.iapi.types.DataValueDescriptor", "org.apache.derby.iapi.types.DataValueDescriptor", "org.apache.derby.iapi.types.DataValueDescriptor"}, {"org.apache.derby.iapi.types.DateTimeDataValue", "java.lang.Integer", "org.apache.derby.iapi.types.NumberDataValue"}, {"org.apache.derby.iapi.types.DateTimeDataValue", "java.lang.Integer", "org.apache.derby.iapi.types.DateTimeDataValue"}};

    TernaryOperatorNode(ValueNode valueNode, ValueNode valueNode2, ValueNode valueNode3, int n, ContextManager contextManager) {
        super(contextManager);
        this.kind = n;
        this.constructorMinion(valueNode, valueNode2, valueNode3, -1);
    }

    TernaryOperatorNode(ValueNode valueNode, ValueNode valueNode2, ValueNode valueNode3, int n, int n2, ContextManager contextManager) {
        super(contextManager);
        this.kind = n;
        this.constructorMinion(valueNode, valueNode2, valueNode3, n2);
    }

    private void constructorMinion(ValueNode valueNode, ValueNode valueNode2, ValueNode valueNode3, int n) {
        this.receiver = valueNode;
        this.leftOperand = valueNode2;
        this.rightOperand = valueNode3;
        this.operator = TernaryOperators[this.kind];
        this.methodName = TernaryMethodNames[this.kind];
        this.resultInterfaceType = TernaryResultType[this.kind];
        this.receiverInterfaceType = TernaryArgType[this.kind][0];
        this.leftInterfaceType = TernaryArgType[this.kind][1];
        this.rightInterfaceType = TernaryArgType[this.kind][2];
        if (n != -1) {
            this.trimType = n;
        }
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    void printSubNodes(int n) {
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        this.receiver = this.receiver.bindExpression(fromList, subqueryList, list);
        this.leftOperand = this.leftOperand.bindExpression(fromList, subqueryList, list);
        if (this.rightOperand != null) {
            this.rightOperand = this.rightOperand.bindExpression(fromList, subqueryList, list);
        }
        if (this.kind == 0) {
            this.trimBind();
        } else if (this.kind == 1) {
            this.locateBind();
        } else if (this.kind == 2) {
            this.substrBind();
        } else if (this.kind == 4) {
            this.timestampAddBind();
        } else if (this.kind == 5) {
            this.timestampDiffBind();
        }
        return this;
    }

    @Override
    ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        this.receiver = this.receiver.preprocess(n, fromList, subqueryList, predicateList);
        this.leftOperand = this.leftOperand.preprocess(n, fromList, subqueryList, predicateList);
        if (this.rightOperand != null) {
            this.rightOperand = this.rightOperand.preprocess(n, fromList, subqueryList, predicateList);
        }
        return this;
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n = 0;
        String string = null;
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, this.resultInterfaceType);
        this.receiver.generateExpression(expressionClassBuilder, methodBuilder);
        if (this.kind == 0) {
            methodBuilder.push(this.trimType);
            this.leftOperand.generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.cast(this.leftInterfaceType);
            methodBuilder.getField(localField);
            n = 3;
            string = this.receiverInterfaceType;
        } else if (this.kind == 1) {
            this.leftOperand.generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.upCast(this.leftInterfaceType);
            this.rightOperand.generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.upCast(this.rightInterfaceType);
            methodBuilder.getField(localField);
            n = 3;
        } else if (this.kind == 2) {
            this.leftOperand.generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.upCast(this.leftInterfaceType);
            if (this.rightOperand != null) {
                this.rightOperand.generateExpression(expressionClassBuilder, methodBuilder);
                methodBuilder.upCast(this.rightInterfaceType);
            } else {
                methodBuilder.pushNull(this.rightInterfaceType);
            }
            methodBuilder.getField(localField);
            methodBuilder.push(this.receiver.getTypeServices().getMaximumWidth());
            n = 4;
            string = this.receiverInterfaceType;
        } else if (this.kind == 4 || this.kind == 5) {
            Object object = this.leftOperand.getConstantValueAsObject();
            methodBuilder.push((Integer)object);
            this.rightOperand.generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.upCast(TernaryArgType[this.kind][2]);
            expressionClassBuilder.getCurrentDateExpression(methodBuilder);
            methodBuilder.getField(localField);
            n = 4;
            string = this.receiverInterfaceType;
        }
        methodBuilder.callMethod((short)185, string, this.methodName, this.resultInterfaceType, n);
        methodBuilder.putField(localField);
    }

    void setLeftOperand(ValueNode valueNode) {
        this.leftOperand = valueNode;
    }

    ValueNode getLeftOperand() {
        return this.leftOperand;
    }

    void setRightOperand(ValueNode valueNode) {
        this.rightOperand = valueNode;
    }

    ValueNode getRightOperand() {
        return this.rightOperand;
    }

    @Override
    boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        boolean bl2 = this.receiver.categorize(jBitSet, bl);
        boolean bl3 = bl2 = this.leftOperand.categorize(jBitSet, bl) && bl2;
        if (this.rightOperand != null) {
            bl2 = this.rightOperand.categorize(jBitSet, bl) && bl2;
        }
        return bl2;
    }

    @Override
    ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.receiver = this.receiver.remapColumnReferencesToExpressions();
        this.leftOperand = this.leftOperand.remapColumnReferencesToExpressions();
        if (this.rightOperand != null) {
            this.rightOperand = this.rightOperand.remapColumnReferencesToExpressions();
        }
        return this;
    }

    @Override
    boolean isConstantExpression() {
        return this.receiver.isConstantExpression() && this.leftOperand.isConstantExpression() && (this.rightOperand == null || this.rightOperand.isConstantExpression());
    }

    @Override
    boolean constantExpression(PredicateList predicateList) {
        return this.receiver.constantExpression(predicateList) && this.leftOperand.constantExpression(predicateList) && (this.rightOperand == null || this.rightOperand.constantExpression(predicateList));
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.receiver != null) {
            this.receiver = (ValueNode)this.receiver.accept(visitor);
        }
        if (this.leftOperand != null) {
            this.leftOperand = (ValueNode)this.leftOperand.accept(visitor);
        }
        if (this.rightOperand != null) {
            this.rightOperand = (ValueNode)this.rightOperand.accept(visitor);
        }
    }

    private ValueNode trimBind() throws StandardException {
        TypeId typeId;
        TypeId typeId2 = TypeId.getBuiltInTypeId(12);
        if (this.receiver.requiresTypeFromContext()) {
            this.receiver.setType(this.getVarcharDescriptor());
            if (!this.leftOperand.requiresTypeFromContext()) {
                this.receiver.setCollationInfo(this.leftOperand.getTypeServices());
            } else {
                this.receiver.setCollationUsingCompilationSchema();
            }
        }
        if (this.leftOperand.requiresTypeFromContext()) {
            this.leftOperand.setType(this.getVarcharDescriptor());
            this.leftOperand.setCollationInfo(this.receiver.getTypeServices());
        }
        this.bindToBuiltIn();
        TypeId typeId3 = this.receiver.getTypeId();
        if (typeId3.userType()) {
            this.throwBadType("trim", typeId3.getSQLTypeName());
        }
        this.receiver = this.castArgToString(this.receiver);
        if (typeId3.getTypeFormatId() == 444) {
            typeId2 = typeId3;
        }
        if ((typeId = this.leftOperand.getTypeId()).userType()) {
            this.throwBadType("trim", typeId.getSQLTypeName());
        }
        this.leftOperand = this.castArgToString(this.leftOperand);
        this.setResultType(typeId2);
        this.setCollationInfo(this.receiver.getTypeServices());
        return this;
    }

    private void setResultType(TypeId typeId) throws StandardException {
        this.setType(new DataTypeDescriptor(typeId, true, this.receiver.getTypeServices().getMaximumWidth()));
    }

    ValueNode locateBind() throws StandardException {
        if (this.receiver.requiresTypeFromContext()) {
            if (this.leftOperand.requiresTypeFromContext()) {
                this.receiver.setType(this.getVarcharDescriptor());
                this.receiver.setCollationUsingCompilationSchema();
            } else if (this.leftOperand.getTypeId().isStringTypeId()) {
                this.receiver.setType(this.leftOperand.getTypeServices());
            }
        }
        if (this.leftOperand.requiresTypeFromContext()) {
            if (this.receiver.requiresTypeFromContext()) {
                this.leftOperand.setType(this.getVarcharDescriptor());
            } else if (this.receiver.getTypeId().isStringTypeId()) {
                this.leftOperand.setType(this.receiver.getTypeServices());
            }
            this.leftOperand.setCollationInfo(this.receiver.getTypeServices());
        }
        if (this.rightOperand.requiresTypeFromContext()) {
            this.rightOperand.setType(new DataTypeDescriptor(TypeId.INTEGER_ID, true));
        }
        this.bindToBuiltIn();
        TypeId typeId = this.leftOperand.getTypeId();
        TypeId typeId2 = this.rightOperand.getTypeId();
        TypeId typeId3 = this.receiver.getTypeId();
        if (!typeId3.isStringTypeId() || !typeId.isStringTypeId() || typeId2.getJDBCTypeId() != 4) {
            throw StandardException.newException("42884", "LOCATE", "FUNCTION");
        }
        this.setType(new DataTypeDescriptor(TypeId.INTEGER_ID, this.receiver.getTypeServices().isNullable()));
        return this;
    }

    protected ValueNode castArgToString(ValueNode valueNode) throws StandardException {
        TypeCompiler typeCompiler = valueNode.getTypeCompiler();
        if (!valueNode.getTypeId().isStringTypeId()) {
            DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, true, typeCompiler.getCastToCharWidth(valueNode.getTypeServices()));
            CastNode castNode = new CastNode(valueNode, dataTypeDescriptor, this.getContextManager());
            castNode.setCollationUsingCompilationSchema();
            castNode.bindCastNodeOnly();
            return castNode;
        }
        return valueNode;
    }

    ValueNode substrBind() throws StandardException {
        TypeId typeId = TypeId.getBuiltInTypeId(12);
        if (this.receiver.requiresTypeFromContext()) {
            this.receiver.setType(this.getVarcharDescriptor());
            this.receiver.setCollationUsingCompilationSchema();
        }
        if (this.leftOperand.requiresTypeFromContext()) {
            this.leftOperand.setType(new DataTypeDescriptor(TypeId.INTEGER_ID, true));
        }
        if (this.rightOperand != null && this.rightOperand.requiresTypeFromContext()) {
            this.rightOperand.setType(new DataTypeDescriptor(TypeId.INTEGER_ID, true));
        }
        this.bindToBuiltIn();
        if (!this.leftOperand.getTypeId().isNumericTypeId() || this.rightOperand != null && !this.rightOperand.getTypeId().isNumericTypeId()) {
            throw StandardException.newException("42884", "SUBSTR", "FUNCTION");
        }
        TypeId typeId2 = this.receiver.getTypeId();
        switch (typeId2.getJDBCTypeId()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                break;
            }
            default: {
                this.throwBadType("SUBSTR", typeId2.getSQLTypeName());
            }
        }
        if (typeId2.getTypeFormatId() == 444) {
            typeId = typeId2;
        }
        int n = this.receiver.getTypeServices().getMaximumWidth();
        if (this.rightOperand != null && this.rightOperand instanceof ConstantNode && ((ConstantNode)this.rightOperand).getValue().getInt() < n) {
            n = ((ConstantNode)this.rightOperand).getValue().getInt();
        }
        this.setType(new DataTypeDescriptor(typeId, true, n));
        this.setCollationInfo(this.receiver.getTypeServices());
        return this;
    }

    private ValueNode timestampAddBind() throws StandardException {
        int n;
        if (!this.bindParameter(this.rightOperand, 4) && (n = this.rightOperand.getTypeId().getJDBCTypeId()) != -6 && n != 5 && n != 4 && n != -5) {
            throw StandardException.newException("42X45", this.rightOperand.getTypeId().getSQLTypeName(), ReuseFactory.getInteger(2), this.operator);
        }
        this.bindDateTimeArg(this.receiver, 3);
        this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(93));
        return this;
    }

    private ValueNode timestampDiffBind() throws StandardException {
        this.bindDateTimeArg(this.rightOperand, 2);
        this.bindDateTimeArg(this.receiver, 3);
        this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5));
        return this;
    }

    private void bindDateTimeArg(ValueNode valueNode, int n) throws StandardException {
        if (!this.bindParameter(valueNode, 93) && !valueNode.getTypeId().isDateTimeTimeStampTypeId()) {
            throw StandardException.newException("42X45", valueNode.getTypeId().getSQLTypeName(), ReuseFactory.getInteger(n), this.operator);
        }
    }

    private boolean bindParameter(ValueNode valueNode, int n) throws StandardException {
        if (valueNode.requiresTypeFromContext() && valueNode.getTypeId() == null) {
            valueNode.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(n), true));
            return true;
        }
        return false;
    }

    ValueNode getReceiver() {
        return this.receiver;
    }

    private void throwBadType(String string, String string2) throws StandardException {
        throw StandardException.newException("42X25", string, string2);
    }

    protected void bindToBuiltIn() throws StandardException {
        if (this.receiver.getTypeId().userType()) {
            this.receiver = this.receiver.genSQLJavaSQLTree();
        }
        if (this.leftOperand.getTypeId().userType()) {
            this.leftOperand = this.leftOperand.genSQLJavaSQLTree();
        }
        if (this.rightOperand != null && this.rightOperand.getTypeId().userType()) {
            this.rightOperand = this.rightOperand.genSQLJavaSQLTree();
        }
    }

    private DataTypeDescriptor getVarcharDescriptor() {
        return new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), true);
    }

    @Override
    boolean isSameNodeKind(ValueNode valueNode) {
        return super.isSameNodeKind(valueNode) && ((TernaryOperatorNode)valueNode).kind == this.kind;
    }

    @Override
    boolean isEquivalent(ValueNode valueNode) throws StandardException {
        if (this.isSameNodeKind(valueNode)) {
            TernaryOperatorNode ternaryOperatorNode = (TernaryOperatorNode)valueNode;
            return ternaryOperatorNode.methodName.equals(this.methodName) && ternaryOperatorNode.receiver.isEquivalent(this.receiver) && ternaryOperatorNode.leftOperand.isEquivalent(this.leftOperand) && (this.rightOperand == null && ternaryOperatorNode.rightOperand == null || ternaryOperatorNode.rightOperand != null && ternaryOperatorNode.rightOperand.isEquivalent(this.rightOperand));
        }
        return false;
    }
}

