/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.dialog;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.dialogs.provider.FilterHandleProvider;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class FilterListDialog
extends BaseDialog
implements Listener {
    private Button btnAdd;
    private Button btnEdit;
    private Button btnDel;
    private Table table;
    private TableViewer tableViewer;
    private FilterHandleProvider provider;
    private int selectIndex;
    private List inputList = new ArrayList();
    private ReportElementHandle input;

    public FilterListDialog(FilterHandleProvider provider) {
        super(Messages.getString("FilterListDialog.Shell.Title"));
        this.provider = provider;
    }

    public void setInput(ReportElementHandle input) {
        this.input = input;
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.CubeBuilderFilterListDialog_ID");
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite content = new Composite(dialogArea, 0);
        content.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        content.setLayout((Layout)layout);
        this.createFilterArea(content);
        ArrayList<ReportElementHandle> inputs = new ArrayList<ReportElementHandle>();
        inputs.add(this.input);
        if (inputs.size() != 1) {
            this.enableUI(false);
            return null;
        }
        this.enableUI(true);
        this.editableUI(this.provider.isEditable());
        this.inputList = inputs;
        this.tableViewer.setInput(inputs);
        this.refresh();
        this.updateBtnStatus();
        this.updateBindingParameters();
        return dialogArea;
    }

    private void createFilterArea(final Composite comp) {
        this.table = new Table(comp, 68356);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        String[] columnNames = this.provider.getColumnNames();
        int i = 0;
        while (i < columnNames.length) {
            TableColumn column = new TableColumn(this.table, 16384);
            column.setText(columnNames[i]);
            column.setWidth(100);
            ++i;
        }
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (!FilterListDialog.this.provider.isEditable()) {
                    return;
                }
                if (e.keyCode == 127) {
                    int itemCount = FilterListDialog.this.table.getItemCount();
                    int pos = FilterListDialog.this.table.getSelectionIndex();
                    if (FilterListDialog.this.selectIndex == itemCount - 1) {
                        --FilterListDialog.this.selectIndex;
                    }
                    try {
                        FilterListDialog.this.provider.doDeleteItem(pos);
                    }
                    catch (Exception e1) {
                        WidgetUtil.processError((Shell)comp.getShell(), (Exception)e1);
                    }
                } else if (e.character == '\r') {
                    FilterListDialog.this.edit();
                }
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterListDialog.this.selectIndex = FilterListDialog.this.table.getSelectionIndex();
                FilterListDialog.this.updateBtnStatus();
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (!FilterListDialog.this.provider.isEditable()) {
                    return;
                }
                FilterListDialog.this.edit();
            }
        });
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(this.provider.getColumnNames());
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.btnAdd = new Button(comp, 8);
        this.btnAdd.setText(Messages.getString("FilterListDialog.Button.AddWithDialog"));
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
                stack.startTrans(Messages.getString("FilterListDialog.Menu.ModifyProperty"));
                int pos = FilterListDialog.this.table.getSelectionIndex();
                boolean sucess = false;
                try {
                    sucess = FilterListDialog.this.provider.doAddItem(pos);
                }
                catch (Exception e1) {
                    stack.rollback();
                    WidgetUtil.processError((Shell)comp.getShell(), (Exception)e1);
                    return;
                }
                if (sucess) {
                    stack.commit();
                } else {
                    stack.rollback();
                }
                FilterListDialog.this.table.setSelection(FilterListDialog.this.table.getItemCount() - 1);
                FilterListDialog.this.updateBtnStatus();
            }
        });
        this.btnEdit = new Button(comp, 8);
        this.btnEdit.setText(Messages.getString("FilterListDialog.Button.EditWithDialog"));
        this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterListDialog.this.edit();
            }
        });
        this.btnDel = new Button(comp, 8);
        this.btnDel.setText(Messages.getString("FilterListDialog.Button.Delete"));
        this.btnDel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int pos;
                if (FilterListDialog.this.tableViewer.isCellEditorActive()) {
                    FilterListDialog.this.tableViewer.cancelEditing();
                }
                if ((pos = FilterListDialog.this.table.getSelectionIndex()) == -1) {
                    FilterListDialog.this.table.setFocus();
                    return;
                }
                FilterListDialog.this.selectIndex = pos;
                int itemCount = FilterListDialog.this.table.getItemCount();
                if (FilterListDialog.this.selectIndex == itemCount - 1) {
                    --FilterListDialog.this.selectIndex;
                }
                try {
                    FilterListDialog.this.provider.doDeleteItem(pos);
                }
                catch (Exception e1) {
                    WidgetUtil.processError((Shell)comp.getShell(), (Exception)e1);
                }
                FilterListDialog.this.updateBtnStatus();
            }
        });
        this.setLayout(comp);
    }

    protected void setLayout(Composite comp) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = 8;
        layout.verticalSpacing = 8;
        comp.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.verticalSpan = 5;
        data.minimumWidth = 430;
        data.minimumHeight = 200;
        this.table.setLayoutData((Object)data);
        this.setButtonLayoutData(this.btnAdd);
        this.setButtonLayoutData(this.btnEdit);
        this.setButtonLayoutData(this.btnDel);
    }

    private void enableUI(boolean enabled) {
        if (this.tableViewer != null) {
            this.table.setEnabled(enabled);
            this.btnAdd.setEnabled(enabled);
            this.btnEdit.setEnabled(enabled);
            this.btnDel.setEnabled(enabled);
            if (enabled) {
                this.updateBtnStatus();
            }
        }
    }

    private void editableUI(boolean editable) {
        if (this.tableViewer != null) {
            this.btnAdd.setEnabled(editable);
            this.btnDel.setEnabled(editable);
            this.btnEdit.setEnabled(editable);
            if (editable) {
                this.updateBtnStatus();
            }
        }
    }

    private void edit() {
        int pos = this.table.getSelectionIndex();
        if (pos == -1) {
            this.table.setFocus();
            return;
        }
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans(Messages.getString("FilterListDialog.Menu.ModifyProperty"));
        if (!this.provider.doEditItem(pos)) {
            stack.rollback();
            return;
        }
        stack.commit();
        this.table.setSelection(pos);
    }

    protected void refresh() {
        if (this.tableViewer.getTable().isDisposed()) {
            return;
        }
        this.tableViewer.refresh();
        this.table.select(this.selectIndex);
        this.table.setFocus();
        this.updateBtnStatus();
        this.updateBindingParameters();
        this.editableUI(this.provider.isEditable());
    }

    private void updateBtnStatus() {
        if (!this.provider.isEditable()) {
            return;
        }
        int selectIndex = this.table.getSelectionIndex();
        int min = 0;
        int max = this.table.getItemCount() - 1;
        if (min <= selectIndex && selectIndex <= max) {
            this.btnDel.setEnabled(true);
            if (this.btnEdit != null) {
                this.btnEdit.setEnabled(true);
            }
        } else {
            this.btnDel.setEnabled(false);
            if (this.btnEdit != null) {
                this.btnEdit.setEnabled(false);
            }
        }
    }

    private void updateBindingParameters() {
        ParamBindingHandle[] bindingParams = null;
        if (this.inputList.get(0) instanceof ReportItemHandle) {
            ReportItemHandle inputHandle = (ReportItemHandle)this.inputList.get(0);
            ArrayList<ParamBindingHandle> list = new ArrayList<ParamBindingHandle>();
            Iterator iterator = inputHandle.paramBindingsIterator();
            while (iterator.hasNext()) {
                ParamBindingHandle handle = (ParamBindingHandle)iterator.next();
                list.add(handle);
            }
            bindingParams = new ParamBindingHandle[list.size()];
            list.toArray(bindingParams);
        }
        this.provider.setBindingParams(bindingParams);
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent event) {
        if (this.provider.needRefreshed(event)) {
            this.refresh();
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = FilterListDialog.this.provider.getElements(inputElement);
            Object model = DEUtil.getInputFirstElement((Object)FilterListDialog.this.input);
            if (model instanceof ReportElementHandle) {
                ReportElementHandle element = (ReportElementHandle)model;
                element.addListener((Listener)FilterListDialog.this);
            }
            return elements;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return FilterListDialog.this.provider.getImage(element, columnIndex);
        }

        public String getColumnText(Object element, int columnIndex) {
            return FilterListDialog.this.provider.getColumnText(element, columnIndex);
        }
    }
}

