/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.function.general;

import com.ibm.icu.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.function.i18n.Messages;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionContext;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionExecutor;

public class DateTimeSpan {
    private static final String YEARS = "years";
    private static final String ADDDATE = "addDate";
    private static final String ADDTIME = "addTime";
    private static final String DAYS = "days";
    private static final String HOURS = "hours";
    private static final String MINUTES = "minutes";
    private static final String MONTHS = "months";
    private static final String SECONDS = "seconds";
    private static final String SUBDATE = "subDate";
    private static final String SUBTIME = "subTime";
    protected static Logger logger = Logger.getLogger(DateTimeSpan.class.getName());

    private DateTimeSpan() {
    }

    static int years(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return 0;
        }
        if (!DateTimeSpan.validateDateArgus(startDate, endDate)) {
            return -DateTimeSpan.years(endDate, startDate);
        }
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDate);
        int startYear = startCal.get(1) - 1900;
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endDate);
        int endYear = endCal.get(1) - 1900;
        assert (endYear >= startYear);
        int spanYear = endYear - startYear;
        startCal.add(1, spanYear);
        startDate = startCal.getTime();
        endDate = endCal.getTime();
        if (startDate.compareTo(endDate) > 0) {
            --spanYear;
        }
        return spanYear;
    }

    static int months(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return 0;
        }
        if (!DateTimeSpan.validateDateArgus(startDate, endDate)) {
            return -DateTimeSpan.months(endDate, startDate);
        }
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDate);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endDate);
        int startMonth = startCal.get(1) * 12 + startCal.get(2);
        int endMonth = endCal.get(1) * 12 + endCal.get(2);
        int spanMonth = endMonth - startMonth;
        startCal.add(2, spanMonth);
        if (startCal.getTime().compareTo(endCal.getTime()) > 0) {
            --spanMonth;
        }
        return spanMonth;
    }

    static int days(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return 0;
        }
        if (!DateTimeSpan.validateDateArgus(startDate, endDate)) {
            return -DateTimeSpan.days(endDate, startDate);
        }
        long diff = endDate.getTime() - startDate.getTime();
        return (int)(diff / 86400000L);
    }

    static int hours(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return 0;
        }
        if (!DateTimeSpan.validateDateArgus(startDate, endDate)) {
            return -DateTimeSpan.hours(endDate, startDate);
        }
        long diff = endDate.getTime() - startDate.getTime();
        return (int)(diff / 3600000L);
    }

    static int minutes(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return 0;
        }
        if (!DateTimeSpan.validateDateArgus(startDate, endDate)) {
            return -DateTimeSpan.minutes(endDate, startDate);
        }
        long diff = endDate.getTime() - startDate.getTime();
        return (int)(diff / 60000L);
    }

    static int seconds(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return 0;
        }
        if (!DateTimeSpan.validateDateArgus(startDate, endDate)) {
            return -DateTimeSpan.seconds(endDate, startDate);
        }
        long diff = endDate.getTime() - startDate.getTime();
        return (int)(diff / 1000L);
    }

    static Date addDate(Date startDate, int years, int months, int days) {
        Calendar startCal = Calendar.getInstance();
        Date firstDate = startDate;
        startCal.setTime(firstDate);
        startCal.add(1, years);
        startCal.add(2, months);
        startCal.add(5, days);
        return startCal.getTime();
    }

    static Date addTime(Date startDate, int hours, int minutes, int seconds) {
        Calendar startCal = Calendar.getInstance();
        Date firstDate = startDate;
        startCal.setTime(firstDate);
        startCal.add(11, hours);
        startCal.add(12, minutes);
        startCal.add(13, seconds);
        return startCal.getTime();
    }

    static Date subDate(Date startDate, int years, int months, int days) {
        Calendar startCal = Calendar.getInstance();
        Date firstDate = startDate;
        startCal.setTime(firstDate);
        return DateTimeSpan.addDate(startDate, -years, -months, -days);
    }

    static Date subTime(Date startDate, int hours, int minutes, int seconds) {
        return DateTimeSpan.addTime(startDate, -hours, -minutes, -seconds);
    }

    private static boolean validateDateArgus(Date start, Date end) {
        return start.compareTo(end) <= 0;
    }

    static IScriptFunctionExecutor getExecutor(String functionName) throws BirtException {
        if (YEARS.equals(functionName)) {
            return new YearsScriptFunctionExecutor();
        }
        if (ADDDATE.equals(functionName)) {
            return new AddDateScriptFunctionExecutor();
        }
        if (ADDTIME.equals(functionName)) {
            return new AddTimeScriptFunctionExecutor();
        }
        if (DAYS.equals(functionName)) {
            return new DaysScriptFunctionExecutor();
        }
        if (HOURS.equals(functionName)) {
            return new HoursScriptFunctionExecutor();
        }
        if (MINUTES.equals(functionName)) {
            return new MinutesScriptFunctionExecutor();
        }
        if (SECONDS.equals(functionName)) {
            return new SecondsScriptFunctionExecutor();
        }
        if (SUBDATE.equals(functionName)) {
            return new SubDateScriptFunctionExecutor();
        }
        if (SUBTIME.equals(functionName)) {
            return new SubTimeScriptFunctionExecutor();
        }
        if (MONTHS.equals(functionName)) {
            return new MonthsScriptFunctionExecutor();
        }
        throw new BirtException("org.eclipse.birt.core.script.function.general", null, (Object)(String.valueOf(Messages.getString("invalid.function.name")) + "DateTimeSpan." + functionName));
    }

    private static class AddDateScriptFunctionExecutor
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;

        private AddDateScriptFunctionExecutor() {
        }

        public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
            if (arguments == null || arguments.length != 4) {
                throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.number.of.argument")) + "DateTimeSpan.addDate()"));
            }
            return DateTimeSpan.addDate(DataTypeUtil.toDate((Object)arguments[0]), DataTypeUtil.toInteger((Object)arguments[1]), DataTypeUtil.toInteger((Object)arguments[2]), DataTypeUtil.toInteger((Object)arguments[3]));
        }
    }

    private static class AddTimeScriptFunctionExecutor
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;

        private AddTimeScriptFunctionExecutor() {
        }

        public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
            if (arguments == null || arguments.length != 4) {
                throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.number.of.argument")) + "DateTimeSpan.addTime()"));
            }
            return DateTimeSpan.addTime(DataTypeUtil.toDate((Object)arguments[0]), DataTypeUtil.toInteger((Object)arguments[1]), DataTypeUtil.toInteger((Object)arguments[2]), DataTypeUtil.toInteger((Object)arguments[3]));
        }
    }

    private static class DaysScriptFunctionExecutor
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;

        private DaysScriptFunctionExecutor() {
        }

        public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
            if (arguments == null || arguments.length != 2) {
                throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.number.of.argument")) + "DateTimeSpan.days()"));
            }
            return DateTimeSpan.days(DataTypeUtil.toDate((Object)arguments[0]), DataTypeUtil.toDate((Object)arguments[1]));
        }
    }

    private static class HoursScriptFunctionExecutor
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;

        private HoursScriptFunctionExecutor() {
        }

        public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
            if (arguments == null || arguments.length != 2) {
                throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.number.of.argument")) + "DateTimeSpan.hours()"));
            }
            return DateTimeSpan.hours(DataTypeUtil.toDate((Object)arguments[0]), DataTypeUtil.toDate((Object)arguments[1]));
        }
    }

    private static class MinutesScriptFunctionExecutor
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;

        private MinutesScriptFunctionExecutor() {
        }

        public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
            if (arguments == null || arguments.length != 2) {
                throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.number.of.argument")) + "DateTimeSpan.minutes()"));
            }
            return DateTimeSpan.minutes(DataTypeUtil.toDate((Object)arguments[0]), DataTypeUtil.toDate((Object)arguments[1]));
        }
    }

    private static class MonthsScriptFunctionExecutor
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;

        private MonthsScriptFunctionExecutor() {
        }

        public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
            if (arguments == null || arguments.length != 2) {
                throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.number.of.argument")) + "DateTimeSpan.months()"));
            }
            return DateTimeSpan.months(DataTypeUtil.toDate((Object)arguments[0]), DataTypeUtil.toDate((Object)arguments[1]));
        }
    }

    private static class SecondsScriptFunctionExecutor
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;

        private SecondsScriptFunctionExecutor() {
        }

        public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
            if (arguments == null || arguments.length != 2) {
                throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.number.of.argument")) + "DateTimeSpan.seconds()"));
            }
            return DateTimeSpan.seconds(DataTypeUtil.toDate((Object)arguments[0]), DataTypeUtil.toDate((Object)arguments[1]));
        }
    }

    private static class SubDateScriptFunctionExecutor
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;

        private SubDateScriptFunctionExecutor() {
        }

        public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
            if (arguments == null || arguments.length != 4) {
                throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.number.of.argument")) + "DateTimeSpan.subDate()"));
            }
            return DateTimeSpan.subDate(DataTypeUtil.toDate((Object)arguments[0]), DataTypeUtil.toInteger((Object)arguments[1]), DataTypeUtil.toInteger((Object)arguments[2]), DataTypeUtil.toInteger((Object)arguments[3]));
        }
    }

    private static class SubTimeScriptFunctionExecutor
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;

        private SubTimeScriptFunctionExecutor() {
        }

        public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
            if (arguments == null || arguments.length != 4) {
                throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.number.of.argument")) + "DateTimeSpan.subTime()"));
            }
            return DateTimeSpan.subTime(DataTypeUtil.toDate((Object)arguments[0]), DataTypeUtil.toInteger((Object)arguments[1]), DataTypeUtil.toInteger((Object)arguments[2]), DataTypeUtil.toInteger((Object)arguments[3]));
        }
    }

    private static class YearsScriptFunctionExecutor
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;

        private YearsScriptFunctionExecutor() {
        }

        public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
            if (arguments == null || arguments.length != 2) {
                throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.number.of.argument")) + "DateTimeSpan.year()"));
            }
            return DateTimeSpan.years(DataTypeUtil.toDate((Object)arguments[0]), DataTypeUtil.toDate((Object)arguments[1]));
        }
    }
}

