/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.ui.impl.contols;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.oda.pojo.ui.i18n.Messages;
import org.eclipse.birt.data.oda.pojo.ui.impl.contols.ClassSelectionButton;
import org.eclipse.birt.data.oda.pojo.ui.impl.contols.IMenuButtonHelper;
import org.eclipse.birt.data.oda.pojo.ui.impl.contols.IMenuButtonProvider;
import org.eclipse.birt.data.oda.pojo.ui.impl.models.ClassPathElement;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Listener;

public class MenuButtonHelper
implements IMenuButtonHelper {
    private TableViewer viewer;
    private ClassSelectionButton button;
    private IMenuButtonProvider provider;
    private List<ClassPathElement> elements;

    public MenuButtonHelper(TableViewer viewer) {
        this.viewer = viewer;
        this.updateTableElementsList();
    }

    public void clearTableElementsList() {
        if (this.elements == null) {
            this.elements = new ArrayList<ClassPathElement>();
        } else {
            this.elements.clear();
        }
    }

    public void updateTableElementsList() {
        this.elements = (List)this.viewer.getInput();
        if (this.elements == null) {
            this.elements = new ArrayList<ClassPathElement>();
        }
    }

    public int getElementCount() {
        return this.elements == null ? 0 : this.elements.size();
    }

    @Override
    public void addClassPathElements(ClassPathElement[] items, boolean current) {
        boolean containsDuplicated = false;
        int i = 0;
        while (i < items.length) {
            boolean exists = false;
            int j = 0;
            while (j < this.elements.size()) {
                if (this.elements.get(j).isRelativePath() == items[i].isRelativePath() && this.elements.get(j).getFullPath() != null && this.elements.get(j).getFullPath().equals(items[i].getFullPath())) {
                    exists = true;
                    break;
                }
                ++j;
            }
            if (!exists) {
                this.elements.add(items[i]);
            } else {
                containsDuplicated = true;
            }
            ++i;
        }
        this.viewer.setInput(this.elements);
        this.viewer.refresh();
        if (containsDuplicated && current) {
            ExceptionHandler.openMessageBox((String)Messages.getString("ExceptionDialog.title.erro"), (String)Messages.getString("ExceptionDialog.DataSource.AddDuplicatedJar"), (int)1);
        }
    }

    @Override
    public void setProvider(IMenuButtonProvider provider) {
        this.provider = provider;
    }

    public IMenuButtonProvider getProvider() {
        return this.provider;
    }

    @Override
    public void setMenuButton(ClassSelectionButton button) {
        this.button = button;
    }

    @Override
    public Object getPropertyValue(String key) {
        return this.button.getControl().getData(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.button.getControl().setData(key, value);
    }

    @Override
    public void setListener(Listener listener) {
    }

    @Override
    public void notifyExpressionChangeEvent(String oldExpression, String newExpression) {
    }
}

