/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.aggregation.calculator.CalculatorFactory;
import org.eclipse.birt.data.aggregation.calculator.ICalculator;
import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrException;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.SummaryAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalWeightedAve
extends AggrFunction {
    public String getName() {
        return "WEIGHTEDAVE";
    }

    public int getType() {
        return 0;
    }

    public int getDataType() {
        return 3;
    }

    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.CALCULATABLE, ""), new ParameterDefn("weight", Messages.getString("TotalWeightedAve.param.weight"), false, true, SupportedDataTypes.CALCULATABLE, "")};
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator(CalculatorFactory.getCalculator(this.getDataType()));
    }

    public String getDescription() {
        return Messages.getString("TotalWeightedAve.description");
    }

    public String getDisplayName() {
        return Messages.getString("TotalWeightedAve.displayName");
    }

    private static class MyAccumulator
    extends SummaryAccumulator {
        private Number wsum = null;
        private Number weightsum = null;

        MyAccumulator(ICalculator calc) {
            super(calc);
        }

        @Override
        public void start() {
            super.start();
            this.wsum = null;
            this.weightsum = null;
        }

        public void onRow(Object[] args) throws DataException {
            assert (args.length > 1);
            if (args[0] != null && args[1] != null) {
                this.wsum = this.calculator.add(this.wsum, this.calculator.multiply(this.calculator.getTypedObject(args[0]), this.calculator.getTypedObject(args[1])));
                this.weightsum = this.calculator.add(this.weightsum, this.calculator.getTypedObject(args[1]));
            }
        }

        @Override
        public Object getSummaryValue() throws DataException {
            if (this.weightsum == null) {
                return null;
            }
            try {
                return this.calculator.divide(this.wsum, this.weightsum);
            }
            catch (BirtException e) {
                throw DataException.wrap((BirtException)new AggrException("aggregation.DataConversionError", e));
            }
        }
    }
}

