/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.javascript;

import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.IScriptEngine;
import org.eclipse.birt.core.script.IScriptEngineFactory;
import org.eclipse.birt.report.engine.javascript.JavascriptEngine;
import org.eclipse.birt.report.engine.javascript.ScriptUtil;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;

public class JavascriptEngineFactory
implements IScriptEngineFactory {
    public static String SCRIPT_JAVASCRIPT = "javascript";
    public static final boolean USE_DYNAMIC_SCOPE = true;
    private static Logger logger = Logger.getLogger(JavascriptEngineFactory.class.getName());
    private LinkedList<ScriptableObject> rootScopes = new LinkedList();

    public static void initMyFactory() {
        ContextFactory.initGlobal((ContextFactory)new MyFactory());
        if (System.getSecurityManager() != null) {
            SecurityController.initGlobal((SecurityController)ScriptUtil.createSecurityController());
        }
    }

    protected ScriptableObject createRootScope() throws BirtException {
        Context context = Context.enter();
        try {
            ScriptableObject rootScope = context.initStandardObjects();
            context.evaluateString((Scriptable)rootScope, "function registerGlobal( name, value) { _jsContext.registerGlobalBean(name, value); }", "<inline>", 0, null);
            context.evaluateString((Scriptable)rootScope, "function unregisterGlobal(name) { _jsContext.unregisterGlobalBean(name); }", "<inline>", 0, null);
            ScriptableObject scriptableObject = rootScope;
            return scriptableObject;
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error occurs while initialze script scope", ex);
            return null;
        }
        finally {
            Context.exit();
        }
    }

    protected synchronized ScriptableObject getRootScope() throws BirtException {
        if (!this.rootScopes.isEmpty()) {
            return this.rootScopes.remove();
        }
        return this.createRootScope();
    }

    protected synchronized void releaseRootScope(ScriptableObject rootScope) {
        if (rootScope != null) {
            ClassCache classCache = ClassCache.get((Scriptable)rootScope);
            if (classCache != null) {
                classCache.clearCaches();
            }
            this.rootScopes.add(rootScope);
        }
    }

    public IScriptEngine createScriptEngine() throws BirtException {
        ScriptableObject rootScope = this.getRootScope();
        return new JavascriptEngine(this, rootScope);
    }

    public String getScriptLanguage() {
        return SCRIPT_JAVASCRIPT;
    }

    public static void destroyMyFactory() {
        ContextFactory factory = ContextFactory.getGlobal();
        if (factory instanceof MyFactory) {
            try {
                Class<?> factoryClass = Class.forName("org.mozilla.javascript.ContextFactory");
                Field field = factoryClass.getDeclaredField("hasCustomGlobal");
                field.setAccessible(true);
                field.setBoolean(factoryClass, false);
                field = factoryClass.getDeclaredField("global");
                field.setAccessible(true);
                field.set(factoryClass, new ContextFactory());
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    static class MyFactory
    extends ContextFactory {
        MyFactory() {
        }

        protected boolean hasFeature(Context cx, int featureIndex) {
            if (featureIndex == 7) {
                return true;
            }
            return super.hasFeature(cx, featureIndex);
        }
    }
}

