/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.HTMLWriter;
import org.eclipse.birt.report.engine.emitter.html.AttributeBuilder;
import org.eclipse.birt.report.engine.emitter.html.HTMLEmitter;
import org.eclipse.birt.report.engine.emitter.html.HTMLReportEmitter;
import org.eclipse.birt.report.engine.emitter.html.util.HTMLEmitterUtil;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.w3c.dom.css.CSSValue;

public class HTMLPerformanceOptimize
extends HTMLEmitter {
    public HTMLPerformanceOptimize(HTMLReportEmitter reportEmitter, HTMLWriter writer, boolean fixedReport, boolean enableInlineStyle, int browserVersion) {
        super(reportEmitter, writer, fixedReport, enableInlineStyle, browserVersion);
    }

    @Override
    public void buildDefaultStyle(StringBuffer styleBuffer, IStyle style) {
        if (style == null || style.isEmpty()) {
            return;
        }
        AttributeBuilder.buildFont(styleBuffer, style);
        AttributeBuilder.buildText(styleBuffer, style);
        AttributeBuilder.buildVisual(styleBuffer, style);
        AttributeBuilder.buildTextDecoration(styleBuffer, style);
        AttributeBuilder.buildBidiDirection(styleBuffer, style);
        String value = style.getTextAlign();
        if (value != null) {
            styleBuffer.append(" text-align:");
            styleBuffer.append(value);
            styleBuffer.append(";");
        }
    }

    @Override
    public void buildStyle(StringBuffer styleBuffer, IStyle style) {
        if (style == null || style.isEmpty()) {
            return;
        }
        AttributeBuilder.buildFont(styleBuffer, style);
        AttributeBuilder.buildBox(styleBuffer, style);
        AttributeBuilder.buildBackground(styleBuffer, style, this.reportEmitter);
        AttributeBuilder.buildText(styleBuffer, style);
        AttributeBuilder.buildVisual(styleBuffer, style);
        AttributeBuilder.buildTextDecoration(styleBuffer, style);
        AttributeBuilder.buildSize(styleBuffer, style);
    }

    @Override
    public void buildPageBandStyle(StringBuffer styleBuffer, IStyle style) {
        if (style == null || style.isEmpty()) {
            return;
        }
        AttributeBuilder.buildFont(styleBuffer, style);
        AttributeBuilder.buildText(styleBuffer, style);
        AttributeBuilder.buildVisual(styleBuffer, style);
        AttributeBuilder.buildTextDecoration(styleBuffer, style);
        String value = style.getVerticalAlign();
        if (value != null) {
            styleBuffer.append(" vertical-align:");
            styleBuffer.append(value);
            styleBuffer.append(";");
        }
        if ((value = style.getTextAlign()) != null) {
            styleBuffer.append(" text-align:");
            styleBuffer.append(value);
            styleBuffer.append(";");
        }
    }

    @Override
    public void buildTableStyle(ITableContent table, StringBuffer styleBuffer) {
        String value;
        this.addDefaultTableStyles(styleBuffer);
        IStyle style = table.getStyle();
        boolean isInline = false;
        CSSValue display = style.getProperty(50);
        if (IStyle.NONE_VALUE == display) {
            styleBuffer.append(" display: none;");
        } else if (IStyle.INLINE_VALUE == display || IStyle.INLINE_BLOCK_VALUE == display) {
            isInline = true;
            if (!this.reportEmitter.browserSupportsInlineBlock) {
                styleBuffer.append(" display:table !important; display:inline;");
            } else {
                styleBuffer.append(" display:inline-block; zoom:1; *+display:inline;");
            }
        }
        DimensionType height = table.getHeight();
        if (height != null) {
            this.buildSize(styleBuffer, "height", height);
        }
        boolean widthOutputFlag = false;
        DimensionType width = table.getWidth();
        if (width != null) {
            this.buildSize(styleBuffer, "width", width);
            widthOutputFlag = true;
        } else if (!"true".equalsIgnoreCase(style.getCanShrink())) {
            boolean absoluteWidth = true;
            int i = 0;
            while (i < table.getColumnCount()) {
                IColumn column = table.getColumn(i);
                DimensionType columnWidth = column.getWidth();
                if (columnWidth == null) {
                    absoluteWidth = false;
                    break;
                }
                if ("%".endsWith(columnWidth.getUnits())) {
                    absoluteWidth = false;
                    break;
                }
                ++i;
            }
            if (!absoluteWidth) {
                styleBuffer.append(" width: 100%;");
                widthOutputFlag = true;
            }
        }
        if (this.fixedReport && !"true".equalsIgnoreCase(style.getCanShrink())) {
            CSSValue overflowValue;
            if (!widthOutputFlag) {
                if (isInline) {
                    styleBuffer.append(" width: auto;");
                } else {
                    styleBuffer.append(" width: 1px;");
                }
            }
            if ((overflowValue = style.getProperty(38)) == null) {
                if (isInline) {
                    styleBuffer.append(" overflow:hidden;");
                }
            } else {
                styleBuffer.append(" overflow:").append(overflowValue.getCssText()).append(";");
            }
            styleBuffer.append(" table-layout:fixed;");
        }
        if ((value = style.getTextAlign()) != null) {
            if (isInline) {
                styleBuffer.append(" text-align:");
                styleBuffer.append("-moz-");
                styleBuffer.append(value);
                styleBuffer.append(" !important;");
            }
            styleBuffer.append("text-align:");
            styleBuffer.append(value);
            styleBuffer.append(";");
        }
        if ((style = this.getElementStyle((IContent)table)) == null) {
            return;
        }
        AttributeBuilder.buildFont(styleBuffer, style);
        AttributeBuilder.buildBox(styleBuffer, style);
        AttributeBuilder.buildBackground(styleBuffer, style, this.reportEmitter);
        AttributeBuilder.buildText(styleBuffer, style);
        AttributeBuilder.buildVisual(styleBuffer, style);
        AttributeBuilder.buildTextDecoration(styleBuffer, style);
    }

    @Override
    public void buildColumnStyle(IColumn column, StringBuffer styleBuffer) {
        String value;
        this.buildSize(styleBuffer, "width", column.getWidth());
        IStyle style = column.getStyle();
        CSSValue display = style.getProperty(50);
        if (IStyle.NONE_VALUE == display) {
            styleBuffer.append(" display:none;");
        }
        if ((value = style.getVerticalAlign()) != null) {
            styleBuffer.append(" vertical-align:");
            styleBuffer.append(value);
            styleBuffer.append(";");
        }
        if ((style = column.getInlineStyle()) == null || style.isEmpty()) {
            return;
        }
        AttributeBuilder.buildFont(styleBuffer, style);
        AttributeBuilder.buildBox(styleBuffer, style);
        AttributeBuilder.buildBackground(styleBuffer, style, this.reportEmitter);
        AttributeBuilder.buildText(styleBuffer, style);
        AttributeBuilder.buildVisual(styleBuffer, style);
        AttributeBuilder.buildTextDecoration(styleBuffer, style);
    }

    @Override
    public void handleColumnAlign(IColumn column) {
    }

    @Override
    public void buildRowStyle(IRowContent row, StringBuffer styleBuffer) {
        this.buildSize(styleBuffer, "height", row.getHeight());
        IStyle style = row.getStyle();
        CSSValue display = style.getProperty(50);
        if (IStyle.NONE_VALUE == display) {
            styleBuffer.append(" display: none;");
        }
        if ((style = this.getElementStyle((IContent)row)) == null) {
            return;
        }
        AttributeBuilder.buildFont(styleBuffer, style);
        AttributeBuilder.buildBox(styleBuffer, style);
        AttributeBuilder.buildBackground(styleBuffer, style, this.reportEmitter);
        AttributeBuilder.buildText(styleBuffer, style);
        AttributeBuilder.buildVisual(styleBuffer, style);
        AttributeBuilder.buildTextDecoration(styleBuffer, style);
    }

    @Override
    public void handleRowAlign(IRowContent row) {
        IStyle style = row.getStyle();
        CSSValue vAlign = style.getProperty(48);
        if (vAlign == null || IStyle.BASELINE_VALUE == vAlign) {
            vAlign = IStyle.TOP_VALUE;
        }
        this.writer.attribute("valign", vAlign.getCssText());
        CSSValue hAlign = style.getProperty(23);
        if (hAlign != null) {
            this.writer.attribute("align", hAlign.getCssText());
        }
    }

    @Override
    public void buildCellStyle(ICellContent cell, StringBuffer styleBuffer, boolean isHead, boolean fixedCellHeight) {
        CSSValue display;
        IStyle style = cell.getStyle();
        if (style == null) {
            return;
        }
        if (this.fixedReport && !fixedCellHeight) {
            HTMLEmitterUtil.buildOverflowStyle(styleBuffer, style, true);
        }
        if (IStyle.NONE_VALUE == (display = style.getProperty(50))) {
            styleBuffer.append(" display: none !important; display: block;");
        }
        if ((style = this.getElementStyle((IContent)cell)) == null) {
            if (fixedCellHeight) {
                styleBuffer.append(" padding: 0px;");
            }
            return;
        }
        AttributeBuilder.buildFont(styleBuffer, style);
        AttributeBuilder.buildMargins(styleBuffer, style);
        if (fixedCellHeight) {
            styleBuffer.append(" padding: 0px;");
        } else {
            AttributeBuilder.buildPaddings(styleBuffer, style);
        }
        AttributeBuilder.buildBorders(styleBuffer, style);
        AttributeBuilder.buildBackground(styleBuffer, style, this.reportEmitter);
        AttributeBuilder.buildText(styleBuffer, style);
        AttributeBuilder.buildVisual(styleBuffer, style);
        AttributeBuilder.buildTextDecoration(styleBuffer, style);
    }

    @Override
    public void handleCellVAlign(ICellContent cell) {
        IStyle style = cell.getStyle();
        CSSValue vAlign = style.getProperty(48);
        if (IStyle.BASELINE_VALUE == vAlign) {
            vAlign = IStyle.TOP_VALUE;
        }
        if (vAlign != null) {
            this.writer.attribute("valign", vAlign.getCssText());
        }
    }

    @Override
    public void buildContainerStyle(IContainerContent container, StringBuffer styleBuffer) {
        int display = (Integer)this.containerDisplayStack.peek();
        this.handleShrink(display, container.getStyle(), container.getHeight(), container.getWidth(), styleBuffer);
        if ((display & 8) > 0) {
            styleBuffer.append("display: none;");
        } else if ((display & 2) > 0 || (display & 4) > 0) {
            styleBuffer.append("display:inline-block; zoom:1; *+display:inline;");
        }
        IStyle style = this.getElementStyle((IContent)container);
        if (style == null) {
            return;
        }
        AttributeBuilder.buildFont(styleBuffer, style);
        AttributeBuilder.buildBox(styleBuffer, style);
        AttributeBuilder.buildBackground(styleBuffer, style, this.reportEmitter);
        AttributeBuilder.buildText(styleBuffer, style);
        AttributeBuilder.buildVisual(styleBuffer, style);
        AttributeBuilder.buildTextDecoration(styleBuffer, style);
    }

    @Override
    public void handleContainerAlign(IContainerContent container) {
        IStyle style = container.getStyle();
        CSSValue hAlign = style.getProperty(23);
        if (hAlign != null) {
            this.writer.attribute("align", hAlign.getCssText());
        }
    }

    @Override
    public void buildTextStyle(ITextContent text, StringBuffer styleBuffer, int display) {
        IStyle style = text.getStyle();
        this.handleTextShrink(display, style, text.getHeight(), text.getWidth(), styleBuffer);
        this.setDisplayProperty(display, 4, styleBuffer);
        AttributeBuilder.buildBidiDirection(styleBuffer, text.getComputedStyle());
        String textAlign = style.getTextAlign();
        if (textAlign != null) {
            styleBuffer.append(" text-align:");
            styleBuffer.append(textAlign);
            styleBuffer.append(";");
        }
        if ((style = this.getElementStyle((IContent)text)) == null) {
            return;
        }
        AttributeBuilder.buildFont(styleBuffer, style);
        AttributeBuilder.buildBox(styleBuffer, style);
        AttributeBuilder.buildBackground(styleBuffer, style, this.reportEmitter);
        AttributeBuilder.buildText(styleBuffer, style);
        AttributeBuilder.buildVisual(styleBuffer, style);
        AttributeBuilder.buildTextDecoration(styleBuffer, style);
    }

    @Override
    public void buildForeignStyle(IForeignContent foreign, StringBuffer styleBuffer, int display) {
        IStyle style = foreign.getStyle();
        this.handleShrink(display, style, foreign.getHeight(), foreign.getWidth(), styleBuffer);
        this.setDisplayProperty(display, 4, styleBuffer);
        AttributeBuilder.buildBidiDirection(styleBuffer, foreign.getComputedStyle());
        String textAlign = style.getTextAlign();
        if (textAlign != null) {
            styleBuffer.append(" text-align:");
            styleBuffer.append(textAlign);
            styleBuffer.append(";");
        }
        if ((style = this.getElementStyle((IContent)foreign)) == null) {
            return;
        }
        AttributeBuilder.buildFont(styleBuffer, style);
        AttributeBuilder.buildBox(styleBuffer, style);
        AttributeBuilder.buildBackground(styleBuffer, style, this.reportEmitter);
        AttributeBuilder.buildText(styleBuffer, style);
        AttributeBuilder.buildVisual(styleBuffer, style);
        AttributeBuilder.buildTextDecoration(styleBuffer, style);
    }

    @Override
    public void buildImageStyle(IImageContent image, StringBuffer styleBuffer, int display) {
        this.buildSize(styleBuffer, "width", image.getWidth());
        this.buildSize(styleBuffer, "height", image.getHeight());
        this.setDisplayProperty(display, 1, styleBuffer);
        IStyle style = image.getStyle();
        String verticalAlign = style.getVerticalAlign();
        if (verticalAlign != null) {
            styleBuffer.append(" vertical-align:");
            styleBuffer.append(verticalAlign);
            styleBuffer.append(";");
        }
        if ((style = this.getElementStyle((IContent)image)) == null) {
            return;
        }
        AttributeBuilder.buildFont(styleBuffer, style);
        AttributeBuilder.buildBox(styleBuffer, style);
        AttributeBuilder.buildBackground(styleBuffer, style, this.reportEmitter);
        AttributeBuilder.buildText(styleBuffer, style);
        AttributeBuilder.buildVisual(styleBuffer, style);
        AttributeBuilder.buildTextDecoration(styleBuffer, style);
    }
}

