/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core.namespace;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.report.model.api.extension.IMessages;
import org.eclipse.birt.report.model.api.extension.IReportItemFactory;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.core.namespace.AbstractModuleNameContext;
import org.eclipse.birt.report.model.core.namespace.AbstractNameHelper;
import org.eclipse.birt.report.model.core.namespace.INameContext;
import org.eclipse.birt.report.model.core.namespace.NameContextFactory;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.olap.Level;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.NamePropertyType;
import org.eclipse.birt.report.model.metadata.PeerExtensionElementDefn;

public class ModuleNameHelper
extends AbstractNameHelper {
    protected Module module = null;
    private HashMap<String, Set<String>> cachedContentNames;
    private Map<String, DesignElement> cachedLevelNames = new HashMap<String, DesignElement>();

    public ModuleNameHelper(Module module) {
        this.module = module;
        this.cachedContentNames = new HashMap();
    }

    @Override
    protected INameContext createNameContext(String id) {
        return NameContextFactory.createModuleNameContext(this.module, id);
    }

    @Override
    public String getUniqueName(String namespaceId, DesignElement element, String namePrefix) {
        if (element == null) {
            return null;
        }
        ElementDefn eDefn = (ElementDefn)element.getDefn();
        String name = element.getName();
        if (StringUtil.isBlank(name)) {
            name = namePrefix;
        }
        name = StringUtil.trimString(name);
        name = NamePropertyType.validateName(name);
        if (eDefn.getNameOption() == 0 || eDefn.getNameOption() == 1 && name == null && this.module instanceof ReportDesign) {
            return null;
        }
        if (this.module instanceof Library && element instanceof StyleElement && element.getContainer() == null && name != null) {
            return name;
        }
        NameSpace nameSpace = this.getCachedNameSpace(namespaceId);
        Set<String> cachedContentNames = this.getCachedContentNames(namespaceId);
        NameSpace moduleNameSpace = this.getNameContext(namespaceId).getNameSpace();
        String validName = name;
        if (element instanceof StyleElement) {
            String string = validName = validName == null ? null : validName.toLowerCase();
        }
        if (validName != null && ModuleNameHelper.isValidInNameSpace(nameSpace, element, validName) && ModuleNameHelper.isValidInNameSpace(moduleNameSpace, element, validName) && !cachedContentNames.contains(validName)) {
            return name;
        }
        if (name == null) {
            if (element instanceof ExtendedItem) {
                ExtensionElementDefn extDefn = ((ExtendedItem)element).getExtDefn();
                PeerExtensionElementDefn peerDefn = (PeerExtensionElementDefn)extDefn;
                IReportItemFactory peerFactory = peerDefn.getReportItemFactory();
                assert (peerFactory != null);
                String extensionDefaultName = null;
                IMessages msgs = peerFactory.getMessages();
                if (msgs != null) {
                    extensionDefaultName = msgs.getMessage((String)extDefn.getDisplayNameKey(), this.module.getLocale());
                }
                if (StringUtil.isBlank(extensionDefaultName)) {
                    extensionDefaultName = peerDefn.getName();
                }
                name = ModelMessages.getMessage("Message.NamePrefixNew");
                name = String.valueOf(name) + extensionDefaultName;
            } else {
                name = ModelMessages.getMessage("New." + element.getDefn().getName());
                name = name.trim();
            }
            name = NamePropertyType.validateName(name);
        }
        int index = 0;
        String baseName = name;
        validName = name;
        if (element instanceof StyleElement) {
            validName = validName == null ? null : validName.toLowerCase();
        }
        while (nameSpace.contains(validName) || moduleNameSpace.contains(validName) || cachedContentNames.contains(validName)) {
            validName = name = String.valueOf(baseName) + ++index;
            if (!(element instanceof StyleElement)) continue;
            String string = validName = validName == null ? null : validName.toLowerCase();
        }
        return name;
    }

    private Set<String> getCachedContentNames(String id) {
        Set<String> cachedNames = this.cachedContentNames.get(id);
        if (cachedNames == null) {
            cachedNames = new HashSet<String>();
            this.cachedContentNames.put(id, cachedNames);
        }
        return cachedNames;
    }

    @Override
    public void addContentName(String id, String name) {
        Set<String> cachedNames = this.getCachedContentNames(id);
        if (!cachedNames.contains(name)) {
            cachedNames.add(name);
        }
    }

    @Override
    public DesignElement getElement() {
        return this.module;
    }

    public boolean addCachedLevel(DesignElement level) {
        if (!(level instanceof Level)) {
            return true;
        }
        String name = level.getName();
        if (name == null) {
            return true;
        }
        if (this.cachedLevelNames.get(name) != null && this.cachedLevelNames.get(name) != level) {
            return false;
        }
        this.cachedLevelNames.put(level.getName(), level);
        return true;
    }

    public Level findCachedLevel(String elementName) {
        if (elementName == null) {
            return null;
        }
        String namespace = StringUtil.extractNamespace(elementName);
        String name = StringUtil.extractName(elementName);
        if (namespace == null) {
            return (Level)this.cachedLevelNames.get(name);
        }
        Library lib = this.module.getLibraryWithNamespace(namespace);
        return lib == null ? null : ((ModuleNameHelper)lib.getNameHelper()).findCachedLevel(name);
    }

    public void clearCachedLevels() {
        this.cachedLevelNames = null;
        List<Library> libs = this.module.getAllLibraries();
        if (libs == null) {
            return;
        }
        int i = 0;
        while (i < libs.size()) {
            Library lib = libs.get(i);
            ((ModuleNameHelper)lib.getNameHelper()).cachedLevelNames = null;
            ++i;
        }
    }

    @Override
    public void cacheValues() {
        AbstractModuleNameContext tmpContext = (AbstractModuleNameContext)this.getNameContext("style");
        tmpContext.cacheValues();
    }
}

