/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.birt.data.engine.olap.data.util.BaseDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.IStructureCreator;
import org.eclipse.birt.data.engine.olap.data.util.PrimitiveDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.StructureDiskArray;

public class BaseDiskSortedStack {
    private static final int DEFAULT_BUFFER_SIZE = 1000;
    private static final int MAX_NUMBER_OF_SEGMENT = 100;
    private ValueIndex mValueIndex = null;
    protected List segments = null;
    protected Object[] buffer = null;
    private int bufferPos = 0;
    private ValueIndex[] popBuffer = null;
    private int popBufferSize = 0;
    private int[] pointers = null;
    private Comparator comparator = null;
    private boolean forceDistinct = false;
    private Object lastPopObject = null;
    private int size = 0;
    private IStructureCreator creator;
    private boolean useMemoryOnly = false;

    public BaseDiskSortedStack(int bufferSize, boolean isAscending, boolean forceDistinct, IStructureCreator creator) {
        this(bufferSize, forceDistinct, BaseDiskSortedStack.createComparator(isAscending), creator);
    }

    public BaseDiskSortedStack(int bufferSize, boolean forceDistinct, Comparator comparator, IStructureCreator creator) {
        this.buffer = bufferSize <= 0 ? new Object[1000] : new Object[bufferSize];
        this.segments = new ArrayList();
        this.comparator = comparator;
        this.forceDistinct = forceDistinct;
        this.mValueIndex = new ValueIndex(null, 0, comparator);
        this.size = 0;
        this.creator = creator;
    }

    private BaseDiskSortedStack(boolean forceDistinct, List segments, Comparator comparator, Object[] buffer, int bufferPos) {
        this.forceDistinct = forceDistinct;
        this.segments = segments;
        this.comparator = comparator;
        this.buffer = buffer;
        this.bufferPos = bufferPos;
        this.mValueIndex = new ValueIndex(null, 0, comparator);
    }

    public void setBufferSize(int bufferSize) {
        this.buffer = new Object[bufferSize];
    }

    public void setUseMemoryOnly(boolean useMemoryOnly) {
        this.useMemoryOnly = useMemoryOnly;
    }

    private static Comparator createComparator(boolean isAscending) {
        if (isAscending) {
            return new Comparator(){

                public int compare(Object obj1, Object obj2) {
                    Comparable data1 = (Comparable)obj1;
                    Comparable data2 = (Comparable)obj2;
                    return data1.compareTo(data2);
                }
            };
        }
        return new Comparator(){

            public int compare(Object obj1, Object obj2) {
                Comparable data1 = (Comparable)obj1;
                Comparable data2 = (Comparable)obj2;
                return data2.compareTo(data1);
            }
        };
    }

    public void push(Object o) throws IOException {
        if (this.bufferPos < this.buffer.length) {
            this.buffer[this.bufferPos] = o;
            ++this.bufferPos;
        } else if (this.useMemoryOnly) {
            Object[] tempBuffer = new Object[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, tempBuffer, 0, this.buffer.length);
            this.buffer = tempBuffer;
            this.buffer[this.bufferPos] = o;
            ++this.bufferPos;
        } else {
            this.sort(this.buffer);
            if (this.segments.size() < 100) {
                int endIndex = this.buffer.length - 1;
                if (this.forceDistinct) {
                    endIndex = this.removeDuplicated(this.buffer);
                }
                this.saveToDisk(0, endIndex);
            } else {
                BaseDiskSortedStack temp = new BaseDiskSortedStack(this.forceDistinct, this.segments, this.comparator, this.buffer, this.bufferPos);
                BaseDiskArray diskArray = this.creator == null ? new PrimitiveDiskArray() : new StructureDiskArray(this.creator);
                Object next = null;
                while ((next = temp.pop()) != null) {
                    diskArray.add(next);
                }
                temp.close();
                this.segments.clear();
                this.segments.add(diskArray);
            }
            this.buffer[0] = o;
            this.bufferPos = 1;
        }
        ++this.size;
    }

    public int size() {
        return this.size;
    }

    protected void saveToDisk(int fromIndex, int toIndex) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void sort(Object[] objectArray) {
        Arrays.sort(objectArray, this.comparator);
    }

    private void sort(Object[] objectArray, int fromIndex, int toIndex) {
        Arrays.sort(objectArray, fromIndex, toIndex, this.comparator);
    }

    private int removeDuplicated(Object[] objectArray) {
        return this.removeDuplicated(objectArray, 0, objectArray.length - 1);
    }

    private int removeDuplicated(Object[] objectArray, int fromIndex, int toIndex) {
        int pos = fromIndex;
        int i = fromIndex + 1;
        while (i <= toIndex) {
            if (this.comparator.compare(objectArray[i], objectArray[pos]) != 0) {
                objectArray[++pos] = objectArray[i];
            }
            ++i;
        }
        return pos;
    }

    public Object pop() throws IOException {
        if (this.popBuffer == null) {
            this.initPop();
        }
        if (this.popBufferSize == 0) {
            return null;
        }
        ValueIndex reObj = this.popBuffer[0];
        Object reValue = reObj.value;
        Object readValue = this.readNext(reObj.index);
        if (readValue == null) {
            --this.popBufferSize;
            if (this.popBufferSize > 0) {
                ValueIndex[] tBuffer = new ValueIndex[this.popBufferSize];
                System.arraycopy(this.popBuffer, 1, tBuffer, 0, this.popBufferSize);
                this.popBuffer = tBuffer;
            }
        } else {
            int pos = 0;
            this.mValueIndex.value = readValue;
            this.mValueIndex.index = reObj.index;
            if (this.popBufferSize > 1) {
                pos = Arrays.binarySearch(this.popBuffer, this.mValueIndex);
                if (pos < 0) {
                    pos = (pos + 1) * -1;
                }
                if (--pos == -1) {
                    pos = 0;
                }
                if (pos > 0) {
                    System.arraycopy(this.popBuffer, 1, this.popBuffer, 0, pos);
                }
            }
            this.popBuffer[pos] = this.mValueIndex;
            this.mValueIndex = reObj;
        }
        if (this.forceDistinct) {
            if (this.lastPopObject == null) {
                this.lastPopObject = reValue;
            } else if (((Comparable)this.lastPopObject).compareTo(reValue) == 0) {
                return this.pop();
            }
        }
        this.lastPopObject = reValue;
        return reValue;
    }

    private void initPop() throws IOException {
        this.sort(this.buffer, 0, this.bufferPos);
        if (this.forceDistinct) {
            this.bufferPos = this.removeDuplicated(this.buffer, 0, this.bufferPos - 1) + 1;
        }
        this.popBuffer = new ValueIndex[this.getSegmentCount()];
        this.popBufferSize = this.popBuffer.length;
        this.pointers = new int[this.getSegmentCount()];
        int i = 0;
        while (i < this.popBuffer.length) {
            this.popBuffer[i] = new ValueIndex(this.readNext(i), i, this.comparator);
            ++i;
        }
        Arrays.sort(this.popBuffer);
    }

    private int getSegmentCount() {
        return this.segments.size() + 1;
    }

    private Object readNext(int segmentNo) throws IOException {
        if (segmentNo < this.segments.size()) {
            BaseDiskArray diskList = (BaseDiskArray)this.segments.get(segmentNo);
            if (this.pointers[segmentNo] < diskList.size()) {
                int n = segmentNo;
                int n2 = this.pointers[n];
                this.pointers[n] = n2 + 1;
                return diskList.get(n2);
            }
            return null;
        }
        if (this.pointers[segmentNo] >= this.bufferPos) {
            return null;
        }
        int n = segmentNo;
        int n3 = this.pointers[n];
        this.pointers[n] = n3 + 1;
        return this.buffer[n3];
    }

    public void close() throws IOException {
        int i = 0;
        while (i < this.segments.size()) {
            BaseDiskArray diskList = (BaseDiskArray)this.segments.get(i);
            diskList.close();
            ++i;
        }
    }

    static class ValueIndex
    implements Comparable {
        Object value;
        int index;
        private Comparator comparator;

        ValueIndex(Object value, int index, Comparator comparator) {
            this.value = value;
            this.index = index;
            this.comparator = comparator;
        }

        public int compareTo(Object o) {
            ValueIndex other = (ValueIndex)o;
            int result = this.comparator.compare(this.value, other.value);
            if (result == 0) {
                if (this.index > other.index) {
                    return 1;
                }
                if (this.index == other.index) {
                    return 0;
                }
                return -1;
            }
            return result;
        }
    }
}

