/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ooxml.writer;

import java.io.OutputStream;
import java.util.logging.Level;
import org.eclipse.birt.report.engine.emitter.XMLWriter;

public class OOXmlWriter
extends XMLWriter {
    private OutputStream out;

    public void open(OutputStream outputStream, String encoding) {
        super.open(outputStream, encoding);
        this.out = outputStream;
        this.bIndent = false;
    }

    public void startWriter() {
        this.print("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\" standalone=\"yes\"?>");
    }

    protected String escapeAttrValue(String s) {
        StringBuilder result = null;
        char[] s2char = s.toCharArray();
        int i = 0;
        int max = s2char.length;
        int delta = 0;
        while (i < max) {
            char c = s2char[i];
            String replacement = null;
            if (!(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd')) {
                replacement = "";
                log.log(Level.WARNING, "Ignore the illegal XML character: 0x{0};", Integer.toHexString(c));
            }
            if (c == '&') {
                replacement = "&amp;";
            } else if (c == '\"') {
                replacement = "&quot;";
            } else if (c == '\r') {
                replacement = "&#13;";
            } else if (c == '<') {
                replacement = "&lt;";
            }
            if (replacement != null) {
                if (result == null) {
                    result = new StringBuilder(s);
                }
                result.replace(i + delta, i + delta + 1, replacement);
                delta += replacement.length() - 1;
            }
            ++i;
        }
        if (result == null) {
            return s;
        }
        return result.toString();
    }

    public void attribute(String attrName, String attrValue) {
        if (attrValue != null) {
            this.print(' ');
            this.print(attrName);
            this.print("=\"");
            this.print(this.escapeAttrValue(attrValue));
            this.print('\"');
        }
    }

    public void nameSpace(String name, String value) {
        this.attribute("xmlns:" + name, value);
    }

    public void attribute(String attrName, long value) {
        this.attribute(attrName, Long.toString(value));
    }

    public OutputStream getOutputStream() {
        return this.out;
    }
}

