/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.ContainerOperation;
import org.apache.derby.impl.store.raw.data.ReclaimSpace;
import org.apache.derby.impl.store.raw.data.StoredPage;

public class ReclaimSpaceHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int reclaimSpace(BaseDataFileFactory baseDataFileFactory, RawTransaction rawTransaction, ReclaimSpace reclaimSpace) throws StandardException {
        if (reclaimSpace.reclaimWhat() == 1) {
            return ReclaimSpaceHelper.reclaimContainer(baseDataFileFactory, rawTransaction, reclaimSpace);
        }
        LockingPolicy lockingPolicy = rawTransaction.newLockingPolicy(1, 5, true);
        ContainerHandle containerHandle = ReclaimSpaceHelper.openContainerNW(rawTransaction, lockingPolicy, reclaimSpace.getContainerId());
        if (containerHandle == null) {
            rawTransaction.abort();
            if (reclaimSpace.incrAttempts() < 3) {
                return 2;
            }
            return 1;
        }
        if (reclaimSpace.reclaimWhat() == 2) {
            Page page = containerHandle.getPageNoWait(reclaimSpace.getPageId().getPageNumber());
            if (page != null) {
                containerHandle.removePage(page);
            }
            rawTransaction.commit();
            return 1;
        }
        RecordHandle recordHandle = reclaimSpace.getHeadRowHandle();
        if (!lockingPolicy.lockRecordForWrite(rawTransaction, recordHandle, false, false)) {
            rawTransaction.abort();
            if (reclaimSpace.incrAttempts() < 3) {
                return 2;
            }
            return 1;
        }
        if (reclaimSpace.reclaimWhat() == 3) {
            containerHandle.compactRecord(recordHandle);
            rawTransaction.commitNoSync(1);
            return 1;
        }
        long l = ((PageKey)recordHandle.getPageId()).getPageNumber();
        StoredPage storedPage = (StoredPage)containerHandle.getPage(l);
        if (storedPage == null) {
            rawTransaction.abort();
            return 1;
        }
        try {
            storedPage.removeOrphanedColumnChain(reclaimSpace, containerHandle);
        }
        finally {
            storedPage.unlatch();
        }
        rawTransaction.commitNoSync(1);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int reclaimContainer(BaseDataFileFactory baseDataFileFactory, RawTransaction rawTransaction, ReclaimSpace reclaimSpace) throws StandardException {
        LockingPolicy lockingPolicy = rawTransaction.newLockingPolicy(2, 5, true);
        RawContainerHandle rawContainerHandle = rawTransaction.openDroppedContainer(reclaimSpace.getContainerId(), lockingPolicy);
        if (rawContainerHandle == null || rawContainerHandle.getContainerStatus() == 1 || rawContainerHandle.getContainerStatus() == 4) {
            if (rawContainerHandle != null) {
                rawContainerHandle.close();
            }
            rawTransaction.abort();
        } else {
            ContainerOperation containerOperation = new ContainerOperation(rawContainerHandle, 4);
            rawContainerHandle.preDirty(true);
            try {
                rawTransaction.logAndDo(containerOperation);
            }
            finally {
                rawContainerHandle.preDirty(false);
            }
            rawContainerHandle.close();
            rawTransaction.commit();
        }
        return 1;
    }

    private static ContainerHandle openContainerNW(Transaction transaction, LockingPolicy lockingPolicy, ContainerKey containerKey) throws StandardException {
        ContainerHandle containerHandle;
        block2: {
            containerHandle = null;
            try {
                containerHandle = transaction.openContainer(containerKey, lockingPolicy, 132);
            }
            catch (StandardException standardException) {
                if (standardException.isLockTimeout()) break block2;
                throw standardException;
            }
        }
        return containerHandle;
    }
}

