/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pptx.writer;

import java.util.HashMap;
import org.eclipse.birt.report.engine.emitter.pptx.writer.Slide;
import org.eclipse.birt.report.engine.ooxml.PartContainer;

public class PPTXBookmarkManager {
    private HashMap<String, String> bookmarklist;
    private HashMap<Integer, HashMap<String, String>> bmkslideRelList;
    private HashMap<Integer, HashMap<String, String>> bmkslideDiscList;
    private int disbmk = 0;

    public void addBookmark(String bmk, int slideIdx) {
        if (this.bookmarklist == null) {
            this.bookmarklist = new HashMap();
        }
        if (!this.bookmarklist.containsKey(bmk)) {
            String slideurl = "slide" + slideIdx + ".xml";
            this.bookmarklist.put(bmk, slideurl);
        }
    }

    public String getBookmarkUrl(String bmk) {
        if (this.bookmarklist != null) {
            return this.bookmarklist.get(bmk);
        }
        return null;
    }

    public String getBookmarkRelationId(String bmk, Slide slide) {
        HashMap<String, String> bookmarkRelationlist;
        String relationshipid = null;
        int slideidx = slide.getSlideId();
        if (this.bmkslideRelList == null) {
            this.bmkslideRelList = new HashMap();
        }
        if ((bookmarkRelationlist = this.bmkslideRelList.get(slideidx)) == null) {
            bookmarkRelationlist = new HashMap();
            this.bmkslideRelList.put(slideidx, bookmarkRelationlist);
        } else {
            relationshipid = bookmarkRelationlist.get(bmk);
        }
        if (relationshipid == null) {
            String slideurl = this.getBookmarkUrl(bmk);
            HashMap<String, String> disconnectbmklist = null;
            if (slideurl == null) {
                slideurl = "discon_url" + this.disbmk++;
                if (this.bmkslideDiscList == null) {
                    this.bmkslideDiscList = new HashMap();
                }
                if ((disconnectbmklist = this.bmkslideDiscList.get(slideidx)) == null) {
                    disconnectbmklist = new HashMap();
                    this.bmkslideDiscList.put(slideidx, disconnectbmklist);
                }
                disconnectbmklist.put(slideurl, bmk);
            }
            relationshipid = slide.getPart().getBookmarkId(slideurl);
            bookmarkRelationlist.put(bmk, relationshipid);
        }
        return relationshipid;
    }

    public void resolveDisconnectedBookmarks(Slide slide) {
        HashMap<String, String> bmklist;
        if (this.bmkslideDiscList != null && (bmklist = this.bmkslideDiscList.get(slide.getSlideId())) != null && !bmklist.isEmpty()) {
            PartContainer slidepart = (PartContainer)slide.getPart();
            for (String wrngurl : bmklist.keySet()) {
                String realurl = this.bookmarklist.get(bmklist.get(wrngurl));
                slidepart.updateBmk(wrngurl, realurl);
            }
        }
    }
}

