/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

final class Es6ExternsCheck
extends NodeTraversal.AbstractPreOrderCallback
implements CompilerPass {
    static final DiagnosticType MISSING_ES6_EXTERNS = DiagnosticType.error("JSC_MISSING_ES6_EXTERNS", "Missing externs definition for Symbol. Did you forget to include the ES6 externs?");
    private final AbstractCompiler compiler;
    private boolean hasSymbolExterns = false;

    Es6ExternsCheck(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, externs, this);
        if (!this.hasSymbolExterns) {
            this.compiler.report(JSError.make(MISSING_ES6_EXTERNS, new String[0]));
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (NodeUtil.isFunctionDeclaration(n) && n.getFirstChild().matchesQualifiedName("Symbol")) {
            this.hasSymbolExterns = true;
        }
        return !this.hasSymbolExterns;
    }
}

