/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.value.DataFormatValue;
import org.eclipse.birt.report.engine.ir.ActionDesign;
import org.eclipse.birt.report.engine.ir.AutoTextItemDesign;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.DrillThroughActionDesign;
import org.eclipse.birt.report.engine.ir.DynamicTextItemDesign;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.FreeFormItemDesign;
import org.eclipse.birt.report.engine.ir.GraphicMasterPageDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.HighlightDesign;
import org.eclipse.birt.report.engine.ir.HighlightRuleDesign;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;
import org.eclipse.birt.report.engine.ir.ListBandDesign;
import org.eclipse.birt.report.engine.ir.ListGroupDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.MapDesign;
import org.eclipse.birt.report.engine.ir.MapRuleDesign;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.eclipse.birt.report.engine.ir.PageVariableDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.RuleDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.ir.StyledElementDesign;
import org.eclipse.birt.report.engine.ir.TableBandDesign;
import org.eclipse.birt.report.engine.ir.TableGroupDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.engine.ir.TextItemDesign;
import org.eclipse.birt.report.engine.ir.VisibilityDesign;
import org.eclipse.birt.report.engine.ir.VisibilityRuleDesign;
import org.eclipse.birt.report.engine.parser.StylePropertyMapping;
import org.eclipse.birt.report.engine.parser.StyleUtil;
import org.eclipse.birt.report.engine.parser.TableItemDesignLayout;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.AutoTextHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColorHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignVisitor;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.ExpressionListHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FactoryPropertyHandle;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.HideRuleHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.MapRuleHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.StyleRuleHandle;
import org.eclipse.birt.report.model.api.TOCHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TemplateReportItemHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.VariableElementHandle;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.elements.structures.FormatValue;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.core.runtime.Assert;

public class EngineIRVisitor
extends DesignVisitor {
    protected static final String PREFIX_STYLE_NAME = "style_";
    protected static final String DEFAULT_MASTERPAGE_NAME = "NewSimpleMasterPage";
    protected static final double DEFAULT_MASTERPAGE_TOP_MARGIN = 0.25;
    protected static final double DEFAULT_MASTERPAGE_LEFT_MARGIN = 0.25;
    protected static final double DEFAULT_MASTERPAGE_BOTTOM_MARGIN = 0.25;
    protected static final double DEFAULT_MASTERPAGE_RIGHT_MARGIN = 0.25;
    protected static final double DEFAULT_MASTERPAGE_HEIGHT = 11.0;
    protected static final double DEFAULT_MASTERPAGE_WIDTH = 8.5;
    protected static Logger logger = Logger.getLogger(EngineIRVisitor.class.getName());
    protected Object currentElement;
    protected Report report;
    protected String defaultScriptLanguage = "javascript";
    protected ReportDesignHandle handle;
    protected CSSEngine cssEngine;
    StyleDeclaration nonInheritableReportStyle;
    StyleDeclaration inheritableReportStyle;
    protected long currentElementId = -1L;
    long newCellId = -1L;

    public EngineIRVisitor(ReportDesignHandle handle) {
        this.handle = handle;
    }

    public Report translate() {
        this.report = new Report();
        this.cssEngine = this.report.getCSSEngine();
        this.report.setReportDesign(this.handle);
        this.handle.cacheValues();
        this.apply((DesignElementHandle)this.handle);
        return this.report;
    }

    public ReportItemDesign translate(ReportElementHandle handle, Report report) {
        this.report = report;
        this.cssEngine = report.getCSSEngine();
        this.newCellId = handle.getID() * -100000000L;
        this.apply((DesignElementHandle)handle);
        assert (this.currentElement instanceof ReportItemDesign);
        return (ReportItemDesign)this.currentElement;
    }

    public void visitReportDesign(ReportDesignHandle handle) {
        String onPageStart;
        Expression.Script onPageStartScript;
        ULocale locale;
        Map<String, org.eclipse.birt.report.engine.ir.Expression> userProperties = this.createUserProperties((DesignElementHandle)handle);
        if (userProperties != null && !userProperties.isEmpty()) {
            this.report.setUserProperties(userProperties);
        }
        if ((locale = handle.getLocale()) != null) {
            this.report.setLocale(locale.toString());
        }
        this.createReportDefaultStyles(handle);
        List varElements = handle.getPageVariables();
        Collection<PageVariableDesign> varDesigns = this.report.getPageVariables();
        for (VariableElementHandle varElement : varElements) {
            String scope = varElement.getType();
            String name = varElement.getVariableName();
            ExpressionHandle exprHandle = varElement.getExpressionProperty("value");
            org.eclipse.birt.report.engine.ir.Expression defaultValue = this.createExpression(exprHandle);
            PageVariableDesign pv = new PageVariableDesign(name, scope);
            pv.setDefaultValue(defaultValue);
            varDesigns.add(pv);
        }
        String onPageEnd = handle.getOnPageEnd();
        Expression.Script onPageEndScript = this.createScript(onPageEnd);
        if (onPageEndScript != null) {
            String scriptId = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onPageEnd"));
            onPageEndScript.setFileName(scriptId);
            this.report.setOnPageEnd(onPageEndScript);
        }
        if ((onPageStartScript = this.createScript(onPageStart = handle.getOnPageStart())) != null) {
            String scriptId = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onPageStart"));
            onPageStartScript.setFileName(scriptId);
            this.report.setOnPageStart(onPageStartScript);
        }
        this.report.setJavaClass(handle.getEventHandlerClass());
        PageSetupDesign pageSetup = new PageSetupDesign();
        SlotHandle pageSlot = handle.getMasterPages();
        int i = 0;
        while (i < pageSlot.getCount()) {
            this.apply(pageSlot.get(i));
            if (this.currentElement != null) {
                pageSetup.addMasterPage((MasterPageDesign)this.currentElement);
            }
            ++i;
        }
        if (pageSlot.getCount() < 1) {
            SimpleMasterPageDesign masterPage = new SimpleMasterPageDesign();
            masterPage.setID(this.generateUniqueID());
            masterPage.setName(DEFAULT_MASTERPAGE_NAME);
            masterPage.setPageType("us-letter");
            masterPage.setOrientation("auto");
            DimensionType width = new DimensionType(8.5, "in");
            DimensionType height = new DimensionType(11.0, "in");
            masterPage.setPageSize(width, height);
            DimensionType top = new DimensionType(0.25, "in");
            DimensionType left = new DimensionType(0.25, "in");
            DimensionType bottom = new DimensionType(0.25, "in");
            DimensionType right = new DimensionType(0.25, "in");
            masterPage.setMargin(top, left, bottom, right);
            this.setupElementIDMap(masterPage);
            pageSetup.addMasterPage(masterPage);
        }
        this.report.setPageSetup(pageSetup);
        SlotHandle bodySlot = handle.getBody();
        int i2 = 0;
        while (i2 < bodySlot.getCount()) {
            this.apply(bodySlot.get(i2));
            if (this.currentElement != null) {
                this.report.addContent((ReportItemDesign)this.currentElement);
            }
            ++i2;
        }
    }

    private Map<String, org.eclipse.birt.report.engine.ir.Expression> createUserProperties(DesignElementHandle handle) {
        List propDefns = handle.getUserProperties();
        if (propDefns == null || propDefns.isEmpty()) {
            return null;
        }
        HashMap<String, org.eclipse.birt.report.engine.ir.Expression> propExprs = new HashMap<String, org.eclipse.birt.report.engine.ir.Expression>(propDefns.size());
        int i = 0;
        while (i < propDefns.size()) {
            UserPropertyDefn userDef = (UserPropertyDefn)propDefns.get(i);
            org.eclipse.birt.report.engine.ir.Expression expr = org.eclipse.birt.report.engine.util.ExpressionUtil.createUserProperty(handle, userDef);
            if (expr != null) {
                propExprs.put(userDef.getName(), expr);
            }
            ++i;
        }
        return propExprs;
    }

    private void setupMasterPage(MasterPageDesign page, MasterPageHandle handle) {
        String onPageStart;
        Expression.Script onPageStartScript;
        this.setupStyledElement(page, (ReportElementHandle)handle);
        page.setPageType(handle.getPageType());
        DimensionValue effectWidth = handle.getPageWidth();
        DimensionValue effectHeight = handle.getPageHeight();
        DimensionType width = null;
        DimensionType height = null;
        width = effectWidth != null ? new DimensionType(effectWidth.getMeasure(), effectWidth.getUnits()) : new DimensionType(8.5, "in");
        height = effectHeight != null ? new DimensionType(effectHeight.getMeasure(), effectHeight.getUnits()) : new DimensionType(11.0, "in");
        page.setPageSize(width, height);
        page.setOrientation(handle.getOrientation());
        DimensionType top = this.createDimension(handle.getTopMargin(), true);
        DimensionType left = this.createDimension(handle.getLeftMargin(), true);
        DimensionType bottom = this.createDimension(handle.getBottomMargin(), true);
        DimensionType right = this.createDimension(handle.getRightMargin(), true);
        page.setMargin(top, left, bottom, right);
        String onPageEnd = handle.getOnPageEnd();
        Expression.Script onPageEndScript = this.createScript(onPageEnd);
        if (onPageEndScript != null) {
            String scriptId = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onPageEnd"));
            onPageEndScript.setFileName(scriptId);
            page.setOnPageEnd(onPageEndScript);
        }
        if ((onPageStartScript = this.createScript(onPageStart = handle.getOnPageStart())) != null) {
            String scriptId = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onPageStart"));
            onPageStartScript.setFileName(scriptId);
            page.setOnPageStart(onPageStartScript);
        }
    }

    protected void visitDesignElement(DesignElementHandle obj) {
        this.currentElement = null;
    }

    public void visitGraphicMasterPage(GraphicMasterPageHandle handle) {
        GraphicMasterPageDesign page = new GraphicMasterPageDesign();
        this.setupMasterPage(page, (MasterPageHandle)handle);
        page.setColumns(handle.getColumnCount());
        DimensionType spacing = this.createDimension(handle.getColumnSpacing(), true);
        page.setColumnSpacing(spacing);
        SlotHandle contentSlot = handle.getContent();
        int i = 0;
        while (i < contentSlot.getCount()) {
            this.apply(contentSlot.get(i));
            if (this.currentElement != null) {
                page.addContent((ReportItemDesign)this.currentElement);
            }
            ++i;
        }
        this.setCurrentElement(page);
        Assert.isTrue((boolean)false, (String)"Graphic master page is not supported now!");
    }

    private void setCurrentElement(ReportElementDesign element) {
        this.currentElement = element;
        this.currentElementId = -1L;
    }

    public void visitSimpleMasterPage(SimpleMasterPageHandle handle) {
        SimpleMasterPageDesign page = new SimpleMasterPageDesign();
        this.setupMasterPage(page, (MasterPageHandle)handle);
        page.setHeaderHeight(this.createDimension(handle.getHeaderHeight(), true));
        page.setFooterHeight(this.createDimension(handle.getFooterHeight(), true));
        page.setShowFooterOnLast(handle.showFooterOnLast());
        page.setShowHeaderOnFirst(handle.showHeaderOnFirst());
        page.setFloatingFooter(handle.isFloatingFooter());
        SlotHandle headerSlot = handle.getPageHeader();
        int i = 0;
        while (i < headerSlot.getCount()) {
            this.apply(headerSlot.get(i));
            if (this.currentElement != null) {
                page.addHeader((ReportItemDesign)this.currentElement);
            }
            ++i;
        }
        SlotHandle footerSlot = handle.getPageFooter();
        int i2 = 0;
        while (i2 < footerSlot.getCount()) {
            this.apply(footerSlot.get(i2));
            if (this.currentElement != null) {
                page.addFooter((ReportItemDesign)this.currentElement);
            }
            ++i2;
        }
        this.setCurrentElement(page);
    }

    public void visitList(ListHandle handle) {
        SlotHandle footerSlot;
        ListItemDesign listItem = new ListItemDesign();
        this.setupListingItem(listItem, (ListingHandle)handle);
        SlotHandle headerSlot = handle.getHeader();
        if (headerSlot.getCount() > 0) {
            ListBandDesign header = this.createListBand(headerSlot);
            header.setBandType(1);
            listItem.setHeader(header);
        }
        listItem.setRepeatHeader(handle.repeatHeader());
        SlotHandle groupsSlot = handle.getGroups();
        int i = 0;
        while (i < groupsSlot.getCount()) {
            this.apply(groupsSlot.get(i));
            if (this.currentElement != null) {
                GroupDesign group = (GroupDesign)this.currentElement;
                group.setGroupLevel(i);
                listItem.addGroup(group);
            }
            ++i;
        }
        SlotHandle detailSlot = handle.getDetail();
        if (detailSlot.getCount() > 0) {
            ListBandDesign detail = this.createListBand(detailSlot);
            detail.setBandType(0);
            listItem.setDetail(detail);
        }
        if ((footerSlot = handle.getFooter()).getCount() > 0) {
            ListBandDesign footer = this.createListBand(footerSlot);
            footer.setBandType(2);
            listItem.setFooter(footer);
        }
        this.setCurrentElement(listItem);
    }

    public void visitFreeForm(FreeFormHandle handle) {
        FreeFormItemDesign container = new FreeFormItemDesign();
        this.setupReportItem(container, (ReportItemHandle)handle);
        SlotHandle slot = handle.getReportItems();
        int i = 0;
        while (i < slot.getCount()) {
            this.apply(slot.get(i));
            if (this.currentElement != null) {
                container.addItem((ReportItemDesign)this.currentElement);
            }
            ++i;
        }
        this.setCurrentElement(container);
    }

    public void visitTextDataItem(TextDataHandle handle) {
        DynamicTextItemDesign dynamicTextItem = new DynamicTextItemDesign();
        this.setupReportItem(dynamicTextItem, (ReportItemHandle)handle);
        ExpressionHandle valueExprHandle = handle.getExpressionProperty("valueExpr");
        org.eclipse.birt.report.engine.ir.Expression valueExpr = this.createExpression(valueExprHandle);
        String contentType = handle.getContentType();
        dynamicTextItem.setContent(valueExpr);
        dynamicTextItem.setContentType(contentType);
        dynamicTextItem.setJTidy(handle.isJTidy());
        this.setupHighlight(dynamicTextItem, valueExpr);
        this.setupMap(dynamicTextItem, valueExpr);
        this.setCurrentElement(dynamicTextItem);
    }

    public void visitLabel(LabelHandle handle) {
        LabelItemDesign labelItem = new LabelItemDesign();
        this.setupReportItem(labelItem, (ReportItemHandle)handle);
        String text = handle.getText();
        String textKey = handle.getTextKey();
        labelItem.setText(textKey, text);
        ActionHandle action = handle.getActionHandle();
        if (action != null) {
            labelItem.setAction(this.createAction(action));
        }
        labelItem.setHelpText(handle.getHelpTextKey(), handle.getHelpText());
        this.setCurrentElement(labelItem);
    }

    public void visitAutoText(AutoTextHandle handle) {
        AutoTextItemDesign autoTextItem = new AutoTextItemDesign();
        this.setupReportItem(autoTextItem, (ReportItemHandle)handle);
        autoTextItem.setType(handle.getAutoTextType());
        this.setCurrentElement(autoTextItem);
    }

    public void visitDataItem(DataItemHandle handle) {
        ActionHandle action;
        DataItemDesign data = new DataItemDesign();
        this.setupReportItem(data, (ReportItemHandle)handle);
        String expr = handle.getResultSetColumn();
        if (expr != null && expr.trim().length() > 0) {
            data.setBindingColumn(expr);
        }
        if ((action = handle.getActionHandle()) != null) {
            data.setAction(this.createAction(action));
        }
        data.setHelpText(handle.getHelpTextKey(), handle.getHelpText());
        org.eclipse.birt.report.engine.ir.Expression defaultExpr = org.eclipse.birt.report.engine.util.ExpressionUtil.createExpression(expr);
        this.setupHighlight(data, defaultExpr);
        this.setupMap(data, defaultExpr);
        this.setCurrentElement(data);
    }

    public void visitGrid(GridHandle handle) {
        GridItemDesign grid = new GridItemDesign();
        this.setupReportItem(grid, (ReportItemHandle)handle);
        String summary = handle.getSummary();
        if (summary != null) {
            grid.setSummary(summary);
        }
        String caption = handle.getCaption();
        String captionKey = handle.getCaptionKey();
        if (caption != null || captionKey != null) {
            grid.setCaption(captionKey, caption);
        }
        SlotHandle columnSlot = handle.getColumns();
        int i = 0;
        while (i < columnSlot.getCount()) {
            ColumnHandle columnHandle = (ColumnHandle)columnSlot.get(i);
            this.apply((DesignElementHandle)columnHandle);
            if (this.currentElement != null) {
                ColumnDesign columnDesign = (ColumnDesign)this.currentElement;
                int j = 0;
                while (j < columnHandle.getRepeatCount()) {
                    grid.addColumn(columnDesign);
                    ++j;
                }
            }
            ++i;
        }
        SlotHandle rowSlot = handle.getRows();
        int i2 = 0;
        while (i2 < rowSlot.getCount()) {
            this.apply(rowSlot.get(i2));
            if (this.currentElement != null) {
                grid.addRow((RowDesign)this.currentElement);
            }
            ++i2;
        }
        this.newCellId = new TableItemDesignLayout().layout(grid, this.newCellId);
        this.applyColumnHighlight(grid);
        this.setCurrentElement(grid);
    }

    public void visitImage(ImageHandle handle) {
        ImageItemDesign image = new ImageItemDesign();
        this.setupReportItem(image, (ReportItemHandle)handle);
        ActionHandle action = handle.getActionHandle();
        if (action != null) {
            image.setAction(this.createAction(action));
        }
        image.setHelpText(handle.getHelpTextKey(), handle.getHelpText());
        image.setFitToContainer(handle.fitToContainer());
        image.setProportionalScale(handle.isProportionalScale());
        String imageSrc = handle.getSource();
        if ("url".equals(imageSrc)) {
            ExpressionHandle urlExpr = handle.getExpressionProperty("uri");
            image.setImageUri(this.createExpression(urlExpr));
        } else if ("expr".equals(imageSrc)) {
            ExpressionHandle valueExpr = handle.getExpressionProperty("valueExpr");
            ExpressionHandle typeExpr = handle.getExpressionProperty("typeExpr");
            image.setImageExpression(this.createExpression(valueExpr), this.createExpression(typeExpr));
        } else if ("embed".equals(imageSrc)) {
            String imageName = handle.getImageName();
            image.setImageName(org.eclipse.birt.report.engine.ir.Expression.newConstant(imageName));
        } else if ("file".equals(imageSrc)) {
            ExpressionHandle fileExpr = handle.getExpressionProperty("uri");
            image.setImageFile(this.createExpression(fileExpr));
        } else assert (false);
        this.setCurrentElement(image);
    }

    private void handleAltText(ReportItemHandle handle, ReportItemDesign design) {
        ExpressionHandle altTextExpr = handle.getExpressionProperty("altText");
        design.setAltText(this.createExpression(altTextExpr));
        design.setAltTextKey(handle.getAltTextKey());
    }

    public void visitTable(TableHandle handle) {
        SlotHandle footerSlot;
        TableItemDesign table = new TableItemDesign();
        table.setRepeatHeader(handle.repeatHeader());
        this.setupListingItem(table, (ListingHandle)handle);
        String summary = handle.getSummary();
        if (summary != null) {
            table.setSummary(summary);
        }
        String caption = handle.getCaption();
        String captionKey = handle.getCaptionKey();
        if (caption != null || captionKey != null) {
            table.setCaption(captionKey, caption);
        }
        SlotHandle columnSlot = handle.getColumns();
        int i = 0;
        while (i < columnSlot.getCount()) {
            ColumnHandle columnHandle = (ColumnHandle)columnSlot.get(i);
            this.apply((DesignElementHandle)columnHandle);
            if (this.currentElement != null) {
                ColumnDesign columnDesign = (ColumnDesign)this.currentElement;
                int j = 0;
                while (j < columnHandle.getRepeatCount()) {
                    table.addColumn(columnDesign);
                    ++j;
                }
            }
            ++i;
        }
        SlotHandle headerSlot = handle.getHeader();
        if (headerSlot.getCount() > 0) {
            TableBandDesign header = this.createTableBand(headerSlot);
            header.setBandType(1);
            table.setHeader(header);
        }
        SlotHandle groupSlot = handle.getGroups();
        int i2 = 0;
        while (i2 < groupSlot.getCount()) {
            this.apply(groupSlot.get(i2));
            if (this.currentElement != null) {
                TableGroupDesign group = (TableGroupDesign)this.currentElement;
                group.setGroupLevel(i2);
                table.addGroup(group);
            }
            ++i2;
        }
        SlotHandle detailSlot = handle.getDetail();
        if (detailSlot.getCount() > 0) {
            TableBandDesign detail = this.createTableBand(detailSlot);
            detail.setBandType(0);
            table.setDetail(detail);
        }
        if ((footerSlot = handle.getFooter()).getCount() > 0) {
            TableBandDesign footer = this.createTableBand(footerSlot);
            footer.setBandType(2);
            table.setFooter(footer);
        }
        this.newCellId = new TableItemDesignLayout().layout(table, this.newCellId);
        int groupCount = table.getGroupCount();
        int i3 = 0;
        while (i3 < groupCount) {
            TableGroupDesign group = (TableGroupDesign)table.getGroup(i3);
            boolean isSummaryTable = handle.isSummaryTable();
            if (!isSummaryTable || isSummaryTable && i3 < groupCount - 1) {
                this.locateGroupIcon(group);
            }
            ++i3;
        }
        this.applyColumnHighlight(table);
        this.applySuppressDuplicate(table);
        TableBandDesign detail = (TableBandDesign)table.getDetail();
        if (detail != null) {
            int i4 = 0;
            while (i4 < detail.getRowCount()) {
                RowDesign row = detail.getRow(i4);
                int j = 0;
                while (j < row.getCellCount()) {
                    CellDesign cell = row.getCell(j);
                    ColumnDesign column = table.getColumn(cell.getColumn());
                    if (!column.hasDataItemsInDetail()) {
                        int k = 0;
                        while (k < cell.getContentCount()) {
                            ReportItemDesign item = cell.getContent(k);
                            if (item instanceof DataItemDesign) {
                                column.setHasDataItemsInDetail(true);
                                break;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i4;
            }
        }
        this.setCurrentElement(table);
    }

    private void applySuppressDuplicate(TableItemDesign table) {
        int i = 0;
        while (i < table.getGroupCount()) {
            TableGroupDesign group = (TableGroupDesign)table.getGroup(i);
            this.applySuppressDuplicate(table, (TableBandDesign)group.getHeader());
            this.applySuppressDuplicate(table, (TableBandDesign)group.getFooter());
            ++i;
        }
        this.applySuppressDuplicate(table, (TableBandDesign)table.getDetail());
    }

    private void applySuppressDuplicate(TableItemDesign table, TableBandDesign band) {
        if (band == null) {
            return;
        }
        int i = 0;
        while (i < band.getRowCount()) {
            RowDesign row = band.getRow(i);
            int j = 0;
            while (j < row.getCellCount()) {
                CellDesign cell = row.getCell(j);
                ColumnDesign column = table.getColumn(cell.getColumn());
                if (column.getSuppressDuplicate()) {
                    int k = 0;
                    while (k < cell.getContentCount()) {
                        ReportItemDesign item = cell.getContent(k);
                        if (item instanceof DataItemDesign) {
                            DataItemDesign dataItem = (DataItemDesign)item;
                            dataItem.setSuppressDuplicate(true);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void locateGroupIcon(TableGroupDesign group) {
        if (group.getHideDetail()) {
            return;
        }
        GroupHandle groupHandle = (GroupHandle)group.getHandle();
        TableHandle tableHandle = (TableHandle)groupHandle.getContainer();
        String keyExpression = groupHandle.getKeyExpr();
        if (keyExpression == null) {
            return;
        }
        keyExpression = keyExpression.trim();
        BandDesign groupHeader = group.getHeader();
        if (group.getHeader() == null) {
            return;
        }
        CellDesign firstStuffedCell = null;
        String columnBindingExpression = this.getColumnBinding(tableHandle, keyExpression);
        int i = 0;
        while (i < groupHeader.getContentCount()) {
            RowDesign row = (RowDesign)groupHeader.getContent(i);
            int j = 0;
            while (j < row.getCellCount()) {
                CellDesign cell = row.getCell(j);
                int k = 0;
                while (k < cell.getContentCount()) {
                    ReportItemDesign item = cell.getContent(k);
                    if (this.hasExpression(tableHandle, item, keyExpression, columnBindingExpression)) {
                        cell.setDisplayGroupIcon(true);
                        return;
                    }
                    ++k;
                }
                if (cell.getContentCount() > 0 && firstStuffedCell == null) {
                    firstStuffedCell = cell;
                }
                ++j;
            }
            ++i;
        }
        if (firstStuffedCell != null) {
            firstStuffedCell.setDisplayGroupIcon(true);
        } else {
            CellDesign cell;
            RowDesign row = (RowDesign)groupHeader.getContent(0);
            if (row != null && (cell = row.getCell(0)) != null) {
                cell.setDisplayGroupIcon(true);
            }
        }
    }

    private boolean hasExpression(TableHandle tableHandle, ReportItemDesign item, String keyExpression, String columnBindingExpression) {
        assert (keyExpression != null);
        if (item instanceof DataItemDesign) {
            DataItemDesign data = (DataItemDesign)item;
            String columnBinding = data.getBindingColumn();
            String value = ExpressionUtil.createJSRowExpression((String)columnBinding);
            if (value != null && keyExpression.equals(value.trim())) {
                return true;
            }
            columnBinding = this.getColumnBinding(tableHandle, value);
            if (columnBinding != null && columnBindingExpression != null && columnBindingExpression.equals(columnBinding)) {
                return true;
            }
        }
        if (item instanceof GridItemDesign) {
            GridItemDesign grid = (GridItemDesign)item;
            GridHandle gridHandle = (GridHandle)grid.getHandle();
            PropertyHandle columnBindings = gridHandle.getColumnBindings();
            if (columnBindings != null && columnBindings.iterator().hasNext()) {
                return false;
            }
            int i = 0;
            while (i < grid.getRowCount()) {
                RowDesign row = grid.getRow(i);
                int j = 0;
                while (j < row.getCellCount()) {
                    CellDesign cell = row.getCell(j);
                    int k = 0;
                    while (k < cell.getContentCount()) {
                        ReportItemDesign reportItem = cell.getContent(k);
                        if (this.hasExpression(tableHandle, reportItem, keyExpression, columnBindingExpression)) {
                            return true;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return false;
    }

    private String getColumnBinding(TableHandle tableHandle, String keyExpression) {
        String columnBindingName = null;
        try {
            columnBindingName = ExpressionUtil.getColumnBindingName((String)keyExpression);
        }
        catch (BirtException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return null;
        }
        return this.getColumnBindingByName(tableHandle, columnBindingName);
    }

    private String getColumnBindingByName(TableHandle tableHandle, String columnBindingName) {
        if (columnBindingName == null) {
            return null;
        }
        Iterator iterator = tableHandle.columnBindingsIterator();
        while (iterator.hasNext()) {
            ComputedColumnHandle columnBinding = (ComputedColumnHandle)iterator.next();
            if (!columnBindingName.equals(columnBinding.getName())) continue;
            return columnBinding.getExpression();
        }
        return null;
    }

    private void applyColumnHighlight(TableItemDesign table) {
        this.applyColumnHighlight(table, table.getHeader());
        this.applyColumnHighlight(table, table.getDetail());
        this.applyColumnHighlight(table, table.getFooter());
        int i = 0;
        while (i < table.getGroupCount()) {
            this.applyColumnHighlight(table, table.getGroup(i).getHeader());
            this.applyColumnHighlight(table, table.getGroup(i).getFooter());
            ++i;
        }
    }

    private void applyColumnHighlight(GridItemDesign grid) {
        int i = 0;
        while (i < grid.getRowCount()) {
            RowDesign row = grid.getRow(i);
            int j = 0;
            while (j < row.getCellCount()) {
                CellDesign cell = row.getCell(j);
                ColumnDesign column = grid.getColumn(cell.getColumn());
                this.applyColumnHighlight(column, cell);
                ++j;
            }
            ++i;
        }
    }

    private void applyColumnHighlight(TableItemDesign table, BandDesign band) {
        if (band == null) {
            return;
        }
        int i = 0;
        while (i < band.getContentCount()) {
            ReportItemDesign content = band.getContent(i);
            if (content instanceof RowDesign) {
                RowDesign row = (RowDesign)content;
                int j = 0;
                while (j < row.getCellCount()) {
                    CellDesign cell = row.getCell(j);
                    ColumnDesign column = table.getColumn(cell.getColumn());
                    this.applyColumnHighlight(column, cell);
                    ++j;
                }
            }
            ++i;
        }
    }

    private void applyColumnHighlight(ColumnDesign column, CellDesign cell) {
        HighlightDesign columnHighlight = column.getHighlight();
        if (columnHighlight != null && columnHighlight.getRuleCount() > 0) {
            HighlightDesign cellHighlight = cell.getHighlight();
            if (cellHighlight == null) {
                cellHighlight = new HighlightDesign();
                cell.setHighlight(cellHighlight);
            }
            int i = 0;
            while (i < columnHighlight.getRuleCount()) {
                cellHighlight.addRule(new HighlightRuleDesign(columnHighlight.getRule(i)));
                ++i;
            }
        }
    }

    public void visitColumn(ColumnHandle handle) {
        ColumnDesign col = new ColumnDesign();
        this.setupReportElement(col, (DesignElementHandle)handle);
        StyleDeclaration style = this.createColumnStyle((ReportElementHandle)handle);
        if (style != null && !style.isEmpty()) {
            col.setStyleName(this.assignStyleName(style));
        }
        col.setColumnHeaderState(false);
        DimensionType width = this.createDimension(handle.getWidth(), false);
        col.setWidth(width);
        boolean supress = handle.suppressDuplicates();
        col.setSuppressDuplicate(supress);
        VisibilityDesign visibility = this.createVisibility(handle.visibilityRulesIterator());
        col.setVisibility(visibility);
        this.setCurrentElement(col);
    }

    public void visitRow(RowHandle handle) {
        String onRender;
        Expression.Script onRenderScript;
        RowDesign row = new RowDesign();
        this.setupStyledElement(row, (ReportElementHandle)handle);
        DimensionType height = this.createDimension(handle.getHeight(), false);
        row.setHeight(height);
        ExpressionHandle bookmarkExpr = handle.getExpressionProperty("bookmark");
        row.setBookmark(this.createExpression(bookmarkExpr));
        VisibilityDesign visibility = this.createVisibility(handle.visibilityRulesIterator());
        row.setVisibility(visibility);
        SlotHandle cellSlot = handle.getCells();
        int i = 0;
        while (i < cellSlot.getCount()) {
            this.apply(cellSlot.get(i));
            if (this.currentElement != null) {
                row.addCell((CellDesign)this.currentElement);
            }
            ++i;
        }
        String onCreate = handle.getOnCreate();
        Expression.Script onCreateScript = this.createScript(onCreate);
        if (onCreateScript != null) {
            String id = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onCreate"));
            onCreateScript.setFileName(id);
            row.setOnCreate(onCreateScript);
        }
        if ((onRenderScript = this.createScript(onRender = handle.getOnRender())) != null) {
            String id = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onRender"));
            onRenderScript.setFileName(id);
            row.setOnRender(onRenderScript);
        }
        this.setupHighlight(row, null);
        row.setRepeatable(handle.repeatable());
        this.setCurrentElement(row);
    }

    protected void setupStyledElement(StyledElementDesign design, ReportElementHandle handle) {
        this.setupReportElement(design, (DesignElementHandle)handle);
        StyleDeclaration style = this.createStyle(handle, design);
        if (style != null && !style.isEmpty()) {
            design.setStyleName(this.assignStyleName(style));
        }
    }

    public void visitCell(CellHandle handle) {
        int antidiagonalNumber;
        String onRender;
        Expression.Script onRenderScript;
        String onCreate;
        Expression.Script onCreateScript;
        CellDesign cell = new CellDesign();
        this.setupStyledElement(cell, (ReportElementHandle)handle);
        this.setupAuralInfomation(cell, handle);
        SlotHandle contentSlot = handle.getContent();
        int i = 0;
        while (i < contentSlot.getCount()) {
            this.apply(contentSlot.get(i));
            if (this.currentElement != null) {
                cell.addContent((ReportItemDesign)this.currentElement);
            }
            ++i;
        }
        cell.setColSpan(handle.getColumnSpan());
        int columnId = handle.getColumn() - 1;
        if (columnId < 0) {
            columnId = -1;
        }
        cell.setColumn(columnId);
        cell.setRowSpan(handle.getRowSpan());
        if (this.isCellInGroupHeader(handle)) {
            cell.setDrop(handle.getDrop());
        }
        if ((onCreateScript = this.createScript(onCreate = handle.getOnCreate())) != null) {
            String id = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onCreate"));
            onCreateScript.setFileName(id);
            cell.setOnCreate(onCreateScript);
        }
        if ((onRenderScript = this.createScript(onRender = handle.getOnRender())) != null) {
            String id = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onRender"));
            onRenderScript.setFileName(id);
            cell.setOnRender(onRenderScript);
        }
        this.setupHighlight(cell, null);
        int diagonalNumber = handle.getDiagonalNumber();
        if (diagonalNumber > 0) {
            cell.setDiagonalNumber(diagonalNumber);
            cell.setDiagonalStyle(handle.getDiagonalStyle());
            cell.setDiagonalWidth(this.createDimension(handle.getDiagonalThickness(), true));
            ColorHandle colorHandle = handle.getDiagonalColor();
            if (colorHandle != null) {
                cell.setDiagonalColor(colorHandle.getStringValue());
            }
        }
        if ((antidiagonalNumber = handle.getAntidiagonalNumber()) > 0) {
            cell.setAntidiagonalNumber(antidiagonalNumber);
            cell.setAntidiagonalStyle(handle.getAntidiagonalStyle());
            cell.setAntidiagonalWidth(this.createDimension(handle.getAntidiagonalThickness(), true));
            ColorHandle colorHandle = handle.getAntidiagonalColor();
            if (colorHandle != null) {
                cell.setAntidiagonalColor(colorHandle.getStringValue());
            }
        }
        this.setCurrentElement(cell);
    }

    private void setupAuralInfomation(CellDesign cell, CellHandle handle) {
        ExpressionHandle bookmarkExpr = handle.getExpressionProperty("bookmark");
        cell.setBookmark(this.createExpression(bookmarkExpr));
        ExpressionHandle headersExpr = handle.getExpressionProperty("headers");
        cell.setHeaders(this.createExpression(headersExpr));
        String scope = handle.getScope();
        if (scope != null) {
            cell.setScope(scope);
        }
    }

    private boolean isCellInGroupHeader(CellHandle cellHandle) {
        SlotHandle slot;
        DesignElementHandle groupHandle;
        DesignElementHandle rowHandle = cellHandle.getContainer();
        return rowHandle instanceof RowHandle && (groupHandle = rowHandle.getContainer()) instanceof TableGroupHandle && (slot = rowHandle.getContainerSlotHandle()) != null && slot.getSlotID() == 0;
    }

    private ListBandDesign createListBand(SlotHandle elements) {
        ListBandDesign band = new ListBandDesign();
        band.setID(this.generateUniqueID());
        this.setupElementIDMap(band);
        int i = 0;
        while (i < elements.getCount()) {
            this.apply(elements.get(i));
            if (this.currentElement != null) {
                band.addContent((ReportItemDesign)this.currentElement);
            }
            ++i;
        }
        return band;
    }

    public void visitListGroup(ListGroupHandle handle) {
        SlotHandle footerSlot;
        ListGroupDesign listGroup = new ListGroupDesign();
        this.setupGroup(listGroup, (GroupHandle)handle);
        SlotHandle headerSlot = handle.getHeader();
        if (headerSlot.getCount() > 0) {
            ListBandDesign header = this.createListBand(headerSlot);
            header.setBandType(3);
            header.setGroup(listGroup);
            listGroup.setHeader(header);
            listGroup.setHeaderRepeat(handle.repeatHeader());
            TOCHandle toc = handle.getTOC();
            if (toc != null) {
                ExpressionHandle tocExpr = toc.getExpressionProperty("expressionValue");
                listGroup.setTOC(this.createExpression(tocExpr));
            }
        }
        if ((footerSlot = handle.getFooter()).getCount() > 0) {
            ListBandDesign footer = this.createListBand(footerSlot);
            footer.setBandType(4);
            footer.setGroup(listGroup);
            listGroup.setFooter(footer);
        }
        listGroup.setHideDetail(handle.hideDetail());
        this.setCurrentElement(listGroup);
    }

    public void visitTableGroup(TableGroupHandle handle) {
        SlotHandle footerSlot;
        TableGroupDesign tableGroup = new TableGroupDesign();
        this.setupGroup(tableGroup, (GroupHandle)handle);
        SlotHandle headerSlot = handle.getHeader();
        if (headerSlot.getCount() > 0) {
            TableBandDesign header = this.createTableBand(handle.getHeader());
            header.setBandType(3);
            header.setGroup(tableGroup);
            tableGroup.setHeader(header);
            tableGroup.setHeaderRepeat(handle.repeatHeader());
            TOCHandle tocHandle = handle.getTOC();
            if (tocHandle != null) {
                ExpressionHandle tocExpr = tocHandle.getExpressionProperty("expressionValue");
                tableGroup.setTOC(this.createExpression(tocExpr));
            }
        }
        if ((footerSlot = handle.getFooter()).getCount() > 0) {
            TableBandDesign footer = this.createTableBand(handle.getFooter());
            footer.setBandType(4);
            footer.setGroup(tableGroup);
            tableGroup.setFooter(footer);
        }
        tableGroup.setHideDetail(handle.hideDetail());
        this.setCurrentElement(tableGroup);
    }

    public void visitTextItem(TextItemHandle handle) {
        TextItemDesign textItem = new TextItemDesign();
        this.setupReportItem(textItem, (ReportItemHandle)handle);
        String contentType = handle.getContentType();
        if (contentType != null) {
            textItem.setTextType(contentType);
        }
        textItem.setText(handle.getContentKey(), handle.getContent());
        textItem.setHasExpression(handle.hasExpression());
        textItem.setJTidy(handle.isJTidy());
        this.currentElement = textItem;
    }

    protected void visitExtendedItem(ExtendedItemHandle obj) {
        ExtendedItemDesign extendedItem = new ExtendedItemDesign();
        this.setupReportItem(extendedItem, (ReportItemHandle)obj);
        this.handleExtendedItemChildren(extendedItem, obj);
        this.setCurrentElement(extendedItem);
    }

    private void handleExtendedItemChildren(ExtendedItemDesign extendedItem, ExtendedItemHandle extendedHandle) {
        if (extendedHandle == null) {
            return;
        }
        Iterator propIter = extendedHandle.getPropertyIterator();
        while (propIter.hasNext()) {
            PropertyHandle propHandle = (PropertyHandle)propIter.next();
            IElementPropertyDefn property = propHandle.getPropertyDefn();
            if (property.getTypeCode() != 23) continue;
            Object children = propHandle.getValue();
            if (children instanceof List) {
                List tempList = (List)children;
                int i = 0;
                while (tempList != null && i < tempList.size()) {
                    Object tempObj = tempList.get(i);
                    if (tempObj instanceof ReportItemHandle) {
                        this.apply((DesignElementHandle)((ReportItemHandle)tempObj));
                        extendedItem.getChildren().add(this.currentElement);
                    }
                    ++i;
                }
                continue;
            }
            if (!(children instanceof ReportItemHandle)) continue;
            this.apply((DesignElementHandle)((ReportItemHandle)children));
            extendedItem.getChildren().add(this.currentElement);
        }
    }

    public void visitTemplateReportItem(TemplateReportItemHandle obj) {
        TemplateDesign template = new TemplateDesign();
        this.setupTemplateReportElement(template, obj);
        template.setPromptText(obj.getDescription());
        template.setPromptTextKey(obj.getDescriptionKey());
        template.setAllowedType(obj.getAllowedType());
        this.setCurrentElement(template);
    }

    protected void setupGroup(GroupDesign group, GroupHandle handle) {
        String onPageBreak;
        Expression.Script onPageBreakScript;
        String onRender;
        Expression.Script onRenderScript;
        group.setID(handle.getID());
        this.setupElementIDMap(group);
        group.setName(handle.getName());
        String pageBreakBefore = handle.getPageBreakBefore();
        String pageBreakAfter = handle.getPageBreakAfter();
        String pageBreakInside = handle.getPageBreakInside();
        group.setPageBreakBefore(pageBreakBefore);
        group.setPageBreakAfter(pageBreakAfter);
        group.setPageBreakInside(pageBreakInside);
        TOCHandle tocHandle = handle.getTOC();
        if (tocHandle != null) {
            ExpressionHandle tocExpr = tocHandle.getExpressionProperty("expressionValue");
            group.setTOC(this.createExpression(tocExpr));
        }
        ExpressionHandle bookmarkExpr = handle.getExpressionProperty("bookmark");
        group.setBookmark(this.createExpression(bookmarkExpr));
        String onCreate = handle.getOnCreate();
        Expression.Script onCreateScript = this.createScript(onCreate);
        if (onCreateScript != null) {
            String id = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onCreate"));
            onCreateScript.setFileName(id);
            group.setOnCreate(onCreateScript);
        }
        if ((onRenderScript = this.createScript(onRender = handle.getOnRender())) != null) {
            String id = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onRender"));
            onRenderScript.setFileName(id);
            group.setOnRender(onRenderScript);
        }
        if ((onPageBreakScript = this.createScript(onPageBreak = handle.getOnPageBreak())) != null) {
            String id = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onPageBreak"));
            onPageBreakScript.setFileName(id);
            group.setOnPageBreak(onPageBreakScript);
        }
        group.setHandle((DesignElementHandle)handle);
        group.setJavaClass(handle.getEventHandlerClass());
    }

    private TableBandDesign createTableBand(SlotHandle elements) {
        TableBandDesign band = new TableBandDesign();
        band.setID(this.generateUniqueID());
        this.setupElementIDMap(band);
        int i = 0;
        while (i < elements.getCount()) {
            this.apply(elements.get(i));
            if (this.currentElement != null) {
                band.addRow((RowDesign)this.currentElement);
            }
            ++i;
        }
        return band;
    }

    protected VisibilityDesign createVisibility(Iterator visibilityRulesIterator) {
        if (visibilityRulesIterator != null && visibilityRulesIterator.hasNext()) {
            VisibilityDesign visibility = new VisibilityDesign();
            do {
                VisibilityRuleDesign hide = this.createHide((HideRuleHandle)visibilityRulesIterator.next());
                visibility.addRule(hide);
            } while (visibilityRulesIterator.hasNext());
            return visibility;
        }
        return null;
    }

    protected VisibilityRuleDesign createHide(HideRuleHandle handle) {
        VisibilityRuleDesign rule = new VisibilityRuleDesign();
        ExpressionHandle valueExpr = handle.getExpressionProperty("valueExpr");
        rule.setExpression(this.createExpression(valueExpr));
        String format = handle.getFormat();
        if ("viewer".equalsIgnoreCase(format)) {
            format = "html";
        }
        rule.setFormat(format);
        return rule;
    }

    private void setupReportItem(ReportItemDesign item, ReportItemHandle handle) {
        String onPageBreak;
        Expression.Script onPageBreakScript;
        String onRender;
        Expression.Script onRenderScript;
        this.setupStyledElement(item, (ReportElementHandle)handle);
        DimensionType height = this.createDimension(handle.getHeight(), false);
        DimensionType width = this.createDimension(handle.getWidth(), false);
        DimensionType x = this.createDimension(handle.getX(), false);
        DimensionType y = this.createDimension(handle.getY(), false);
        item.setHeight(height);
        item.setWidth(width);
        item.setX(x);
        item.setY(y);
        TOCHandle tocHandle = handle.getTOC();
        if (tocHandle != null) {
            ExpressionHandle tocExpr = tocHandle.getExpressionProperty("expressionValue");
            item.setTOC(this.createExpression(tocExpr));
        }
        ExpressionHandle bookmarkExpr = handle.getExpressionProperty("bookmark");
        item.setBookmark(this.createExpression(bookmarkExpr));
        String onCreate = handle.getOnCreate();
        Expression.Script onCreateScript = this.createScript(onCreate);
        if (onCreateScript != null) {
            String id = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onCreate"));
            onCreateScript.setFileName(id);
            item.setOnCreate(onCreateScript);
        }
        if ((onRenderScript = this.createScript(onRender = handle.getOnRender())) != null) {
            String id = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onRender"));
            onRenderScript.setFileName(id);
            item.setOnRender(onRenderScript);
        }
        if ((onPageBreakScript = this.createScript(onPageBreak = handle.getOnPageBreak())) != null) {
            String id = ModuleUtil.getScriptUID((Object)handle.getPropertyHandle("onPageBreak"));
            onPageBreakScript.setFileName(id);
            item.setOnPageBreak(onPageBreakScript);
        }
        Iterator visibilityIter = handle.visibilityRulesIterator();
        VisibilityDesign visibility = this.createVisibility(visibilityIter);
        item.setVisibility(visibility);
        this.setupHighlight(item, null);
        if (handle.getDataBindingReference() != null) {
            item.setUseCachedResult(true);
        }
        this.handleAltText(handle, item);
    }

    private void setupReportElement(ReportElementDesign element, DesignElementHandle handle) {
        element.setHandle(handle);
        element.setName(handle.getName());
        long id = this.currentElementId == -1L ? handle.getID() : this.currentElementId;
        element.setID(id);
        Map<String, org.eclipse.birt.report.engine.ir.Expression> userProperties = this.createUserProperties(handle);
        if (userProperties != null && !userProperties.isEmpty()) {
            element.setUserProperties(userProperties);
        }
        this.setupElementIDMap(element);
        element.setJavaClass(handle.getEventHandlerClass());
    }

    private void setupTemplateReportElement(ReportItemDesign element, TemplateReportItemHandle handle) {
        this.setupReportElement(element, (DesignElementHandle)handle);
        Iterator visibilityIter = handle.visibilityRulesIterator();
        VisibilityDesign visibility = this.createVisibility(visibilityIter);
        element.setVisibility(visibility);
    }

    protected ActionDesign createAction(ActionHandle handle) {
        ActionDesign action = new ActionDesign();
        String linkType = handle.getLinkType();
        action.setTooltip(handle.getToolTip());
        if ("hyperlink".equals(linkType)) {
            ExpressionHandle urlExpr = handle.getExpressionProperty("uri");
            action.setHyperlink(this.createExpression(urlExpr));
            action.setTargetWindow(handle.getTargetWindow());
        } else if ("bookmark-link".equals(linkType)) {
            ExpressionHandle bookmarkExpr = handle.getExpressionProperty("targetBookmark");
            action.setBookmark(this.createExpression(bookmarkExpr));
        } else if ("drill-through".equals(linkType)) {
            action.setTargetWindow(handle.getTargetWindow());
            DrillThroughActionDesign drillThrough = new DrillThroughActionDesign();
            action.setDrillThrough(drillThrough);
            String reportNameExpr = handle.getReportName();
            drillThrough.setReportName(org.eclipse.birt.report.engine.ir.Expression.newConstant(reportNameExpr));
            drillThrough.setTargetFileType(handle.getTargetFileType());
            drillThrough.setFormat(handle.getFormatType());
            ExpressionHandle bookmarkExpr = handle.getExpressionProperty("targetBookmark");
            drillThrough.setBookmark(this.createExpression(bookmarkExpr));
            drillThrough.setBookmarkType(!"toc".equals(handle.getTargetBookmarkType()));
            HashMap<String, List<org.eclipse.birt.report.engine.ir.Expression>> params = new HashMap<String, List<org.eclipse.birt.report.engine.ir.Expression>>();
            Iterator paramIte = handle.paramBindingsIterator();
            while (paramIte.hasNext()) {
                ParamBindingHandle member = (ParamBindingHandle)paramIte.next();
                String name = member.getParamName();
                ExpressionListHandle listHandle = member.getExpressionListHandle();
                List<org.eclipse.birt.report.engine.ir.Expression> exprs = this.createExpression(listHandle);
                if (exprs == null) continue;
                params.put(name, exprs);
            }
            drillThrough.setParameters(params);
        } else assert (false);
        return action;
    }

    protected HighlightRuleDesign createHighlightRule(StyledElementDesign design, HighlightRuleHandle ruleHandle, org.eclipse.birt.report.engine.ir.Expression defaultExpr) {
        HighlightRuleDesign rule = new HighlightRuleDesign();
        this.setupRuleDesign(rule, (StyleRuleHandle)ruleHandle, defaultExpr);
        StyleDeclaration style = new StyleDeclaration(this.cssEngine);
        this.setupStyle(design, (StructureHandle)ruleHandle, style);
        if (style.isEmpty()) {
            return null;
        }
        rule.setStyle(style);
        return rule;
    }

    protected void setupHighlight(StyledElementDesign item, org.eclipse.birt.report.engine.ir.Expression defaultExpr) {
        StyleHandle handle = item.getHandle().getPrivateStyle();
        if (handle == null) {
            return;
        }
        Iterator iter = handle.highlightRulesIterator();
        if (iter == null) {
            return;
        }
        if (iter.hasNext()) {
            HighlightDesign highlight = new HighlightDesign();
            do {
                HighlightRuleHandle ruleHandle;
                HighlightRuleDesign rule;
                if ((rule = this.createHighlightRule(item, ruleHandle = (HighlightRuleHandle)iter.next(), defaultExpr)) == null) continue;
                highlight.addRule(rule);
            } while (iter.hasNext());
            item.setHighlight(highlight);
        }
    }

    protected void setupMap(StyledElementDesign item, org.eclipse.birt.report.engine.ir.Expression defaultExpr) {
        StyleHandle handle = item.getHandle().getPrivateStyle();
        if (handle == null) {
            return;
        }
        Iterator iter = handle.mapRulesIterator();
        if (iter == null) {
            return;
        }
        MapDesign map = new MapDesign();
        while (iter.hasNext()) {
            MapRuleHandle ruleHandle = (MapRuleHandle)iter.next();
            MapRuleDesign rule = this.createMapRule(ruleHandle, defaultExpr);
            if (rule == null) continue;
            map.addRule(rule);
        }
        if (map.getRuleCount() > 0) {
            item.setMap(map);
        }
    }

    protected MapRuleDesign createMapRule(MapRuleHandle handle, org.eclipse.birt.report.engine.ir.Expression defaultExpr) {
        MapRuleDesign rule = new MapRuleDesign();
        this.setupRuleDesign(rule, (StyleRuleHandle)handle, defaultExpr);
        String displayText = handle.getDisplay();
        rule.setDisplayText(handle.getDisplayKey(), displayText == null ? "" : displayText);
        return rule;
    }

    private void setupRuleDesign(RuleDesign rule, StyleRuleHandle handle, org.eclipse.birt.report.engine.ir.Expression defaultExpr) {
        ExpressionListHandle exprHandles;
        boolean isListStyle = ModuleUtil.isListStyleRuleValue((StyleRuleHandle)handle);
        if (isListStyle) {
            exprHandles = handle.getValue1ExpressionList();
            List<org.eclipse.birt.report.engine.ir.Expression> exprs = this.createExpression(exprHandles);
            rule.setExpression(handle.getOperator(), exprs);
        } else {
            exprHandles = handle.getValue1ExpressionList();
            List<org.eclipse.birt.report.engine.ir.Expression> exprs = this.createExpression(exprHandles);
            ExpressionHandle value2Expr = handle.getExpressionProperty("value2");
            rule.setExpression(handle.getOperator(), exprs.size() > 0 ? exprs.get(0) : null, this.createExpression(value2Expr));
        }
        org.eclipse.birt.report.engine.ir.Expression testExpr = this.createExpression(handle.getExpressionProperty("testExpr"));
        if (testExpr != null) {
            rule.setTestExpression(testExpr);
        } else if (defaultExpr != null) {
            rule.setTestExpression(defaultExpr);
        }
    }

    private String assignStyleName(StyleDeclaration style) {
        if (style == null || style.isEmpty()) {
            return null;
        }
        Map styles = this.report.getStyles();
        for (Map.Entry entry : styles.entrySet()) {
            StyleDeclaration cachedStyle = (StyleDeclaration)entry.getValue();
            if (!cachedStyle.equals(style)) continue;
            style = cachedStyle;
            return (String)entry.getKey();
        }
        String styleName = PREFIX_STYLE_NAME + styles.size();
        this.report.addStyle(styleName, style);
        return styleName;
    }

    protected String getStyleProperty(StyleHandle handle, String name) {
        PropertyHandle prop = handle.getPropertyHandle(name);
        if (prop != null && prop.isSet()) {
            return prop.getStringValue();
        }
        return null;
    }

    protected String getElementProperty(ReportElementHandle handle, String name) {
        return this.getElementProperty(handle, name, false);
    }

    protected String getElementProperty(ReportElementHandle handle, String name, boolean isColorProperty) {
        FactoryPropertyHandle prop = handle.getFactoryPropertyHandle(name);
        if (prop != null && prop.isSet()) {
            if (isColorProperty) {
                return prop.getColorValue();
            }
            return prop.getStringValue();
        }
        return null;
    }

    String getElementColorProperty(ReportElementHandle handle, String name) {
        FactoryPropertyHandle prop = handle.getFactoryPropertyHandle(name);
        if (prop != null && prop.isSet()) {
            return prop.getColorValue();
        }
        return null;
    }

    protected String decodePageBreak(String pageBreak) {
        if (pageBreak == null) {
            return null;
        }
        if ("always".equals(pageBreak) || "always-excluding-last".equals(pageBreak)) {
            return "always";
        }
        if ("auto".equals(pageBreak)) {
            return "auto";
        }
        if ("avoid".equals(pageBreak)) {
            return "avoid";
        }
        if ("always".equals(pageBreak)) {
            return "always";
        }
        if ("always-excluding-first".equals(pageBreak)) {
            return "always";
        }
        if ("auto".equals(pageBreak)) {
            return "auto";
        }
        if ("avoid".equals(pageBreak)) {
            return "avoid";
        }
        return "auto";
    }

    protected StyleDeclaration createColumnStyle(ReportElementHandle handle) {
        StyleDeclaration style = new StyleDeclaration(this.cssEngine);
        String pageBreakAfter = this.getElementProperty(handle, "pageBreakAfter");
        style.setPageBreakAfter(this.decodePageBreak(pageBreakAfter));
        String pageBreakBefore = this.getElementProperty(handle, "pageBreakBefore");
        style.setPageBreakBefore(this.decodePageBreak(pageBreakBefore));
        String display = this.getElementProperty(handle, "display");
        style.setDisplay(display);
        return style;
    }

    private void createDataFormat(DesignElementHandle handle, StyleDeclaration style) {
        if (handle == null) {
            return;
        }
        Set<String> propertyNames = StyleUtil.customName2Index.keySet();
        for (String propertyName : propertyNames) {
            ULocale locale;
            if (!"data-format".equalsIgnoreCase(propertyName)) continue;
            DataFormatValue formatSet = new DataFormatValue();
            boolean formatSetValid = false;
            FormatValue modelValue = (FormatValue)handle.getProperty("stringFormat");
            if (modelValue != null) {
                locale = modelValue.getLocale();
                formatSet.setStringFormat(modelValue.getPattern(), locale == null ? null : locale.toString());
                formatSetValid = true;
            }
            if ((modelValue = (FormatValue)handle.getProperty("numberFormat")) != null) {
                locale = modelValue.getLocale();
                formatSet.setNumberFormat(modelValue.getPattern(), locale == null ? null : locale.toString());
                formatSetValid = true;
            }
            if ((modelValue = (FormatValue)handle.getProperty("dateFormat")) != null) {
                locale = modelValue.getLocale();
                formatSet.setDateFormat(modelValue.getPattern(), locale == null ? null : locale.toString());
                formatSetValid = true;
            }
            if ((modelValue = (FormatValue)handle.getProperty("timeFormat")) != null) {
                locale = modelValue.getLocale();
                formatSet.setTimeFormat(modelValue.getPattern(), locale == null ? null : locale.toString());
                formatSetValid = true;
            }
            if ((modelValue = (FormatValue)handle.getProperty("dateTimeFormat")) != null) {
                locale = modelValue.getLocale();
                formatSet.setDateTimeFormat(modelValue.getPattern(), locale == null ? null : locale.toString());
                formatSetValid = true;
            }
            if (!formatSetValid) continue;
            style.setProperty(StyleUtil.customName2Index.get(propertyName), formatSet);
        }
    }

    protected StyleDeclaration createStyle(ReportElementHandle handle, StyledElementDesign design) {
        StyleDeclaration style = new StyleDeclaration(this.cssEngine);
        Set<String> styles = StyleUtil.styleName2Index.keySet();
        for (String propertyName : styles) {
            this.populateElementProperty(handle, design, style, propertyName);
        }
        this.createDataFormat((DesignElementHandle)handle, style);
        return style;
    }

    private void populateElementProperty(ReportElementHandle handle, StyledElementDesign design, StyleDeclaration style, String propertyName) {
        boolean isColorProperty = StyleUtil.colorProperties.contains(propertyName);
        String elementProperty = this.getElementProperty(handle, propertyName, isColorProperty);
        this.populateStyle(design, style, propertyName, elementProperty);
    }

    private void populateStyle(StyledElementDesign design, IStyle style, String propertyName, String elementProperty) {
        int propertyIndex = StyleUtil.styleName2Index.get(propertyName);
        style.setCssText(propertyIndex, elementProperty);
    }

    String getMemberProperty(Module module, StructureHandle handle, String name) {
        MemberHandle prop = handle.getMember(name);
        if (prop != null) {
            Object value = prop.getContext().getLocalValue(module);
            if (value != null) {
                return prop.getStringValue();
            }
            if (handle instanceof HighlightRuleHandle) {
                StyleHandle styleHandle = ((HighlightRuleHandle)handle).getStyle();
                if (styleHandle == null) {
                    return null;
                }
                FactoryPropertyHandle propHandle = styleHandle.getFactoryPropertyHandle(name);
                if (propHandle == null) {
                    return null;
                }
                return propHandle.getStringValue();
            }
            return null;
        }
        return null;
    }

    void setupStyle(StyledElementDesign design, StructureHandle highlight, IStyle style) {
        Set<String> propertyNames = StyleUtil.ruleStyleName2Index.keySet();
        for (String propertyName : propertyNames) {
            this.populateHighlightStyle(design, highlight, style, propertyName);
        }
        this.createDataFormat(highlight, style);
    }

    private void createDataFormat(StructureHandle handle, IStyle style) {
        if (handle == null) {
            return;
        }
        Set<String> propertyNames = StyleUtil.customName2Index.keySet();
        for (String propertyName : propertyNames) {
            ULocale locale;
            if (!"data-format".equalsIgnoreCase(propertyName)) continue;
            DataFormatValue formatSet = new DataFormatValue();
            boolean formatSetValid = false;
            FormatValue modelValue = (FormatValue)handle.getProperty("stringFormat");
            if (modelValue != null) {
                locale = modelValue.getLocale();
                formatSet.setStringFormat(modelValue.getPattern(), locale == null ? null : locale.toString());
                formatSetValid = true;
            }
            if ((modelValue = (FormatValue)handle.getProperty("numberFormat")) != null) {
                locale = modelValue.getLocale();
                formatSet.setNumberFormat(modelValue.getPattern(), locale == null ? null : locale.toString());
                formatSetValid = true;
            }
            if ((modelValue = (FormatValue)handle.getProperty("dateFormat")) != null) {
                locale = modelValue.getLocale();
                formatSet.setDateFormat(modelValue.getPattern(), locale == null ? null : locale.toString());
                formatSetValid = true;
            }
            if ((modelValue = (FormatValue)handle.getProperty("timeFormat")) != null) {
                locale = modelValue.getLocale();
                formatSet.setTimeFormat(modelValue.getPattern(), locale == null ? null : locale.toString());
                formatSetValid = true;
            }
            if ((modelValue = (FormatValue)handle.getProperty("dateTimeFormat")) != null) {
                locale = modelValue.getLocale();
                formatSet.setDateTimeFormat(modelValue.getPattern(), locale == null ? null : locale.toString());
                formatSetValid = true;
            }
            if (!formatSetValid) continue;
            style.setProperty(StyleUtil.customName2Index.get(propertyName), formatSet);
        }
    }

    private void populateHighlightStyle(StyledElementDesign design, StructureHandle highlight, IStyle style, String propertyName) {
        Module module = design.getHandle().getModule();
        String property = this.getMemberProperty(module, highlight, propertyName);
        this.populateStyle(design, style, propertyName, property);
    }

    protected DimensionType createDimension(DimensionHandle handle, boolean useDefault) {
        if (handle == null || !useDefault && !handle.isSet()) {
            return null;
        }
        if (handle.isKeyword()) {
            return new DimensionType(handle.getStringValue());
        }
        double measure = handle.getMeasure();
        String unit = handle.getUnits();
        if (unit == null || unit.length() == 0) {
            unit = handle.getDefaultUnit();
        }
        return new DimensionType(measure, unit);
    }

    protected void setupListingItem(ListingDesign listing, ListingHandle handle) {
        this.setupReportItem(listing, (ReportItemHandle)handle);
        int interval = handle.getPageBreakInterval();
        if (interval > 0) {
            listing.setPageBreakInterval(interval);
        }
    }

    protected void addReportDefaultPropertyValue(String name, StyleHandle handle) {
        this.addReportDefaultPropertyValue(name, handle, false);
    }

    protected void addReportDefaultPropertyValue(String name, StyleHandle handle, boolean isColorProperty) {
        Object value = null;
        int index = StylePropertyMapping.getPropertyID(name);
        if (StylePropertyMapping.canInherit(name)) {
            if (handle != null) {
                value = isColorProperty ? handle.getColorProperty(name).getStringValue() : handle.getProperty(name);
            }
            if (value == null) {
                value = StylePropertyMapping.getDefaultValue(name, this.handle);
            }
            this.inheritableReportStyle.setCssText(index, value == null ? null : value.toString());
        } else {
            value = StylePropertyMapping.getDefaultValue(name, this.handle);
            this.nonInheritableReportStyle.setCssText(index, value == null ? null : value.toString());
        }
    }

    protected void createReportDefaultStyles(ReportDesignHandle reportDesignHandle) {
        SharedStyleHandle handle = reportDesignHandle.findStyle("report");
        this.nonInheritableReportStyle = new StyleDeclaration(this.cssEngine);
        this.inheritableReportStyle = new StyleDeclaration(this.cssEngine);
        this.addReportDefaultPropertyValue("backgroundColor", (StyleHandle)handle, true);
        this.addReportDefaultPropertyValue("backgroundImage", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("backgroundPositionX", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("backgroundPositionY", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("backgroundRepeat", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("bidiTextDirection", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("textAlign", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("textIndent", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("letterSpacing", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("lineHeight", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("orphans", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("textTransform", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("verticalAlign", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("whiteSpace", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("widows", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("wordSpacing", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("display", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("masterPage", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("pageBreakAfter", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("pageBreakBefore", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("pageBreakInside", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("fontFamily", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("color", (StyleHandle)handle, true);
        this.addReportDefaultPropertyValue("fontSize", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("fontStyle", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("fontWeight", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("fontVariant", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("textLineThrough", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("textOverline", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("textUnderline", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("borderBottomColor", (StyleHandle)handle, true);
        this.addReportDefaultPropertyValue("borderBottomStyle", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("borderBottomWidth", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("borderLeftColor", (StyleHandle)handle, true);
        this.addReportDefaultPropertyValue("borderLeftStyle", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("borderLeftWidth", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("borderRightColor", (StyleHandle)handle, true);
        this.addReportDefaultPropertyValue("borderRightStyle", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("borderRightWidth", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("borderTopColor", (StyleHandle)handle, true);
        this.addReportDefaultPropertyValue("borderTopStyle", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("borderTopWidth", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("marginTop", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("marginLeft", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("marginBottom", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("marginRight", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("paddingTop", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("paddingLeft", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("paddingBottom", (StyleHandle)handle);
        this.addReportDefaultPropertyValue("paddingRight", (StyleHandle)handle);
        this.createDataFormat((DesignElementHandle)handle, this.nonInheritableReportStyle);
        this.createDataFormat((DesignElementHandle)handle, this.inheritableReportStyle);
        if (!this.inheritableReportStyle.isEmpty()) {
            this.report.setRootStyleName(this.assignStyleName(this.inheritableReportStyle));
        }
    }

    protected String setupBodyStyle(MasterPageDesign design) {
        String styleName = design.getStyleName();
        IStyle style = this.report.findStyle(styleName);
        if (style == null || style.isEmpty()) {
            return null;
        }
        StyleDeclaration contentStyle = new StyleDeclaration(this.cssEngine);
        contentStyle.setProperty(8, style.getProperty(8));
        contentStyle.setProperty(45, style.getProperty(45));
        contentStyle.setProperty(37, style.getProperty(37));
        contentStyle.setProperty(32, style.getProperty(32));
        contentStyle.setProperty(9, style.getProperty(9));
        String bodyStyleName = this.assignStyleName(contentStyle);
        return bodyStyleName;
    }

    private void setupElementIDMap(ReportElementDesign rptElement) {
        this.report.setReportItemInstanceID(rptElement.getID(), rptElement);
    }

    protected long generateUniqueID() {
        --this.newCellId;
        return this.newCellId;
    }

    private List<org.eclipse.birt.report.engine.ir.Expression> createExpression(ExpressionListHandle exprHandles) {
        ArrayList<org.eclipse.birt.report.engine.ir.Expression> listExprs = new ArrayList<org.eclipse.birt.report.engine.ir.Expression>();
        List exprs = exprHandles.getListValue();
        if (exprs != null) {
            for (Expression expr : exprs) {
                org.eclipse.birt.report.engine.ir.Expression expression = this.createExpression(expr);
                if (expression == null) continue;
                listExprs.add(this.createExpression(expr));
            }
        }
        return listExprs;
    }

    private org.eclipse.birt.report.engine.ir.Expression createExpression(Expression expr) {
        if (expr != null) {
            String type = expr.getType();
            if ("constant".equals(type)) {
                String text = expr.getStringExpression();
                return org.eclipse.birt.report.engine.ir.Expression.newConstant(-1, text);
            }
            String text = expr.getStringExpression();
            if (text != null && (text = text.trim()).length() > 0) {
                return org.eclipse.birt.report.engine.ir.Expression.newScript(type, text);
            }
        }
        return null;
    }

    private org.eclipse.birt.report.engine.ir.Expression createExpression(ExpressionHandle expressionHandle) {
        if (expressionHandle != null && expressionHandle.isSet()) {
            String type = expressionHandle.getType();
            if ("constant".equals(type)) {
                String text = expressionHandle.getStringExpression();
                return org.eclipse.birt.report.engine.ir.Expression.newConstant(-1, text);
            }
            String text = expressionHandle.getStringExpression();
            if (text != null && (text = text.trim()).length() > 0) {
                return org.eclipse.birt.report.engine.ir.Expression.newScript(type, text);
            }
        }
        return null;
    }

    private Expression.Script createScript(String script) {
        if (script != null && (script = script.trim()).length() > 0) {
            return org.eclipse.birt.report.engine.ir.Expression.newScript(this.defaultScriptLanguage, script);
        }
        return null;
    }
}

