/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.css;

import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SiblingSelector;

public final class CssUtil {
    public static String toString(LexicalUnit lu) {
        short type = lu.getLexicalUnitType();
        StringBuilder sb = new StringBuilder();
        switch (type) {
            case 0: {
                sb.append(",");
                break;
            }
            case 1: {
                sb.append("+");
                break;
            }
            case 2: {
                sb.append("-");
                break;
            }
            case 3: {
                sb.append("*");
                break;
            }
            case 4: {
                sb.append("/");
                break;
            }
            case 5: {
                sb.append("%");
                break;
            }
            case 6: {
                sb.append("^");
                break;
            }
            case 7: {
                sb.append("<");
                break;
            }
            case 8: {
                sb.append(">");
                break;
            }
            case 9: {
                sb.append("<=");
                break;
            }
            case 10: {
                sb.append(">=");
                break;
            }
            case 11: {
                sb.append("~");
                break;
            }
            case 12: {
                sb.append("inherit");
                break;
            }
            case 13: {
                sb.append(String.valueOf(lu.getIntegerValue()));
                break;
            }
            case 14: {
                sb.append(CssUtil.trimFloat(lu.getFloatValue()));
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 42: {
                sb.append(CssUtil.trimFloat(lu.getFloatValue())).append(lu.getDimensionUnitText());
                break;
            }
            case 24: {
                sb.append("url(").append(lu.getStringValue()).append(")");
                break;
            }
            case 25: {
                sb.append(lu.toString());
                break;
            }
            case 26: {
                sb.append(lu.toString());
                break;
            }
            case 27: {
                sb.append("rgb(");
                sb.append(lu.getParameters());
                sb.append(")");
                break;
            }
            case 35: {
                sb.append(lu.getStringValue());
                break;
            }
            case 36: {
                sb.append("\"").append(lu.getStringValue()).append("\"");
                break;
            }
            case 37: {
                sb.append("attr(");
                sb.append(lu.getParameters());
                sb.append(")");
                break;
            }
            case 38: {
                sb.append("rect(");
                sb.append(lu.getParameters());
                sb.append(")");
                break;
            }
            case 39: {
                sb.append(lu.getStringValue());
                break;
            }
            case 40: {
                sb.append(lu.getStringValue());
                break;
            }
            case 41: {
                sb.append(lu.getFunctionName());
                sb.append(lu.getParameters());
                sb.append(")");
            }
        }
        return sb.toString();
    }

    private static String trimFloat(float f) {
        String s = String.valueOf(f);
        return f - (float)((int)f) != 0.0f ? s : s.substring(0, s.length() - 2);
    }

    public static String toString(Selector selector) {
        if (selector == null) {
            return null;
        }
        switch (selector.getSelectorType()) {
            case 0: {
                assert (selector instanceof ConditionalSelector);
                return String.valueOf(CssUtil.toString((Selector)((ConditionalSelector)selector).getSimpleSelector())) + CssUtil.toString(((ConditionalSelector)selector).getCondition());
            }
            case 4: {
                String localName = ((ElementSelector)selector).getLocalName();
                return localName != null ? localName : "*";
            }
            case 9: {
                String localName = ((ElementSelector)selector).getLocalName();
                return localName != null ? ":" + localName : ":*";
            }
            case 10: {
                assert (selector instanceof DescendantSelector);
                return String.valueOf(CssUtil.toString(((DescendantSelector)selector).getAncestorSelector())) + CssUtil.toString((Selector)((DescendantSelector)selector).getSimpleSelector());
            }
            case 11: {
                assert (selector instanceof DescendantSelector);
                return String.valueOf(CssUtil.toString(((DescendantSelector)selector).getAncestorSelector())) + CssUtil.toString((Selector)((DescendantSelector)selector).getSimpleSelector());
            }
            case 12: {
                assert (selector instanceof SiblingSelector);
                return String.valueOf(CssUtil.toString(((SiblingSelector)selector).getSelector())) + CssUtil.toString((Selector)((SiblingSelector)selector).getSiblingSelector());
            }
        }
        return selector.toString();
    }

    static String toString(Condition condition) {
        if (condition == null) {
            return null;
        }
        switch (condition.getConditionType()) {
            case 0: {
                assert (condition instanceof CombinatorCondition);
                return String.valueOf(CssUtil.toString(((CombinatorCondition)condition).getFirstCondition())) + CssUtil.toString(((CombinatorCondition)condition).getSecondCondition());
            }
            case 4: {
                assert (condition instanceof AttributeCondition);
                String value = ((AttributeCondition)condition).getValue();
                if (value != null) {
                    return "[" + ((AttributeCondition)condition).getLocalName() + "=\"" + value + "\"]";
                }
                return "[" + ((AttributeCondition)condition).getLocalName() + "]";
            }
            case 5: {
                assert (condition instanceof AttributeCondition);
                return "#" + ((AttributeCondition)condition).getValue();
            }
            case 6: {
                assert (condition instanceof LangCondition);
                return ":lang(" + ((LangCondition)condition).getLang() + ")";
            }
            case 7: {
                assert (condition instanceof AttributeCondition);
                return "[" + ((AttributeCondition)condition).getLocalName() + "~=\"" + ((AttributeCondition)condition).getValue() + "\"]";
            }
            case 8: {
                assert (condition instanceof AttributeCondition);
                return "[" + ((AttributeCondition)condition).getLocalName() + "|=\"" + ((AttributeCondition)condition).getValue() + "\"]";
            }
            case 9: {
                assert (condition instanceof AttributeCondition);
                return "." + ((AttributeCondition)condition).getValue();
            }
            case 10: {
                assert (condition instanceof AttributeCondition);
                return ":" + ((AttributeCondition)condition).getValue();
            }
        }
        return condition.toString();
    }
}

