/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.ui.script.launcher;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.List;
import org.eclipse.birt.report.debug.internal.ui.script.util.ScriptDebugUtil;
import org.eclipse.birt.report.debug.ui.DebugUI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jdt.launching.AbstractVMRunner;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public abstract class AbstractScriptVMRunner
extends AbstractVMRunner {
    IVMInstall fVMInstance;

    public AbstractScriptVMRunner(IVMInstall instance) {
        this.fVMInstance = instance;
    }

    protected String getPluginIdentifier() {
        return DebugUI.getUniqueIdentifier();
    }

    public void run(VMRunnerConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
    }

    protected String constructProgramString(VMRunnerConfiguration config) throws CoreException {
        File exe = ScriptDebugUtil.findJavaExecutable(this.fVMInstance.getInstallLocation());
        if (exe == null) {
            throw new Error("not java exe file");
        }
        return exe.getAbsolutePath();
    }

    protected void addArguments(String[] args, List v) {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            v.add(args[i]);
            ++i;
        }
    }

    protected String convertClassPath(String[] cp) {
        int pathCount = 0;
        StringBuilder buf = new StringBuilder();
        if (cp.length == 0) {
            return "";
        }
        int i = 0;
        while (i < cp.length) {
            if (pathCount > 0) {
                buf.append(File.pathSeparator);
            }
            buf.append(cp[i]);
            ++pathCount;
            ++i;
        }
        return buf.toString();
    }

    protected File getWorkingDir(VMRunnerConfiguration config) throws CoreException {
        String path = config.getWorkingDirectory();
        if (path == null) {
            return null;
        }
        File dir = new File(path);
        if (!dir.isDirectory()) {
            throw new Error("Workking directory is null");
        }
        return dir;
    }

    protected static String renderCommandLine(String[] commandLine) {
        if (commandLine.length < 1) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < commandLine.length) {
            buf.append(' ');
            char[] characters = commandLine[i].toCharArray();
            StringBuilder command = new StringBuilder();
            boolean containsSpace = false;
            int j = 0;
            while (j < characters.length) {
                char character = characters[j];
                if (character == '\"') {
                    command.append('\\');
                } else if (character == ' ') {
                    containsSpace = true;
                }
                command.append(character);
                ++j;
            }
            if (containsSpace) {
                buf.append('\"');
                buf.append(command.toString());
                buf.append('\"');
            } else {
                buf.append(command.toString());
            }
            ++i;
        }
        return buf.toString();
    }

    protected static int findFreePort() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException iOException) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return -1;
    }
}

