/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.ui.script.launcher.sourcelookup;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.birt.report.debug.internal.ui.script.launcher.sourcelookup.ScriptDirectorySourceContainer;
import org.eclipse.birt.report.debug.internal.ui.script.util.ScriptDebugUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.StandardSourcePathProvider;

public class ScriptSourcePathComputerDelegate
implements ISourcePathComputerDelegate {
    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IRuntimeClasspathEntry[] entries;
        StandardSourcePathProvider scp;
        IRuntimeClasspathEntry[] resolved;
        ISourceContainer[] cts;
        ArrayList<ScriptDirectorySourceContainer> containers = new ArrayList<ScriptDirectorySourceContainer>();
        String path = this.getPath(configuration);
        if (path != null) {
            containers.add(new ScriptDirectorySourceContainer(new File(path), false));
        }
        if ((cts = JavaRuntime.getSourceContainers((IRuntimeClasspathEntry[])(resolved = (scp = new StandardSourcePathProvider()).resolveClasspath(entries = scp.computeUnresolvedClasspath(configuration), configuration)))) != null) {
            int i = 0;
            while (i < cts.length) {
                containers.add((ScriptDirectorySourceContainer)cts[i]);
                ++i;
            }
        }
        return containers.toArray(new ISourceContainer[containers.size()]);
    }

    private String getFileName(ILaunchConfiguration configuration) {
        String retValue = "";
        try {
            retValue = configuration.getAttribute("report.file.name", "");
        }
        catch (CoreException e) {
            return retValue;
        }
        try {
            retValue = ScriptDebugUtil.getSubstitutedString(retValue);
        }
        catch (CoreException e) {
            return retValue;
        }
        return retValue;
    }

    private String getPath(ILaunchConfiguration configuration) {
        String str = this.getFileName(configuration);
        int index = str.lastIndexOf(File.separator);
        return str.substring(0, index + 1);
    }
}

