/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.spy.event.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.pde.spy.event.internal.core.Messages;
import org.eclipse.pde.spy.event.internal.model.CapturedEvent;
import org.eclipse.pde.spy.event.internal.model.CapturedEventFilter;
import org.eclipse.pde.spy.event.internal.model.ItemToFilter;
import org.eclipse.pde.spy.event.internal.model.Operator;
import org.eclipse.pde.spy.event.internal.model.Parameter;
import org.eclipse.pde.spy.event.internal.model.SpecialValue;

public class CapturedEventFilterMatcher {
    public boolean matches(CapturedEvent event, CapturedEventFilter filter) {
        Object value = this.getItemToFilterValue(event, filter.getItemToFilter());
        if (value instanceof List) {
            List list = (List)value;
            for (Object item : list) {
                if (!this.matches(filter.getValue(), item, filter.getOperator())) continue;
                return true;
            }
            return false;
        }
        return this.matches(filter.getValue(), value, filter.getOperator());
    }

    private Object getItemToFilterValue(CapturedEvent event, ItemToFilter itemToFilter) {
        if (itemToFilter.equals((Object)ItemToFilter.Topic)) {
            return event.getTopic();
        }
        if (itemToFilter.equals((Object)ItemToFilter.Publisher)) {
            return event.getPublisherClassName();
        }
        if (itemToFilter.equals((Object)ItemToFilter.ChangedElement)) {
            return event.getChangedElementClassName();
        }
        if (itemToFilter.equals((Object)ItemToFilter.ParameterName)) {
            ArrayList<String> names = new ArrayList<String>();
            for (Parameter parameter : event.getParameters()) {
                names.add(parameter.getName());
            }
            return names;
        }
        if (itemToFilter.equals((Object)ItemToFilter.ParameterValue)) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (Parameter parameter : event.getParameters()) {
                values.add(parameter.getValue());
            }
            return values;
        }
        if (itemToFilter.equals((Object)ItemToFilter.ParameterNameAndValue)) {
            ArrayList<String> nameAndValues = new ArrayList<String>();
            for (Parameter parameter : event.getParameters()) {
                String nameAndValue = String.format(SpecialValue.NameAndValue.toString(), parameter.getName().trim(), parameter.getValue() == null ? SpecialValue.Null : parameter.getValue().toString().trim());
                nameAndValues.add(nameAndValue);
            }
            return nameAndValues;
        }
        throw new IllegalArgumentException(String.valueOf(Messages.CapturedEventFilterMatcher_NoSupportedItem) + itemToFilter.toString());
    }

    private boolean matches(String expected, Object current, Operator operator) {
        if (SpecialValue.Null.toString().equalsIgnoreCase(expected)) {
            return operator.isPositive() ? this.matchesToNull(current) : !this.matchesToNull(current);
        }
        if (SpecialValue.EmptyString.toString().equalsIgnoreCase(expected)) {
            return operator.isPositive() ? this.matchesToEmptyString(current) : !this.matchesToEmptyString(current);
        }
        if (Operator.Equals.equals((Object)operator)) {
            return this.equalsTo(expected, current);
        }
        if (Operator.NotEquals.equals((Object)operator)) {
            return !this.equalsTo(expected, current);
        }
        if (Operator.Contains.equals((Object)operator)) {
            return this.contains(expected, current);
        }
        if (Operator.NotContains.equals((Object)operator)) {
            return !this.contains(expected, current);
        }
        if (Operator.StartsWith.equals((Object)operator)) {
            return this.startsWith(expected, current);
        }
        if (Operator.NotStartsWith.equals((Object)operator)) {
            return !this.startsWith(expected, current);
        }
        throw new IllegalArgumentException(String.valueOf(Messages.CapturedEventFilterMatcher_NoSupportedOperator) + (Object)((Object)operator));
    }

    private boolean matchesToEmptyString(Object current) {
        return current instanceof String && current.toString().isEmpty();
    }

    private boolean matchesToNull(Object current) {
        return current == null || current.toString().equalsIgnoreCase(SpecialValue.Null.toString());
    }

    private boolean equalsTo(String expected, Object current) {
        return current != null && expected.equalsIgnoreCase(current.toString());
    }

    private boolean contains(String expected, Object current) {
        return current != null && current.toString().toLowerCase().contains(expected.toLowerCase());
    }

    private boolean startsWith(String expected, Object current) {
        return current != null && current.toString().toLowerCase().startsWith(expected.toLowerCase());
    }
}

