/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceFilterDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

final class ResourceFilter {
    private static final String FILTER_ID = "org.eclipse.ui.ide.multiFilter";

    private ResourceFilter() {
    }

    public static void attachFilters(IProject project, List<File> childLocations, IProgressMonitor monitor) {
        monitor = (IProgressMonitor)MoreObjects.firstNonNull((Object)monitor, (Object)new NullProgressMonitor());
        List<FileInfoMatcherDescription> matchers = ResourceFilter.createMatchers(project, childLocations);
        ResourceFilter.setExclusionFilters(project, matchers, monitor);
    }

    private static List<FileInfoMatcherDescription> createMatchers(IProject project, List<File> children) {
        ImmutableList.Builder matchers = ImmutableList.builder();
        IPath projectLocation = project.getLocation();
        for (File child : children) {
            Path childLocation = new Path(child.getAbsolutePath());
            if (!projectLocation.isPrefixOf((IPath)childLocation)) continue;
            matchers.add((Object)new FileInfoMatcherDescription(FILTER_ID, (Object)ResourceFilter.createMultiFilterArgument(childLocation.makeRelativeTo(projectLocation).toPortableString())));
        }
        return matchers.build();
    }

    private static String createMultiFilterArgument(String relativeLocation) {
        return "1.0-projectRelativePath-matches-false-false-" + relativeLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setExclusionFilters(IProject project, List<FileInfoMatcherDescription> matchers, IProgressMonitor monitor) {
        block8: {
            monitor.beginTask(String.format("Set resource filters for project %s", project), -1);
            try {
                IResourceFilterDescription[] existingFilters;
                try {
                    existingFilters = project.getFilters();
                }
                catch (CoreException e) {
                    String message = String.format("Cannot retrieve current resource filters for project %s.", project.getName());
                    throw new GradlePluginsRuntimeException(message, (Exception)((Object)e));
                }
                ImmutableList newMatchers = FluentIterable.from(matchers).filter((Predicate)new Predicate<FileInfoMatcherDescription>(){

                    public boolean apply(FileInfoMatcherDescription matcher) {
                        for (IResourceFilterDescription existingFilter : existingFilters) {
                            if (!existingFilter.getFileInfoMatcherDescription().equals((Object)matcher)) continue;
                            return false;
                        }
                        return true;
                    }
                }).toList();
                if (matchers.isEmpty()) break block8;
                try {
                    int type = 26;
                    for (FileInfoMatcherDescription matcher : newMatchers) {
                        project.createFilter(type, matcher, 128, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (CoreException e) {
                    String message = String.format("Cannot create new resource filters for project %s.", project);
                    throw new GradlePluginsRuntimeException(message, (Exception)((Object)e));
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

