/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingclient.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.gradleware.tooling.toolingclient.BuildActionRequest;
import com.gradleware.tooling.toolingclient.BuildLaunchRequest;
import com.gradleware.tooling.toolingclient.CompositeModelRequest;
import com.gradleware.tooling.toolingclient.Consumer;
import com.gradleware.tooling.toolingclient.GradleBuildIdentifier;
import com.gradleware.tooling.toolingclient.LaunchableConfig;
import com.gradleware.tooling.toolingclient.LongRunningOperationPromise;
import com.gradleware.tooling.toolingclient.ModelRequest;
import com.gradleware.tooling.toolingclient.TestConfig;
import com.gradleware.tooling.toolingclient.TestLaunchRequest;
import com.gradleware.tooling.toolingclient.ToolingClient;
import com.gradleware.tooling.toolingclient.internal.DefaultBuildActionRequest;
import com.gradleware.tooling.toolingclient.internal.DefaultBuildLaunchRequest;
import com.gradleware.tooling.toolingclient.internal.DefaultCompositeModelRequest;
import com.gradleware.tooling.toolingclient.internal.DefaultModelRequest;
import com.gradleware.tooling.toolingclient.internal.DefaultTestLaunchRequest;
import com.gradleware.tooling.toolingclient.internal.ExecutableToolingClient;
import com.gradleware.tooling.toolingclient.internal.InspectableBuildActionRequest;
import com.gradleware.tooling.toolingclient.internal.InspectableBuildLaunchRequest;
import com.gradleware.tooling.toolingclient.internal.InspectableCompositeModelRequest;
import com.gradleware.tooling.toolingclient.internal.InspectableCompositeRequest;
import com.gradleware.tooling.toolingclient.internal.InspectableModelRequest;
import com.gradleware.tooling.toolingclient.internal.InspectableRequest;
import com.gradleware.tooling.toolingclient.internal.InspectableSimpleRequest;
import com.gradleware.tooling.toolingclient.internal.InspectableTestLaunchRequest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.Factory;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.composite.CompositeBuildConnection;
import org.gradle.tooling.composite.CompositeBuildConnector;
import org.gradle.tooling.composite.CompositeParticipant;
import org.gradle.tooling.composite.ModelResult;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.internal.consumer.ConnectorServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultToolingClient
extends ToolingClient
implements ExecutableToolingClient {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultToolingClient.class);
    private final Factory<GradleConnector> connectorFactory;
    private final Map<Integer, ProjectConnection> connections;
    private final Map<Integer, CompositeBuildConnection> compositeConnections;

    public DefaultToolingClient() {
        this(DefaultGradleConnectorFactory.INSTANCE);
    }

    public DefaultToolingClient(Factory<GradleConnector> connectorFactory) {
        this.connectorFactory = connectorFactory;
        this.connections = Maps.newHashMap();
        this.compositeConnections = Maps.newHashMap();
    }

    @Override
    public <T> ModelRequest<T> newModelRequest(Class<T> modelType) {
        Preconditions.checkNotNull(modelType);
        return new DefaultModelRequest<T>(this, modelType);
    }

    @Override
    public <T> BuildActionRequest<T> newBuildActionRequest(BuildAction<T> buildAction) {
        Preconditions.checkNotNull(buildAction);
        return new DefaultBuildActionRequest<T>(this, buildAction);
    }

    @Override
    public BuildLaunchRequest newBuildLaunchRequest(LaunchableConfig launchables) {
        Preconditions.checkNotNull((Object)launchables);
        return new DefaultBuildLaunchRequest(this, launchables);
    }

    @Override
    public TestLaunchRequest newTestLaunchRequest(TestConfig tests) {
        Preconditions.checkNotNull((Object)tests);
        return new DefaultTestLaunchRequest(this, tests);
    }

    @Override
    public <T> CompositeModelRequest<T> newCompositeModelRequest(Class<T> modelType) {
        Preconditions.checkNotNull(modelType);
        return new DefaultCompositeModelRequest<T>(this, modelType);
    }

    @Override
    public <T> T executeAndWait(InspectableModelRequest<T> modelRequest) {
        ProjectConnection connection = this.getProjectConnection(modelRequest);
        ModelBuilder<T> operation = this.mapToModelBuilder(modelRequest, connection);
        return (T)operation.get();
    }

    @Override
    public <T> LongRunningOperationPromise<T> execute(InspectableModelRequest<T> modelRequest) {
        ProjectConnection connection = this.getProjectConnection(modelRequest);
        ModelBuilder<T> operation = this.mapToModelBuilder(modelRequest, connection);
        return LongRunningOperationPromise.forModelBuilder(operation);
    }

    @Override
    public <T> T executeAndWait(InspectableBuildActionRequest<T> buildActionRequest) {
        ProjectConnection connection = this.getProjectConnection(buildActionRequest);
        BuildActionExecuter<T> operation = this.mapToBuildActionExecuter(buildActionRequest, connection);
        return (T)operation.run();
    }

    @Override
    public <T> LongRunningOperationPromise<T> execute(InspectableBuildActionRequest<T> buildActionRequest) {
        ProjectConnection connection = this.getProjectConnection(buildActionRequest);
        BuildActionExecuter<T> operation = this.mapToBuildActionExecuter(buildActionRequest, connection);
        return LongRunningOperationPromise.forBuildActionExecuter(operation);
    }

    @Override
    public Void executeAndWait(InspectableBuildLaunchRequest buildLaunchRequest) {
        ProjectConnection connection = this.getProjectConnection(buildLaunchRequest);
        BuildLauncher operation = this.mapToBuildLauncher(buildLaunchRequest, connection);
        operation.run();
        return null;
    }

    @Override
    public LongRunningOperationPromise<Void> execute(InspectableBuildLaunchRequest buildLaunchRequest) {
        ProjectConnection connection = this.getProjectConnection(buildLaunchRequest);
        BuildLauncher operation = this.mapToBuildLauncher(buildLaunchRequest, connection);
        return LongRunningOperationPromise.forBuildLauncher(operation);
    }

    @Override
    public Void executeAndWait(InspectableTestLaunchRequest testLaunchRequest) {
        ProjectConnection connection = this.getProjectConnection(testLaunchRequest);
        TestLauncher operation = this.mapToTestLauncher(testLaunchRequest, connection);
        operation.run();
        return null;
    }

    @Override
    public LongRunningOperationPromise<Void> execute(InspectableTestLaunchRequest testLaunchRequest) {
        ProjectConnection connection = this.getProjectConnection(testLaunchRequest);
        TestLauncher operation = this.mapToTestLauncher(testLaunchRequest, connection);
        return LongRunningOperationPromise.forTestLauncher(operation);
    }

    @Override
    public <T> LongRunningOperationPromise<Set<T>> execute(InspectableCompositeModelRequest<T> modelRequest) {
        CompositeBuildConnection connection = this.getOrCreateCompositeConnection(modelRequest);
        ModelBuilder<Set<ModelResult<T>>> modelBuilder = this.mapToModelBuilder(modelRequest, connection);
        return this.unwrapModelResults(LongRunningOperationPromise.forModelBuilder(modelBuilder));
    }

    @Override
    public <T> Set<T> executeAndWait(InspectableCompositeModelRequest<T> modelRequest) {
        CompositeBuildConnection connection = this.getOrCreateCompositeConnection(modelRequest);
        ModelBuilder<Set<ModelResult<T>>> modelBuilder = this.mapToModelBuilder(modelRequest, connection);
        Set modelResults = (Set)modelBuilder.get();
        return this.unwrapModelResults(modelResults);
    }

    private <T> LongRunningOperationPromise<Set<T>> unwrapModelResults(final LongRunningOperationPromise<Set<ModelResult<T>>> delegate) {
        return new LongRunningOperationPromise<Set<T>>(){

            @Override
            public LongRunningOperationPromise<Set<T>> onComplete(final Consumer<? super Set<T>> completeHandler) {
                Consumer unwrappingHandler = new Consumer<Set<ModelResult<T>>>(){

                    @Override
                    public void accept(Set<ModelResult<T>> input) {
                        completeHandler.accept(DefaultToolingClient.this.unwrapModelResults(input));
                    }
                };
                delegate.onComplete(unwrappingHandler);
                return this;
            }

            @Override
            public LongRunningOperationPromise<Set<T>> onFailure(Consumer<? super GradleConnectionException> failureHandler) {
                delegate.onFailure(failureHandler);
                return this;
            }
        };
    }

    private <T> Set<T> unwrapModelResults(Set<ModelResult<T>> modelResults) {
        HashSet results = Sets.newHashSet();
        for (ModelResult<T> modelResult : modelResults) {
            results.add(modelResult.getModel());
        }
        return results;
    }

    private ProjectConnection getProjectConnection(InspectableSimpleRequest<?> request) {
        Preconditions.checkNotNull(request);
        return this.getOrCreateProjectConnection(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectConnection getOrCreateProjectConnection(InspectableSimpleRequest<?> modelRequest) {
        ProjectConnection connection;
        int connectionKey = this.calculateConnectionKey(modelRequest);
        Map<Integer, ProjectConnection> map = this.connections;
        synchronized (map) {
            if (!this.connections.containsKey(connectionKey)) {
                connection = this.openConnection(modelRequest);
                this.connections.put(connectionKey, connection);
            } else {
                connection = this.connections.get(connectionKey);
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompositeBuildConnection getOrCreateCompositeConnection(InspectableCompositeRequest<?> compositeRequest) {
        CompositeBuildConnection connection;
        int connectionKey = this.calculateCompositeConnectionKey(compositeRequest);
        Map<Integer, CompositeBuildConnection> map = this.compositeConnections;
        synchronized (map) {
            if (!this.compositeConnections.containsKey(connectionKey)) {
                connection = this.openCompositeConnection(compositeRequest);
                this.compositeConnections.put(connectionKey, connection);
            } else {
                connection = this.compositeConnections.get(connectionKey);
            }
        }
        return connection;
    }

    private int calculateConnectionKey(InspectableSimpleRequest<?> modelRequest) {
        return Objects.hashCode((Object[])new Object[]{modelRequest.getProjectDir(), modelRequest.getGradleUserHomeDir(), modelRequest.getGradleDistribution()});
    }

    private int calculateCompositeConnectionKey(InspectableCompositeRequest<?> compositeRequest) {
        ArrayList connectionProperties = Lists.newArrayList();
        for (GradleBuildIdentifier identifier : compositeRequest.getParticipants()) {
            connectionProperties.add(identifier.getProjectDir());
            connectionProperties.add(identifier.getGradleDistribution());
        }
        return ((Object)connectionProperties).hashCode();
    }

    private ProjectConnection openConnection(InspectableSimpleRequest<?> modelRequest) {
        GradleConnector connector = (GradleConnector)this.connectorFactory.create();
        connector.forProjectDirectory(modelRequest.getProjectDir());
        connector.useGradleUserHomeDir(modelRequest.getGradleUserHomeDir());
        modelRequest.getGradleDistribution().apply(connector);
        return connector.connect();
    }

    private CompositeBuildConnection openCompositeConnection(InspectableCompositeRequest<?> compositeRequest) {
        if (compositeRequest.getParticipants().length == 0) {
            throw new IllegalArgumentException("There must be at least one participant in a composite build");
        }
        CompositeBuildConnector connector = CompositeBuildConnector.newComposite();
        for (GradleBuildIdentifier identifier : compositeRequest.getParticipants()) {
            CompositeParticipant participant = connector.addParticipant(identifier.getProjectDir());
            identifier.getGradleDistribution().apply(participant);
        }
        return connector.connect();
    }

    private <T> ModelBuilder<T> mapToModelBuilder(InspectableModelRequest<T> modelRequest, ProjectConnection connection) {
        ModelBuilder modelBuilder = connection.model(modelRequest.getModelType());
        modelBuilder.forTasks(modelRequest.getTasks());
        return this.mapToLongRunningOperation(modelRequest, modelBuilder);
    }

    private <T> ModelBuilder<Set<ModelResult<T>>> mapToModelBuilder(InspectableCompositeModelRequest<T> modelRequest, CompositeBuildConnection connection) {
        ModelBuilder<Set<ModelResult<T>>> modelBuilder = connection.models(modelRequest.getModelType());
        return this.mapToBasicLongRunningOperation((InspectableRequest<?>)modelRequest, (T)modelBuilder);
    }

    private <T> BuildActionExecuter<T> mapToBuildActionExecuter(InspectableBuildActionRequest<T> buildActionRequest, ProjectConnection connection) {
        BuildActionExecuter buildActionExecuter = connection.action(buildActionRequest.getBuildAction());
        return this.mapToLongRunningOperation(buildActionRequest, buildActionExecuter);
    }

    private BuildLauncher mapToBuildLauncher(InspectableBuildLaunchRequest buildLaunchRequest, ProjectConnection connection) {
        BuildLauncher buildLauncher = connection.newBuild();
        buildLaunchRequest.getLaunchables().apply(buildLauncher);
        return this.mapToLongRunningOperation(buildLaunchRequest, buildLauncher);
    }

    private TestLauncher mapToTestLauncher(InspectableTestLaunchRequest testLaunchRequest, ProjectConnection connection) {
        TestLauncher testLauncher = connection.newTestLauncher();
        testLaunchRequest.getTests().apply(testLauncher);
        return this.mapToLongRunningOperation(testLaunchRequest, testLauncher);
    }

    private <T extends LongRunningOperation> T mapToLongRunningOperation(InspectableRequest<?> request, T operation) {
        this.mapToBasicLongRunningOperation(request, operation).setColorOutput(request.isColorOutput()).setStandardOutput(request.getStandardOutput()).setStandardError(request.getStandardError()).setStandardInput(request.getStandardInput()).setJavaHome(request.getJavaHomeDir()).setJvmArguments(request.getJvmArguments()).withArguments(request.getArguments());
        return operation;
    }

    private <T extends LongRunningOperation> T mapToBasicLongRunningOperation(InspectableRequest<?> request, T operation) {
        operation.withCancellationToken(request.getCancellationToken());
        for (org.gradle.tooling.ProgressListener progressListener : request.getProgressListeners()) {
            operation.addProgressListener(progressListener);
        }
        for (org.gradle.tooling.ProgressListener progressListener : request.getTypedProgressListeners()) {
            operation.addProgressListener((ProgressListener)progressListener);
        }
        return operation;
    }

    @Override
    public void stop(ToolingClient.CleanUpStrategy strategy) {
        switch (strategy) {
            case FORCEFULLY: {
                throw new UnsupportedOperationException(String.format("Cleanup strategy %s is currently not supported.", new Object[]{ToolingClient.CleanUpStrategy.FORCEFULLY}));
            }
            case GRACEFULLY: {
                this.closeConnections();
                this.expireDaemons();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnections() {
        Map<Integer, Object> map = this.connections;
        synchronized (map) {
            for (ProjectConnection projectConnection : this.connections.values()) {
                try {
                    projectConnection.close();
                }
                catch (Exception e) {
                    LOG.warn("Problem closing the connection: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        map = this.compositeConnections;
        synchronized (map) {
            for (CompositeBuildConnection compositeBuildConnection : this.compositeConnections.values()) {
                try {
                    compositeBuildConnection.close();
                }
                catch (Exception e) {
                    LOG.warn("Problem closing the composite connection: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void expireDaemons() {
        ConnectorServices.reset();
    }

    private static enum DefaultGradleConnectorFactory implements Factory<GradleConnector>
    {
        INSTANCE;


        public GradleConnector create() {
            return GradleConnector.newConnector();
        }
    }
}

