/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository.internal;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniEclipseWorkspace;
import java.util.List;
import org.gradle.api.specs.Spec;

public final class DefaultOmniEclipseWorkspace
implements OmniEclipseWorkspace {
    private final ImmutableList<OmniEclipseProject> eclipseProjects;

    private DefaultOmniEclipseWorkspace(List<OmniEclipseProject> eclipseProjects) {
        this.eclipseProjects = ImmutableList.copyOf(eclipseProjects);
    }

    @Override
    public List<OmniEclipseProject> getOpenEclipseProjects() {
        return this.eclipseProjects;
    }

    @Override
    public Optional<OmniEclipseProject> tryFind(Spec<? super OmniEclipseProject> predicate) {
        return Iterables.tryFind(this.eclipseProjects, this.toPredicate(predicate));
    }

    @Override
    public List<OmniEclipseProject> filter(Spec<? super OmniEclipseProject> predicate) {
        return FluentIterable.from(this.eclipseProjects).filter(this.toPredicate(predicate)).toList();
    }

    private <T> Predicate<? super T> toPredicate(final Spec<? super T> spec) {
        return new Predicate<T>(){

            public boolean apply(T input) {
                return spec.isSatisfiedBy(input);
            }
        };
    }

    public static OmniEclipseWorkspace from(List<OmniEclipseProject> eclipseProjects) {
        return new DefaultOmniEclipseWorkspace(eclipseProjects);
    }
}

