/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.launch;

import com.google.common.base.Preconditions;
import com.gradleware.tooling.toolingclient.TestConfig;
import org.eclipse.buildship.core.launch.TestTarget;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;

public final class TestMethod
implements TestTarget {
    private final IMethod method;

    private TestMethod(IMethod method) {
        this.method = (IMethod)Preconditions.checkNotNull((Object)method);
    }

    @Override
    public String getSimpleName() {
        IType declaringType = this.method.getDeclaringType();
        return declaringType.getElementName() + "#" + this.method.getElementName();
    }

    @Override
    public String getQualifiedName() {
        IType declaringType = this.method.getDeclaringType();
        return declaringType.getFullyQualifiedName() + "#" + this.method.getElementName();
    }

    @Override
    public void apply(TestConfig.Builder testConfig) {
        IType declaringType = this.method.getDeclaringType();
        String typeName = declaringType.getFullyQualifiedName();
        String methodName = this.method.getElementName();
        testConfig.jvmTestMethods(typeName, new String[]{methodName});
    }

    public static TestMethod from(IMethod method) {
        return new TestMethod(method);
    }
}

