/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

final class StringSetProjectProperty {
    private final IProject project;
    private final String propertyName;

    private StringSetProjectProperty(IProject project, String propertyName) {
        this.project = (IProject)Preconditions.checkNotNull((Object)project);
        this.propertyName = (String)Preconditions.checkNotNull((Object)propertyName);
    }

    public Set<String> get() {
        ProjectScope projectScope = new ProjectScope(this.project);
        IEclipsePreferences node = projectScope.getNode("org.eclipse.buildship.core");
        String valueString = node.get(this.propertyName, "");
        return valueString.equals("") ? ImmutableSet.of() : ImmutableSet.copyOf((Iterable)Splitter.on((char)',').split((CharSequence)valueString));
    }

    public void set(Set<String> entries) {
        ProjectScope projectScope = new ProjectScope(this.project);
        IEclipsePreferences node = projectScope.getNode("org.eclipse.buildship.core");
        if (entries.isEmpty()) {
            node.remove(this.propertyName);
        } else {
            String updateString = Joiner.on((char)',').join(entries);
            node.put(this.propertyName, updateString);
        }
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            throw new GradlePluginsRuntimeException(e);
        }
    }

    public static StringSetProjectProperty from(IProject project, String propertyName) {
        return new StringSetProjectProperty(project, propertyName);
    }
}

