/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.util.editor;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.ui.UiPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public final class EditorUtils {
    private EditorUtils() {
    }

    public static IEditorPart openInInternalEditor(IFile file, boolean activate) {
        IEditorDescriptor desc;
        try {
            desc = IDE.getEditorDescriptor((IFile)file);
        }
        catch (PartInitException e1) {
            desc = null;
        }
        String editorId = EditorUtils.getInternalEditorId(desc);
        try {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            return IDE.openEditor((IWorkbenchPage)activePage, (IFile)file, (String)editorId, (boolean)activate);
        }
        catch (PartInitException e) {
            String message = String.format("Cannot open file %s in editor.", file.getFullPath());
            UiPlugin.logger().error(message, (Throwable)e);
            throw new GradlePluginsRuntimeException(message, (Throwable)e);
        }
    }

    public static IEditorPart openInInternalEditor(File file, boolean activate) {
        IEditorDescriptor desc;
        try {
            desc = IDE.getEditorDescriptor((String)file.getName());
        }
        catch (PartInitException e1) {
            desc = null;
        }
        String editorId = EditorUtils.getInternalEditorId(desc);
        try {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            return IDE.openEditor((IWorkbenchPage)activePage, (URI)file.toURI(), (String)editorId, (boolean)activate);
        }
        catch (PartInitException e) {
            String message = String.format("Cannot open file %s in editor.", file.getAbsolutePath());
            UiPlugin.logger().error(message, (Throwable)e);
            throw new GradlePluginsRuntimeException(message, (Throwable)e);
        }
    }

    private static String getInternalEditorId(IEditorDescriptor desc) {
        String editorId = desc == null || !desc.isInternal() ? "org.eclipse.ui.DefaultTextEditor" : desc.getId();
        return editorId;
    }

    public static void selectAndReveal(int offset, int length, IEditorPart editor, IFile file) {
        if (editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            textEditor.selectAndReveal(offset, length);
        } else {
            EditorUtils.showWithMarker(editor, file, offset, length);
        }
    }

    private static void showWithMarker(IEditorPart editor, IFile file, int offset, int length) {
        IMarker marker = null;
        try {
            Bundle bundle = FrameworkUtil.getBundle(EditorUtils.class);
            marker = file.createMarker(bundle.getSymbolicName() + "navigationmarker");
            HashMap<String, Integer> attributes = new HashMap<String, Integer>(4);
            attributes.put("charStart", offset);
            attributes.put("charEnd", offset + length);
            marker.setAttributes(attributes);
            IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
        }
        catch (CoreException e) {
            String message = String.format("Cannot set marker in file %s.", file.getFullPath());
            UiPlugin.logger().error(message, (Throwable)e);
            throw new GradlePluginsRuntimeException(message, (Throwable)e);
        }
        finally {
            if (marker != null) {
                try {
                    marker.delete();
                }
                catch (CoreException e) {}
            }
        }
    }
}

