/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.UnsupportedConfigurationException;
import org.eclipse.buildship.core.internal.util.gradle.GradleVersion;
import org.eclipse.buildship.core.internal.util.gradle.IdeFriendlyClassLoading;
import org.eclipse.buildship.core.internal.util.gradle.SimpleIntermediateResultHandler;
import org.eclipse.buildship.core.internal.workspace.DefaultEclipseWorkspace;
import org.eclipse.buildship.core.internal.workspace.DefaultEclipseWorkspaceProject;
import org.eclipse.buildship.core.internal.workspace.EclipseRuntimeConfigurer;
import org.eclipse.buildship.core.internal.workspace.TellGradleToRunSynchronizationTasks;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionFailureException;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.eclipse.EclipseRuntime;
import org.gradle.tooling.model.eclipse.EclipseWorkspaceProject;

public final class EclipseModelUtils {
    private static final String EXCEPTION_DUPLICATE_ROOT_ELEMENT_TEXT = "Duplicate root element ";

    private EclipseModelUtils() {
    }

    public static Collection<EclipseProject> queryModels(ProjectConnection connection) {
        BuildEnvironment buildEnvironment = (BuildEnvironment)connection.getModel(BuildEnvironment.class);
        GradleVersion gradleVersion = GradleVersion.version(buildEnvironment.getGradle().getGradleVersion());
        if (EclipseModelUtils.supportsSendingReservedProjects(gradleVersion)) {
            return EclipseModelUtils.queryCompositeModelWithRuntimInfo(connection, gradleVersion);
        }
        if (EclipseModelUtils.supportsCompositeBuilds(gradleVersion)) {
            return EclipseModelUtils.queryCompositeModel(EclipseProject.class, connection);
        }
        return ImmutableList.of((Object)EclipseModelUtils.queryModel(EclipseProject.class, connection));
    }

    public static Collection<EclipseProject> runTasksAndQueryModels(ProjectConnection connection) {
        BuildEnvironment buildEnvironment = (BuildEnvironment)connection.getModel(BuildEnvironment.class);
        GradleVersion gradleVersion = GradleVersion.version(buildEnvironment.getGradle().getGradleVersion());
        if (EclipseModelUtils.supportsSendingReservedProjects(gradleVersion)) {
            return EclipseModelUtils.runTasksAndQueryCompositeModelWithRuntimInfo(connection, gradleVersion);
        }
        if (EclipseModelUtils.supportsSyncTasksInEclipsePluginConfig(gradleVersion)) {
            return EclipseModelUtils.runTasksAndQueryCompositeModel(connection, gradleVersion);
        }
        if (EclipseModelUtils.supportsCompositeBuilds(gradleVersion)) {
            return EclipseModelUtils.queryCompositeModel(EclipseProject.class, connection);
        }
        return ImmutableList.of((Object)EclipseModelUtils.queryModel(EclipseProject.class, connection));
    }

    public static EclipseRuntimeConfigurer buildEclipseRuntimeConfigurer() {
        ImmutableList<IProject> allWorkspaceProjects = CorePlugin.workspaceOperations().getAllProjects();
        List<EclipseWorkspaceProject> projects = allWorkspaceProjects.stream().map(p -> new DefaultEclipseWorkspaceProject(p.getName(), p.getLocation().toFile())).collect(Collectors.toList());
        return new EclipseRuntimeConfigurer(new DefaultEclipseWorkspace(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), projects));
    }

    private static boolean supportsSendingReservedProjects(GradleVersion gradleVersion) {
        return gradleVersion.getBaseVersion().compareTo(GradleVersion.version("5.5")) >= 0;
    }

    private static boolean supportsSyncTasksInEclipsePluginConfig(GradleVersion gradleVersion) {
        return gradleVersion.getBaseVersion().compareTo(GradleVersion.version("5.4")) >= 0;
    }

    private static boolean supportsCompositeBuilds(GradleVersion gradleVersion) {
        return gradleVersion.getBaseVersion().compareTo(GradleVersion.version("3.3")) >= 0;
    }

    private static Collection<EclipseProject> runTasksAndQueryCompositeModelWithRuntimInfo(ProjectConnection connection, GradleVersion gradleVersion) {
        try {
            return EclipseModelUtils.runTasksAndQueryCompositeModel(connection, gradleVersion, IdeFriendlyClassLoading.loadCompositeModelQuery(EclipseProject.class, EclipseRuntime.class, EclipseModelUtils.buildEclipseRuntimeConfigurer()));
        }
        catch (BuildActionFailureException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IllegalArgumentException && cause.getMessage().startsWith(EXCEPTION_DUPLICATE_ROOT_ELEMENT_TEXT)) {
                String projectName = cause.getMessage().substring(EXCEPTION_DUPLICATE_ROOT_ELEMENT_TEXT.length());
                String message = String.format("A project with the name %s already exists.", projectName);
                throw new UnsupportedConfigurationException(message, e);
            }
            throw e;
        }
    }

    private static Collection<EclipseProject> runTasksAndQueryCompositeModel(ProjectConnection connection, GradleVersion gradleVersion) {
        return EclipseModelUtils.runTasksAndQueryCompositeModel(connection, gradleVersion, IdeFriendlyClassLoading.loadCompositeModelQuery(EclipseProject.class));
    }

    private static Collection<EclipseProject> runTasksAndQueryCompositeModel(ProjectConnection connection, GradleVersion gradleVersion, BuildAction<Collection<EclipseProject>> query) {
        SimpleIntermediateResultHandler resultHandler = new SimpleIntermediateResultHandler();
        BuildAction projectsLoadedAction = IdeFriendlyClassLoading.loadClass(TellGradleToRunSynchronizationTasks.class);
        connection.action().projectsLoaded(projectsLoadedAction, new SimpleIntermediateResultHandler()).buildFinished(query, resultHandler).build().forTasks(new String[0]).run();
        return (Collection)resultHandler.getValue();
    }

    private static Collection<EclipseProject> queryCompositeModelWithRuntimInfo(ProjectConnection connection, GradleVersion gradleVersion) {
        BuildAction<Collection<EclipseProject>> query = IdeFriendlyClassLoading.loadCompositeModelQuery(EclipseProject.class, EclipseRuntime.class, EclipseModelUtils.buildEclipseRuntimeConfigurer());
        return (Collection)connection.action(query).run();
    }

    private static <T> Collection<T> queryCompositeModel(Class<T> model, ProjectConnection connection) {
        BuildAction<Collection<T>> query = IdeFriendlyClassLoading.loadCompositeModelQuery(model);
        return (Collection)connection.action(query).run();
    }

    private static <T> T queryModel(Class<T> model, ProjectConnection connection) {
        return (T)connection.getModel(model);
    }
}

