/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.InitializationContext;
import org.eclipse.buildship.core.ProjectContext;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.extension.InternalProjectConfigurator;
import org.eclipse.buildship.core.internal.extension.ProjectConfiguratorContribution;
import org.eclipse.buildship.core.internal.util.gradle.Pair;
import org.eclipse.buildship.core.internal.workspace.InternalGradleBuild;
import org.eclipse.buildship.core.internal.workspace.SynchronizationProblem;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public final class ProjectConfigurators {
    private final InternalGradleBuild gradleBuild;
    private final List<InternalProjectConfigurator> contributions;

    private ProjectConfigurators(InternalGradleBuild gradleBuild, List<InternalProjectConfigurator> contributions) {
        this.gradleBuild = gradleBuild;
        this.contributions = contributions;
    }

    List<SynchronizationProblem> initConfigurators(IProgressMonitor monitor) {
        ArrayList<SynchronizationProblem> result = new ArrayList<SynchronizationProblem>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.setWorkRemaining(this.contributions.size());
        for (InternalProjectConfigurator contribution : this.contributions) {
            DefaultInitializationContext context = ProjectConfigurators.newInitializationContext(this.gradleBuild);
            try {
                contribution.init(context, (IProgressMonitor)progress.newChild(1));
                context.getErrors().forEach(e -> result.add(SynchronizationProblem.newError(contribution.getContributorPluginId(), this.markerLocation(), (String)e.getFirst(), (Exception)e.getSecond())));
                context.getWarnings().forEach(e -> result.add(SynchronizationProblem.newWarning(contribution.getContributorPluginId(), this.markerLocation(), (String)e.getFirst(), (Exception)e.getSecond())));
            }
            catch (Exception e2) {
                result.add(SynchronizationProblem.newError(contribution.getContributorPluginId(), this.markerLocation(), this.configuratorFailedMessage(contribution, e2, "initialize"), e2));
            }
        }
        return result;
    }

    List<SynchronizationProblem> configureConfigurators(IProject project, IProgressMonitor monitor) {
        ArrayList<SynchronizationProblem> result = new ArrayList<SynchronizationProblem>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.setWorkRemaining(this.contributions.size());
        for (InternalProjectConfigurator contribution : this.contributions) {
            DefaultProjectContext context = ProjectConfigurators.newProjectContext(project);
            try {
                contribution.configure(context, (IProgressMonitor)progress.newChild(1));
                context.getErrors().forEach(e -> result.add(SynchronizationProblem.newError(contribution.getContributorPluginId(), this.markerLocation(), (String)e.getFirst(), (Exception)e.getSecond())));
                context.getWarnings().forEach(e -> result.add(SynchronizationProblem.newWarning(contribution.getContributorPluginId(), this.markerLocation(), (String)e.getFirst(), (Exception)e.getSecond())));
            }
            catch (Exception e2) {
                result.add(SynchronizationProblem.newError(contribution.getContributorPluginId(), (IResource)project, this.configuratorFailedMessage(contribution, e2, "configure project '" + project.getName() + "'"), e2));
            }
        }
        return result;
    }

    List<SynchronizationProblem> unconfigureConfigurators(IProject project, IProgressMonitor monitor) {
        ArrayList<SynchronizationProblem> result = new ArrayList<SynchronizationProblem>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.setWorkRemaining(this.contributions.size());
        for (InternalProjectConfigurator contribution : this.contributions) {
            DefaultProjectContext context = ProjectConfigurators.newProjectContext(project);
            try {
                contribution.unconfigure(context, (IProgressMonitor)progress.newChild(1));
                context.getErrors().forEach(e -> result.add(SynchronizationProblem.newError(contribution.getContributorPluginId(), this.markerLocation(), (String)e.getFirst(), (Exception)e.getSecond())));
                context.getWarnings().forEach(e -> result.add(SynchronizationProblem.newWarning(contribution.getContributorPluginId(), this.markerLocation(), (String)e.getFirst(), (Exception)e.getSecond())));
            }
            catch (Exception e2) {
                result.add(SynchronizationProblem.newError(contribution.getContributorPluginId(), this.markerLocation(), this.configuratorFailedMessage(contribution, e2, "unconfigure project '" + project.getName() + "'"), e2));
            }
        }
        return result;
    }

    public static ProjectConfigurators create(InternalGradleBuild gradleBuild, List<ProjectConfiguratorContribution> configurators) {
        return new ProjectConfigurators(gradleBuild, InternalProjectConfigurator.from(configurators));
    }

    private static DefaultInitializationContext newInitializationContext(InternalGradleBuild gradleBuild) {
        return new DefaultInitializationContext(gradleBuild);
    }

    private static DefaultProjectContext newProjectContext(IProject project) {
        return new DefaultProjectContext(project);
    }

    private String configuratorFailedMessage(InternalProjectConfigurator contribution, Exception exception, String operationName) {
        return String.format("Project configurator '%s' failed to %s", contribution.getId(), operationName);
    }

    private IResource markerLocation() {
        Optional<IProject> projectOrNull = CorePlugin.workspaceOperations().findProjectByLocation(this.gradleBuild.getBuildConfig().getRootProjectDirectory());
        return projectOrNull.isPresent() ? (IResource)projectOrNull.get() : ResourcesPlugin.getWorkspace().getRoot();
    }

    private static class BaseContext {
        protected final List<Pair<String, Exception>> errors = new ArrayList<Pair<String, Exception>>();
        protected final List<Pair<String, Exception>> warnings = new ArrayList<Pair<String, Exception>>();

        private BaseContext() {
        }

        public List<Pair<String, Exception>> getErrors() {
            return this.errors;
        }

        public List<Pair<String, Exception>> getWarnings() {
            return this.warnings;
        }

        public void error(String message, Exception exception) {
            this.errors.add(new Pair<String, Exception>(message, exception));
        }

        public void warning(String message, Exception exception) {
            this.warnings.add(new Pair<String, Exception>(message, exception));
        }
    }

    private static class DefaultInitializationContext
    extends BaseContext
    implements InitializationContext {
        private final InternalGradleBuild gradleBuild;

        DefaultInitializationContext(InternalGradleBuild gradleBuild) {
            this.gradleBuild = gradleBuild;
        }

        @Override
        public GradleBuild getGradleBuild() {
            return this.gradleBuild;
        }
    }

    private static class DefaultProjectContext
    extends BaseContext
    implements ProjectContext {
        private final IProject project;

        DefaultProjectContext(IProject project) {
            this.project = project;
        }

        @Override
        public IProject getProject() {
            return this.project;
        }
    }
}

