/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URLClassLoader;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.configuration.GradleArguments;
import org.eclipse.buildship.core.internal.gradle.GradleProgressAttributes;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.model.build.BuildEnvironment;

public final class ConnectionAwareLauncherProxy
implements InvocationHandler {
    private final LongRunningOperation launcher;
    private final ProjectConnection connection;
    private static URLClassLoader ideFriendlyCustomActionClassLoader;

    private ConnectionAwareLauncherProxy(ProjectConnection connection, LongRunningOperation target) {
        this.connection = connection;
        this.launcher = target;
    }

    public static BuildLauncher newBuildLauncher(GradleArguments gradleArguments, GradleProgressAttributes progressAttributes) {
        ProjectConnection connection = ConnectionAwareLauncherProxy.openConnection(gradleArguments);
        BuildEnvironment buildEnvironment = (BuildEnvironment)connection.getModel(BuildEnvironment.class);
        BuildLauncher launcher = connection.newBuild();
        ConnectionAwareLauncherProxy.describeAndApplyConfiguration((LongRunningOperation)launcher, gradleArguments, buildEnvironment, progressAttributes);
        return (BuildLauncher)ConnectionAwareLauncherProxy.newProxyInstance(connection, (LongRunningOperation)launcher);
    }

    public static TestLauncher newTestLauncher(GradleArguments gradleArguments, GradleProgressAttributes progressAttributes) {
        ProjectConnection connection = ConnectionAwareLauncherProxy.openConnection(gradleArguments);
        BuildEnvironment buildEnvironment = (BuildEnvironment)connection.getModel(BuildEnvironment.class);
        TestLauncher launcher = connection.newTestLauncher();
        ConnectionAwareLauncherProxy.describeAndApplyConfiguration((LongRunningOperation)launcher, gradleArguments, buildEnvironment, progressAttributes);
        return (TestLauncher)ConnectionAwareLauncherProxy.newProxyInstance(connection, (LongRunningOperation)launcher);
    }

    private static ProjectConnection openConnection(GradleArguments gradleArguments) {
        GradleConnector connector = GradleConnector.newConnector();
        gradleArguments.applyTo(connector);
        return connector.connect();
    }

    private static void describeAndApplyConfiguration(LongRunningOperation operation, GradleArguments gradleArguments, BuildEnvironment buildEnvironment, GradleProgressAttributes progressAttributes) {
        gradleArguments.applyTo(operation, buildEnvironment);
        gradleArguments.describe(progressAttributes, buildEnvironment);
        progressAttributes.applyTo(operation);
    }

    private static Object newProxyInstance(ProjectConnection connection, LongRunningOperation launcher) {
        return Proxy.newProxyInstance(launcher.getClass().getClassLoader(), launcher.getClass().getInterfaces(), (InvocationHandler)new ConnectionAwareLauncherProxy(connection, launcher));
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (m.getName().equals("run") || m.getName().equals("get")) {
            if (args == null) {
                return this.invokeRun(m);
            }
            if (args.length == 1 && args[0].getClass() == ResultHandler.class) {
                return this.invokeRun(m, args[0]);
            }
        }
        return this.invokeOther(m, args);
    }

    private Object invokeRun(Method m) throws Throwable {
        try {
            Object object = m.invoke((Object)this.launcher, new Object[0]);
            return object;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    private Object invokeRun(Method m, Object resultHandler) throws Throwable {
        final ResultHandler handler = (ResultHandler)resultHandler;
        return m.invoke((Object)this.launcher, new ResultHandler<Object>(){

            public void onComplete(Object result) {
                try {
                    handler.onComplete(result);
                }
                finally {
                    ConnectionAwareLauncherProxy.this.closeConnection();
                }
            }

            public void onFailure(GradleConnectionException e) {
                try {
                    handler.onFailure(e);
                }
                finally {
                    ConnectionAwareLauncherProxy.this.closeConnection();
                }
            }
        });
    }

    private void closeConnection() {
        this.connection.close();
        if (ideFriendlyCustomActionClassLoader != null) {
            try {
                ideFriendlyCustomActionClassLoader.close();
            }
            catch (IOException e) {
                CorePlugin.logger().error("Can't close URL class loader", e);
            }
        }
    }

    private Object invokeOther(Method m, Object[] args) throws Throwable {
        return m.invoke((Object)this.launcher, args);
    }
}

