/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.task;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.ui.internal.view.task.BaseProjectNode;
import org.eclipse.buildship.ui.internal.view.task.BuildNode;
import org.eclipse.buildship.ui.internal.view.task.FaultyProjectNode;
import org.eclipse.buildship.ui.internal.view.task.ProjectNode;
import org.eclipse.buildship.ui.internal.view.task.ProjectTask;
import org.eclipse.buildship.ui.internal.view.task.ProjectTaskNode;
import org.eclipse.buildship.ui.internal.view.task.TaskGroupNode;
import org.eclipse.buildship.ui.internal.view.task.TaskNode;
import org.eclipse.buildship.ui.internal.view.task.TaskSelector;
import org.eclipse.buildship.ui.internal.view.task.TaskSelectorNode;
import org.eclipse.buildship.ui.internal.view.task.TaskView;
import org.eclipse.buildship.ui.internal.view.task.TaskViewContent;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.gradle.tooling.model.eclipse.EclipseProject;

public final class TaskViewContentProvider
implements ITreeContentProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private final TaskView taskView;

    public TaskViewContentProvider(TaskView taskView) {
        this.taskView = (TaskView)Preconditions.checkNotNull((Object)taskView);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object input) {
        ImmutableList.Builder result = ImmutableList.builder();
        if (input instanceof TaskViewContent) {
            TaskViewContent taskViewContent = (TaskViewContent)input;
            result.addAll(this.createTopLevelProjectNodes(taskViewContent));
        }
        return result.build().toArray();
    }

    private List<BaseProjectNode> createTopLevelProjectNodes(TaskViewContent taskViewContent) {
        ArrayList allProjectNodes = Lists.newArrayList();
        Collection<BuildNode> builds = taskViewContent.getBuilds();
        if (this.taskView.getState().isProjectHierarchyFlattened()) {
            for (BuildNode build : builds) {
                this.collectProjectNodesRecursively(build.getRootEclipseProject(), null, allProjectNodes, build);
            }
        } else {
            for (BuildNode build : builds) {
                EclipseProject rootEclipseProject = build.getRootEclipseProject();
                Optional workspaceProject = CorePlugin.workspaceOperations().findProjectByName(rootEclipseProject.getName());
                allProjectNodes.add(new ProjectNode(null, build, (Optional<IProject>)workspaceProject, rootEclipseProject));
            }
        }
        for (IProject faultyProject : taskViewContent.getFaultyWorkspaceProjects()) {
            allProjectNodes.add(new FaultyProjectNode(faultyProject));
        }
        return allProjectNodes;
    }

    private void collectProjectNodesRecursively(EclipseProject eclipseProject, ProjectNode parentProjectNode, List<BaseProjectNode> acc, BuildNode buildNode) {
        Optional workspaceProject = CorePlugin.workspaceOperations().findProjectByName(eclipseProject.getName());
        ProjectNode projectNode = new ProjectNode(parentProjectNode, buildNode, (Optional<IProject>)workspaceProject, eclipseProject);
        acc.add(projectNode);
        for (EclipseProject childProject : eclipseProject.getChildren()) {
            this.collectProjectNodesRecursively(childProject, projectNode, acc, buildNode);
        }
    }

    public boolean hasChildren(Object element) {
        return element instanceof ProjectNode || element instanceof TaskGroupNode;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof ProjectNode) {
            return this.childrenOf((ProjectNode)parent);
        }
        if (parent instanceof TaskGroupNode) {
            return this.childrenOf((TaskGroupNode)parent);
        }
        return NO_CHILDREN;
    }

    private Object[] childrenOf(ProjectNode projectNode) {
        HashSet result = Sets.newHashSet();
        if (!this.taskView.getState().isProjectHierarchyFlattened()) {
            result.addAll(this.projectNodesFor(projectNode));
        }
        if (this.taskView.getState().isGroupTasks()) {
            result.addAll(TaskViewContentProvider.groupNodesFor(projectNode));
        } else {
            result.addAll(TaskViewContentProvider.taskNodesFor(projectNode));
        }
        return result.toArray();
    }

    private Set<ProjectNode> projectNodesFor(ProjectNode projectNode) {
        HashSet result = Sets.newHashSet();
        EclipseProject eclipseProject = projectNode.getEclipseProject();
        for (EclipseProject childProject : eclipseProject.getChildren()) {
            Optional workspaceProject = CorePlugin.workspaceOperations().findProjectByName(childProject.getName());
            ProjectNode childProjectNode = new ProjectNode(projectNode, projectNode.getBuildNode(), (Optional<IProject>)workspaceProject, childProject);
            result.add(childProjectNode);
        }
        return result;
    }

    public static Set<TaskGroupNode> groupNodesFor(ProjectNode projectNode) {
        HashSet result = Sets.newHashSet();
        result.add(TaskGroupNode.getDefault(projectNode));
        for (ProjectTask projectTask : projectNode.getInvocations().getProjectTasks()) {
            result.add(TaskGroupNode.forName(projectNode, projectTask.getGroup()));
        }
        for (TaskSelector taskSelector : projectNode.getInvocations().getTaskSelectors()) {
            result.add(TaskGroupNode.forName(projectNode, taskSelector.getGroup()));
        }
        return result;
    }

    public static List<TaskNode> taskNodesFor(ProjectNode projectNode) {
        ArrayList taskNodes = Lists.newArrayList();
        for (ProjectTask projectTask : projectNode.getInvocations().getProjectTasks()) {
            taskNodes.add(new ProjectTaskNode(projectNode, projectTask));
        }
        if (TaskViewContentProvider.shouldContainTaskSelectors(projectNode)) {
            for (TaskSelector taskSelector : projectNode.getInvocations().getTaskSelectors()) {
                taskNodes.add(new TaskSelectorNode(projectNode, taskSelector));
            }
        }
        return taskNodes;
    }

    private static boolean shouldContainTaskSelectors(ProjectNode projectNode) {
        return !projectNode.getBuildNode().isIncludedBuild();
    }

    private Object[] childrenOf(TaskGroupNode groupNode) {
        return groupNode.getTaskNodes().toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof ProjectNode) {
            return ((ProjectNode)element).getParentProjectNode();
        }
        if (element instanceof TaskNode) {
            return ((TaskNode)element).getParentProjectNode();
        }
        if (element instanceof TaskGroupNode) {
            return ((TaskGroupNode)element).getProjectNode();
        }
        return null;
    }

    public void dispose() {
    }
}

