/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.gradle;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.buildship.core.AggregateException;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.util.progress.ToolingApiJob;
import org.eclipse.buildship.core.workspace.ModelProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.gradle.tooling.BuildCancelledException;

public final class LoadEclipseGradleBuildsJob
extends ToolingApiJob {
    private final FetchStrategy modelFetchStrategy;
    private final ImmutableSet<ProjectConfiguration> configurations;

    public LoadEclipseGradleBuildsJob(FetchStrategy modelFetchStrategy, Set<ProjectConfiguration> configurations) {
        super("Loading model of all Gradle builds");
        this.modelFetchStrategy = (FetchStrategy)Preconditions.checkNotNull((Object)modelFetchStrategy);
        this.configurations = ImmutableSet.copyOf(configurations);
    }

    @Override
    protected void runToolingApiJob(IProgressMonitor monitor) throws Exception {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.configurations.size());
        ArrayList exceptions = Lists.newArrayList();
        for (ProjectConfiguration configuration : this.configurations) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                this.fetchEclipseGradleBuildModel(configuration, progress.newChild(1));
            }
            catch (BuildCancelledException e) {
                throw e;
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            throw new AggregateException(exceptions);
        }
    }

    private void fetchEclipseGradleBuildModel(ProjectConfiguration configuration, SubMonitor progress) throws Exception {
        FixedRequestAttributes build = configuration.getRequestAttributes();
        progress.setTaskName(String.format("Loading model of Gradle build at %s", build.getProjectDir()));
        ModelProvider modelProvider = CorePlugin.gradleWorkspaceManager().getGradleBuild(build).getModelProvider();
        modelProvider.fetchEclipseGradleBuild(this.modelFetchStrategy, this.getToken(), (IProgressMonitor)progress);
    }

    public boolean shouldSchedule() {
        Job[] jobs;
        for (Job job : jobs = Job.getJobManager().find((Object)"org.eclipse.buildship.core.jobs")) {
            if (!(job instanceof LoadEclipseGradleBuildsJob)) continue;
            return false;
        }
        return true;
    }
}

